/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import com.sonicsw.deploy.traversal.ExtnTraverserFactory;
import java.io.File;

public class ZipContentTraverser
extends AbstractTraverser {
    public ZipContentTraverser(IArtifact artifact) {
        super(artifact);
        ZipFileArtifact zip = artifact instanceof ZipFileArtifact ? (ZipFileArtifact)this.m_artifact : new ZipFileArtifact(artifact.getPath());
        this.m_artifact = zip;
    }

    @Override
    protected void doTraversal(IArtifactTraversalContext context) throws Exception {
        if (!context.traverseCompressed()) {
            return;
        }
        ZipFileArtifact zip = (ZipFileArtifact)this.m_artifact;
        zip.prepare(context);
        this.traverseDirectory(zip.getLocalArchive(), "", context);
        context.addTraversed(this.m_artifact);
    }

    void traverseDirectory(File dir, String base, IArtifactTraversalContext context) throws Exception {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File item = list[i];
            if (item.isDirectory()) {
                String newBase = base + "/" + item.getName();
                this.traverseDirectory(item, newBase, context);
                continue;
            }
            String artifactName = base + "/" + item.getName();
            ZipContentArtifact subArtifact = new ZipContentArtifact(artifactName, (ZipFileArtifact)this.m_artifact);
            IArtifactTraverser traverser = ExtnTraverserFactory.createTraverser(subArtifact, context);
            if (traverser == null) continue;
            traverser.traverse(context);
        }
    }
}

