/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.config.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.config.IMonitoredContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.MonitoredContainer;
import com.sonicsw.esb.mgmtapi.runtime.IMonitoredContainerRuntimeAPI;
import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.xqimpl.config.IConfigSPI;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

public class MonitoredContainerConfigAPI
implements IMonitoredContainerConfigAPI {
    private static String MONITORED_CONTAINER_LIST_TYPE = "monitored_containers";
    private static final String MONITORED_ELEMENT_PATH = "/workbench/monitored_containers";
    private static final String CONTAINER_LIST_ATT = "CONTAINER_LIST";
    private static final String WS_MAPPING_ELEMENT = "/workspace/mapping/EclipseMap";
    private static final String WS_LOCATION_ATTRIB = "ECLIPSE_WORKSPACE_DISK_LOCATION";
    private static final String CACHE_DIRECTORY_DEFAULT = ".";
    private static final String RUNTIME_LOG_FILE_ATTR = "LogFile";
    private IConfigSPI m_domainConnection;
    private Map m_monitoredContainerList;
    private List m_autoLaunchContainers;
    private IMonitoredContainerRuntimeAPI m_runtimeAPI;

    public MonitoredContainerConfigAPI(IConfigSPI domainConnection) throws ESBAPIException {
        try {
            this.m_domainConnection = domainConnection;
            this.initializeFromMonitoredContainerElement(this.getMonitoredContainerElement());
        }
        catch (Exception ex) {
            throw new ESBAPIException(ex);
        }
    }

    public List getAutoStartContainers() {
        return this.m_autoLaunchContainers;
    }

    public Map getMonitoredMFContainerList() {
        return this.m_monitoredContainerList;
    }

    public void removeMonitoredMFContainer(String containerName) throws ESBAPIException {
        IDirElement containerList;
        block3: {
            containerList = this.getMonitoredContainerElement();
            try {
                if (containerList == null) break block3;
                int listIndex = 0;
                IAttributeList containers = (IAttributeList)containerList.getAttributes().getAttribute(CONTAINER_LIST_ATT);
                while (listIndex < containers.getCount()) {
                    IAttributeList container;
                    Reference containerRef;
                    if (!(containerRef = (Reference)(container = (IAttributeList)containers.getItem(listIndex++)).getItem(0)).getElementName().equals(containerName)) continue;
                    containers.deleteAttributeItem(listIndex - 1);
                    break;
                }
            }
            catch (ReadOnlyException readOnly) {
                throw new ESBAPIException((Exception)((Object)readOnly));
            }
        }
        this.saveMonitoredContainerElement(containerList);
        this.initializeFromMonitoredContainerElement(containerList);
    }

    public void setWorkbenchRoot(String root) throws ESBAPIException {
        try {
            IDirElement mapping = ElementFactory.createElement((String)WS_MAPPING_ELEMENT, (String)"Eclipse_Map", (String)"1.0");
            IAttributeSet topSet = mapping.getAttributes();
            topSet.setStringAttribute(WS_LOCATION_ATTRIB, root);
            this.m_domainConnection.createFSElement(mapping);
        }
        catch (AttributeSetTypeException attrType) {
            throw new ESBAPIException((Exception)((Object)attrType));
        }
        catch (ConfigException config) {
            throw new ESBAPIException((Exception)((Object)config));
        }
    }

    public void setRuntimeAPI(IMonitoredContainerRuntimeAPI api) {
        this.m_runtimeAPI = api;
    }

    public void clearLogFiles(String containerName) throws ESBAPIException {
        if (this.m_domainConnection.hasRuntimeConnection() && this.m_runtimeAPI != null && this.m_runtimeAPI.getMFContainerState(containerName).getState() == 3) {
            this.m_runtimeAPI.clearLogFiles(this.getContainerRuntimeID(containerName));
        } else {
            File curLogFile = this.getMFContainerLogFile(containerName);
            if (curLogFile.exists()) {
                File parentDir = curLogFile.getParentFile();
                File[] logs = parentDir.listFiles();
                for (int i = 0; i < logs.length; ++i) {
                    boolean deleted = false;
                    deleted = !logs[i].equals(curLogFile) ? logs[i].delete() : true;
                    if (deleted) continue;
                    throw new ESBAPIException("Unable to delete log file " + logs[i].getAbsolutePath());
                }
                try {
                    FileOutputStream logOutstream = new FileOutputStream(curLogFile);
                    logOutstream.write(System.getProperty("line.separator").getBytes());
                    logOutstream.write(ContainerUtil.createLogMessage(null, (String)"Container log file truncated", (int)3).getBytes());
                    logOutstream.write(System.getProperty("line.separator").getBytes());
                    logOutstream.close();
                }
                catch (Exception e) {
                    throw new ESBAPIException("Unable to write \"log truncated\" message to log for container " + containerName + ": " + e.toString());
                }
            }
        }
    }

    public File getMFContainerLogFile(String containerName) {
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerName);
        return new File(this.getLogDirectory(containerName), this.m_domainConnection.getDomainName() + CACHE_DIRECTORY_DEFAULT + container.getAttribute("CONTAINER_NAME") + ".log");
    }

    public File[] getRollingLogs(String containerName) {
        File[] children = this.getLogDirectory(containerName).listFiles();
        if (children == null) {
            return new File[0];
        }
        return children;
    }

    private File getLogDirectory(String containerName) {
        File testFile;
        String logFileDir;
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerName);
        if (container == null) {
            throw new ESBAPIException("getMFContainerLogFile failed: container " + containerName + " does not exist");
        }
        if (this.m_domainConnection.hasRuntimeConnection() && this.m_runtimeAPI != null && this.m_runtimeAPI.getMFContainerState(containerName).getState() == 3) {
            String runtimeLogFileDir = null;
            try {
                runtimeLogFileDir = (String)this.m_domainConnection.getRuntimeAttribute(new ObjectName(this.getContainerRuntimeID(containerName) + ":ID=" + "AGENT"), RUNTIME_LOG_FILE_ATTR);
                if (runtimeLogFileDir != null && runtimeLogFileDir.length() > 0) {
                    return new File(runtimeLogFileDir);
                }
            }
            catch (Exception e) {
                throw new ESBAPIException(e);
            }
        }
        if ((logFileDir = (String)container.getAttribute("LOG_FILE")) == null || logFileDir.length() == 0) {
            logFileDir = CACHE_DIRECTORY_DEFAULT;
            testFile = new File(logFileDir, (String)container.getAttribute("CONTAINER_NAME"));
            testFile = new File(testFile, this.m_domainConnection.getDomainName() + CACHE_DIRECTORY_DEFAULT + container.getAttribute("CONTAINER_NAME") + ".log");
            logFileDir = testFile.getPath();
        }
        testFile = new File(logFileDir);
        return testFile;
    }

    public void setMonitoredMFContainerAutoLaunch(String containerName, boolean autoLaunch) throws ESBAPIException {
        this.internalSetMonitoredMFContainerAutoLaunch(containerName, autoLaunch);
    }

    private void internalSetMonitoredMFContainerAutoLaunch(String containerName, boolean autoLaunch) throws ESBAPIException {
        IDirElement monitoredList = this.getMonitoredContainerElement();
        int listIndex = 0;
        IAttributeList container = null;
        IAttributeList containersList = (IAttributeList)monitoredList.getAttributes().getAttribute(CONTAINER_LIST_ATT);
        while (listIndex < containersList.getCount()) {
            IAttributeList containerList;
            Reference containerReference;
            if (!(containerReference = (Reference)(containerList = (IAttributeList)containersList.getItem(listIndex++)).getItem(0)).getElementName().equals(containerName)) continue;
            container = containerList;
            break;
        }
        if (container == null) {
            this.addToMonitoredContainerElement(containersList, containerName, autoLaunch);
        } else {
            try {
                container.deleteAttributeItem(1);
                container.addBooleanItem(new Boolean(autoLaunch));
            }
            catch (Exception e) {
                throw new ESBAPIException(e);
            }
        }
        this.saveMonitoredContainerElement(monitoredList);
        this.initializeFromMonitoredContainerElement(monitoredList);
    }

    public void deleteElement(String id) {
        this.m_domainConnection.deleteElement(id);
    }

    public Map getComponentMap(String containerName, String componentType) {
        HashMap<String, IConfigElement> result = new HashMap<String, IConfigElement>();
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerName);
        if (container == null) {
            throw new ESBAPIException("getComponents failed: container " + containerName + " does not exist");
        }
        IAttributeMap components = (IAttributeMap)container.getAttribute("COMPONENTS");
        Set compNames = components.keySet();
        for (String compName : compNames) {
            Object x = components.get((Object)compName);
            IAttributeMap componentMap = (IAttributeMap)x;
            IConfigBean component = (IConfigBean)componentMap.getAttribute("CONFIG_REF");
            if (!component.getConfigType().getName().equals(componentType)) continue;
            IConfigElement configEl = this.m_domainConnection.loadConfigElement(component.getName());
            result.put(compName, configEl);
        }
        return result;
    }

    public IConfigElement[] getComponents(String containerName, String componentType) {
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerName);
        if (container == null) {
            throw new ESBAPIException("getComponents failed: container " + containerName + " does not exist");
        }
        IAttributeMap components = (IAttributeMap)container.getAttribute("COMPONENTS");
        Collection compCollection = components.values();
        for (Object x : compCollection) {
            IAttributeMap componentMap = (IAttributeMap)x;
            IConfigBean component = (IConfigBean)componentMap.getAttribute("CONFIG_REF");
            if (!component.getConfigType().getName().equals(componentType)) continue;
            IConfigElement configEl = this.m_domainConnection.loadConfigElement(component.getName());
            result.add(configEl);
        }
        IConfigElement[] resultArray = new IConfigElement[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public String getContainerRuntimeID(String containerID) throws ESBAPIException {
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerID);
        if (container == null) {
            throw new ESBAPIException("Container " + containerID + " does not exist");
        }
        String containerName = (String)container.getAttribute("CONTAINER_NAME");
        return this.m_domainConnection.getDomainName() + CACHE_DIRECTORY_DEFAULT + containerName;
    }

    public String getContainerWorkingDirectory(String containerID) throws ESBAPIException {
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerID);
        if (container == null) {
            throw new ESBAPIException("Container " + containerID + " does not exist");
        }
        return this.internalGetContainerWorkingDirectory(container);
    }

    private String internalGetContainerWorkingDirectory(IConfigElement container) {
        return CACHE_DIRECTORY_DEFAULT;
    }

    public Set getAllMFContainers() {
        return this.m_domainConnection.listAllOfType("MF_CONTAINER");
    }

    public String getContainerCacheDirectory(String containerID) throws ESBAPIException {
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerID);
        if (container == null) {
            throw new ESBAPIException("Container " + containerID + " does not exist");
        }
        IAttributeMap cacheAttrs = (IAttributeMap)container.getAttribute("CACHE");
        String hostPath = null;
        if (cacheAttrs != null) {
            hostPath = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY");
        }
        if (hostPath == null) {
            hostPath = CACHE_DIRECTORY_DEFAULT;
        }
        return MonitoredContainerConfigAPI.absoluteFromRelativeToWorkDir(this.internalGetContainerWorkingDirectory(container), hostPath);
    }

    public String getCachePassword(String containerID) throws ESBAPIException {
        IConfigElement container = this.m_domainConnection.loadConfigElement(containerID);
        if (container == null) {
            throw new ESBAPIException("Container " + containerID + " does not exist");
        }
        IAttributeMap cacheAttrs = (IAttributeMap)container.getAttribute("CACHE");
        if (cacheAttrs != null) {
            return (String)cacheAttrs.getAttribute("PASSWORD");
        }
        return null;
    }

    private static String absoluteFromRelativeToWorkDir(String workingDirectory, String path) throws ESBAPIException {
        if (workingDirectory == null || path == null || new File(path).isAbsolute()) {
            return path;
        }
        return MonitoredContainerConfigAPI.getCanonicalPath(new File(workingDirectory, path));
    }

    static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    private IDirElement getMonitoredContainerElement() throws ESBAPIException {
        IDirElement containerList;
        block3: {
            containerList = null;
            try {
                containerList = this.m_domainConnection.getElement(MONITORED_ELEMENT_PATH, true);
            }
            catch (ESBAPIException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DirectoryDoesNotExistException) break block3;
                throw e;
            }
        }
        if (containerList == null) {
            containerList = this.createMonitoredContainerElement();
        }
        return containerList;
    }

    private void initializeFromMonitoredContainerElement(IDirElement element) throws ESBAPIException {
        this.m_autoLaunchContainers = new ArrayList();
        this.m_monitoredContainerList = new HashMap();
        if (element != null) {
            IAttributeList containers = (IAttributeList)element.getAttributes().getAttribute(CONTAINER_LIST_ATT);
            int listIndex = 0;
            while (listIndex < containers.getCount()) {
                IAttributeList container = (IAttributeList)containers.getItem(listIndex++);
                String containerName = ((Reference)container.getItem(0)).getElementName();
                boolean autoStart = (Boolean)container.getItem(1);
                this.m_monitoredContainerList.put(containerName, new MonitoredContainer(containerName, autoStart));
                if (!autoStart) continue;
                this.m_autoLaunchContainers.add(containerName);
            }
        }
    }

    private void addToMonitoredContainerElement(IAttributeList containersList, String containerName, boolean autoLaunch) throws ESBAPIException {
        try {
            IAttributeList container = containersList.addNewAttributeListItem();
            container.addReferenceItem(new Reference(containerName));
            container.addBooleanItem(new Boolean(autoLaunch));
        }
        catch (ReadOnlyException readE) {
            throw new ESBAPIException((Exception)((Object)readE));
        }
    }

    private IDirElement createMonitoredContainerElement() throws ESBAPIException {
        try {
            IDirElement listElement = ElementFactory.createElement((String)MONITORED_ELEMENT_PATH, (String)MONITORED_CONTAINER_LIST_TYPE, (String)"109");
            listElement.getAttributes().createAttributeList(CONTAINER_LIST_ATT);
            return listElement;
        }
        catch (ConfigException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    private void saveMonitoredContainerElement(IDirElement element) throws ESBAPIException {
        this.m_domainConnection.setElement(element, true);
    }
}

