/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactMerge;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.CopyAction;
import com.sonicsw.deploy.action.ImpactAnalysisAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.storage.ZipArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.traversal.TraverserFactory;

public class MergeAction
extends ImpactAnalysisAction
implements IArtifactMerge {
    public MergeAction() {
        this.m_defaultFileName = "Sonic_Merge.xml";
    }

    @Override
    public void run(IArtifactStorage sourceStore, IArtifactStorage targetStore) throws Exception {
        super.run(sourceStore, targetStore);
        IArtifact[] artifactsToMerge = this.m_artifactsToMerge.toArray(new IArtifact[0]);
        CopyAction.copyTo(sourceStore, targetStore, artifactsToMerge);
    }

    @Override
    public void run(IArtifactStorage sourceStore, IArtifactStorage targetStore, IArtifactStorage destinationStore) throws Exception {
        destinationStore.deleteAll();
        IArtifact[] allArtifacts = SearchAction.search(targetStore, ExportPropertiesArtifact.getDefaultIgnore(), TraverserFactory.createListAllTraverser());
        CopyAction.copyTo(targetStore, destinationStore, allArtifacts);
        this.run(sourceStore, destinationStore);
        if (destinationStore instanceof ZipArtifactStorage) {
            ((ZipArtifactStorage)destinationStore).saveArchive();
        }
    }
}

