/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.EndpointDocument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public abstract class MQDependencyBase {
    protected IArtifactStorage m_Store;
    protected Vector m_endpointList = new Vector();
    protected Vector m_connectionList = new Vector();
    protected ArrayList m_mqDestinationList = new ArrayList();
    protected ArrayList m_mqConnectionList = new ArrayList();
    protected String m_reportDate = new Date(System.currentTimeMillis()).toString();

    public void addEndpoint(EndpointDocument item) {
        this.m_endpointList.add(item);
    }

    public void addConnection(ConnectionDocument item) {
        this.m_connectionList.add(item);
    }

    public void setArtifactLists(IArtifactStorage store, IArtifact[] artifacts) throws IOException, Exception {
        for (int i = 0; i < artifacts.length; ++i) {
            String data;
            if (!(artifacts[i] instanceof ESBArtifact)) continue;
            String path = artifacts[i].getParentPath();
            if (path.equals(ESBArtifact.ENDPOINT.getPath())) {
                data = store.getContentsAsString(artifacts[i]);
                this.addEndpoint(EndpointDocument.Factory.parse(data));
                continue;
            }
            if (!path.equals(ESBArtifact.CONNECTION.getPath())) continue;
            data = store.getContentsAsString(artifacts[i]);
            this.addConnection(ConnectionDocument.Factory.parse(data));
        }
    }

    public void performDependencyAnalysis() throws IOException {
        int i;
        for (i = 0; i < this.m_connectionList.size(); ++i) {
            ConnectionDocument connection = (ConnectionDocument)this.m_connectionList.get(i);
            this.handleConnection(connection);
        }
        this.completeConnectionAnalysis();
        for (i = 0; i < this.m_endpointList.size(); ++i) {
            EndpointDocument endpoint = (EndpointDocument)this.m_endpointList.get(i);
            this.handleEndpoint(endpoint);
        }
        this.completeEndpointAnalysis();
    }

    protected abstract void completeConnectionAnalysis();

    protected abstract void completeEndpointAnalysis();

    public abstract void generateReport(File var1, String var2) throws IOException;

    protected abstract void handleEndpoint(EndpointDocument var1);

    protected abstract void handleConnection(ConnectionDocument var1);
}

