/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.Diff;
import com.sonicsw.sonicxq.DiffXmlArtifactType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlDiff
extends Diff {
    private ArrayList m_sourceElementDiffs = new ArrayList();
    private ArrayList m_targetElementDiffs = new ArrayList();
    private XMLSerializer m_xmlSerializer;
    private static int matchNotFound = -1;
    private ByteArrayOutputStream m_outputStream = new ByteArrayOutputStream();
    public static final String whitespaceChars = " \n\f\t\r";

    public XmlDiff(IArtifactStorage srcStore, IArtifactStorage trgStore) {
        super(srcStore, trgStore);
        OutputFormat serializeFormat = new OutputFormat();
        serializeFormat.setIndenting(false);
        serializeFormat.setOmitXMLDeclaration(true);
        this.m_xmlSerializer = new XMLSerializer((OutputStream)this.m_outputStream, serializeFormat);
    }

    @Override
    public Object diffArtifact(IArtifact src, IArtifact trg) throws Exception {
        Document trgAsDom;
        Document srcAsDom;
        try {
            srcAsDom = this.m_sourceStore.getContentsAsDom(src);
            trgAsDom = this.m_targetStore.getContentsAsDom(trg);
        }
        catch (Exception e) {
            String msg = "Error parsing XML document " + src.getName() + ".  Error: " + e.getMessage();
            System.out.println(msg);
            return null;
        }
        Element srcRoot = srcAsDom.getDocumentElement();
        Element trgRoot = trgAsDom.getDocumentElement();
        this.m_sourceElementDiffs.clear();
        this.m_targetElementDiffs.clear();
        this.walkTree(srcRoot, trgRoot, 0);
        return this.formDiffRecord(src.getArchivePath());
    }

    private void walkTree(Element srcElementBase, Element trgElementBase, int recursionLevelParam) throws IOException {
        int recursionLevel = recursionLevelParam;
        Element[] srcElementList = this.getSiblingElementList(srcElementBase);
        Element[] trgElementList = this.getSiblingElementList(trgElementBase);
        boolean[] srcElementFound = this.initElementFoundArray(srcElementList.length);
        boolean[] trgElementFound = this.initElementFoundArray(trgElementList.length);
        ++recursionLevel;
        for (int i = 0; i < srcElementList.length; ++i) {
            int trgElementPos = this.compareElements(srcElementList[i], trgElementList, trgElementFound);
            if (trgElementPos == matchNotFound) continue;
            Element srcChild = this.getFirstChildElement(srcElementList[i]);
            Element trgChild = this.getFirstChildElement(trgElementList[trgElementPos]);
            if (srcChild != null && trgChild != null) {
                this.walkTree(srcChild, trgChild, recursionLevel);
            }
            trgElementFound[trgElementPos] = true;
            srcElementFound[i] = true;
        }
        this.reportDiffsFound(this.m_sourceElementDiffs, srcElementList, srcElementFound);
        this.reportDiffsFound(this.m_targetElementDiffs, trgElementList, trgElementFound);
    }

    private Element[] getSiblingElementList(Element element) {
        ArrayList<Node> siblings = new ArrayList<Node>();
        siblings.add(element);
        if (element != null) {
            Node siblingNode = element;
            while ((siblingNode = siblingNode.getNextSibling()) != null) {
                if (siblingNode.getNodeType() != 1) continue;
                siblings.add(siblingNode);
            }
        }
        return siblings.toArray(new Element[0]);
    }

    private Element getFirstChildElement(Node parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    private int compareElements(Element srcElement, Element[] trgElementList, boolean[] trgElementFound) {
        for (int i = 0; i < trgElementList.length; ++i) {
            if (trgElementFound[i] || !this.compareElement(srcElement, trgElementList[i])) continue;
            return i;
        }
        return matchNotFound;
    }

    private boolean compareElement(Element srcElement, Element trgElement) {
        if (!srcElement.getLocalName().equalsIgnoreCase(trgElement.getLocalName())) {
            return false;
        }
        if (!this.compareAttributes(srcElement, trgElement)) {
            return false;
        }
        NodeList srcNodes = srcElement.getChildNodes();
        NodeList trgNodes = trgElement.getChildNodes();
        if (srcNodes.getLength() == trgNodes.getLength()) {
            for (int i = 0; i < srcNodes.getLength(); ++i) {
                if (this.matchNode(srcNodes.item(i), trgNodes)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean compareAttributes(Element srcElement, Element trgElement) {
        int i;
        int trgAttrListLen;
        boolean isEqual = true;
        NamedNodeMap srcAttrList = srcElement.getAttributes();
        NamedNodeMap trgAttrList = trgElement.getAttributes();
        int srcAttrListLen = srcAttrList.getLength();
        if (srcAttrListLen != (trgAttrListLen = trgAttrList.getLength())) {
            return false;
        }
        boolean[] attrMatchFound = this.initElementFoundArray(trgAttrListLen);
        for (i = srcAttrListLen - 1; i >= 0; --i) {
            Attr srcAttr = (Attr)srcAttrList.item(i);
            int matchIndex = this.findMatchingAttribute(srcAttr, trgAttrList);
            if (matchIndex != matchNotFound) {
                attrMatchFound[matchIndex] = true;
                continue;
            }
            isEqual = false;
        }
        for (i = 0; i < attrMatchFound.length; ++i) {
            if (attrMatchFound[i]) continue;
            Attr attr = (Attr)srcAttrList.item(i);
        }
        return isEqual;
    }

    private int findMatchingAttribute(Attr srcAttr, NamedNodeMap trgAttrList) {
        String srcName = srcAttr.getName();
        String srcVal = srcAttr.getValue();
        for (int i = 0; i < trgAttrList.getLength(); ++i) {
            Attr trgAttr = (Attr)trgAttrList.item(i);
            if (!srcName.equals(trgAttr.getName()) || !srcVal.equals(trgAttr.getValue())) continue;
            return i;
        }
        return matchNotFound;
    }

    private boolean matchNode(Node srcNode, NodeList trgNodes) {
        block3: for (int i = 0; i < trgNodes.getLength(); ++i) {
            Node trgNode = trgNodes.item(i);
            short nodeType = srcNode.getNodeType();
            if (nodeType != trgNode.getNodeType()) continue;
            switch (nodeType) {
                case 3: 
                case 4: 
                case 8: {
                    String srcVal = srcNode.getNodeValue();
                    String trgVal = trgNode.getNodeValue();
                    if (srcVal == null && trgVal == null) {
                        return true;
                    }
                    if (srcVal == null || trgVal == null) continue block3;
                    if (this.isWhiteSpace(srcVal) && this.isWhiteSpace(trgVal)) {
                        return true;
                    }
                    if (!srcVal.equals(trgVal)) continue block3;
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isWhiteSpace(String str) {
        StringTokenizer tokenizer = new StringTokenizer(str, whitespaceChars);
        return tokenizer.countTokens() == 0;
    }

    private boolean[] initElementFoundArray(int len) {
        boolean[] elementFound = new boolean[len];
        for (int i = 0; i < elementFound.length; ++i) {
            elementFound[i] = false;
        }
        return elementFound;
    }

    private void reportDiffsFound(ArrayList list, Element[] elementList, boolean[] elementFound) throws IOException {
        for (int i = 0; i < elementList.length; ++i) {
            if (elementFound[i]) continue;
            Element missingTrgElement = (Element)elementList[i].cloneNode(false);
            this.m_xmlSerializer.serialize(missingTrgElement);
            String diff = this.m_outputStream.toString();
            this.m_outputStream.reset();
            list.add(diff);
        }
    }

    private DiffXmlArtifactType formDiffRecord(String path) {
        if (this.m_sourceElementDiffs.size() == 0 && this.m_targetElementDiffs.size() == 0) {
            return null;
        }
        DiffXmlArtifactType diffRecord = DiffXmlArtifactType.Factory.newInstance();
        diffRecord.setPath(path);
        diffRecord.setSourceArray(this.m_sourceElementDiffs.toArray(new String[0]));
        diffRecord.setTargetArray(this.m_targetElementDiffs.toArray(new String[0]));
        return diffRecord;
    }
}

