/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.common;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Utils {
    private static final String CONTEXT_FACTORY = "com.sonicsw.xqimpl.jndi.spi.XQTNSContextFactory";
    private static final String AGENT_ID = "AGENT";

    public static Hashtable createConnectorMap(String url, String user, String password) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("BrokerURL", url);
        if (user != null && user.length() > 0) {
            map.put("DefaultUser", user);
        }
        if (password != null && password.length() > 0) {
            map.put("DefaultPassword", password);
        }
        return map;
    }

    public static Hashtable<String, String> createContextMap(String domain, String url, String user, String password) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("java.naming.factory.initial", CONTEXT_FACTORY);
        map.put("java.naming.provider.url", url);
        map.put("DOMAIN_NAME", domain);
        if (user != null && user.length() > 0) {
            map.put("java.naming.security.principal", user);
        }
        if (password != null && password.length() > 0) {
            map.put("java.naming.security.credentials", password);
        }
        return map;
    }

    public static final ObjectName createObjectName(String domain, String container, String id) throws MalformedObjectNameException {
        return new ObjectName(Utils.createCanonicalName(domain, container, id));
    }

    public static final ObjectName createAgentName(String domain, String container) throws MalformedObjectNameException {
        return new ObjectName(Utils.createAgentCanonicalName(domain, container));
    }

    public static final String createCanonicalName(String domain, String container, String id) {
        StringBuilder buffer = new StringBuilder(domain);
        buffer.append('.').append(container).append(':');
        buffer.append("ID=").append(id);
        return buffer.toString();
    }

    public static final String createAgentCanonicalName(String domain, String container) {
        return Utils.createCanonicalName(domain, container, AGENT_ID);
    }
}

