/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactComparison;
import com.sonicsw.deploy.IArtifactMatcher;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.MatchResult;

public class Matcher
implements IArtifactMatcher {
    private final IArtifact m_artifact;

    public Matcher(IArtifact artifact) {
        this.m_artifact = artifact;
    }

    public IArtifact getArtifact() {
        return this.m_artifact;
    }

    @Override
    public IArtifactComparison match(IArtifactStorage source, IArtifactStorage destination) {
        MatchResult result = new MatchResult(this.m_artifact);
        boolean existsInSource = false;
        boolean existsInDestination = false;
        try {
            existsInSource = source.exists(this.m_artifact);
            existsInDestination = destination.exists(this.m_artifact);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (existsInSource == existsInDestination) {
            result.setEqual(true);
        } else {
            result.setEqual(false);
            result.setMessage("Artifact " + this.m_artifact + " not present in " + (existsInSource ? destination.toString() : source.toString()));
        }
        return result;
    }
}

