/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.impl;

import com.sonicsw.esb.mgmtapi.ESBAPIContext;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.ListContainsExpression;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.jmx.client.IConnectionListener;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.util.SonicFSException;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.config.IConfigSPI;
import com.sonicsw.xqimpl.config.IConfiguration;
import com.sonicsw.xqimpl.config.XQConfigHelper;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQViewHelper;
import com.sonicsw.xqimpl.mgmtapi.config.XQMgmtBeanFactory;
import com.sonicsw.xqimpl.mgmtapi.config.impl.XQContainerBean;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ConfigBase
implements IConfigSPI {
    protected XQMgmtBeanFactory m_esbBeanFactory = null;
    protected IConfigServer m_configServer = null;
    IDirectoryFileSystemService m_fsService = null;
    IDirectoryAdminService m_adminService = null;
    protected IConnectionListener m_connectionListener = null;
    protected XQViewHelper m_xqVhelper = null;
    protected String url;
    protected String user;
    protected String password;
    protected String domainName;
    protected long requestTimeout;
    protected long socketConnectionTimeout;
    protected long connectTimeout;
    protected XQConfigManager m_configManager = null;
    protected SonicFSFileSystem m_sfs = null;
    String m_domainName = null;

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getSocketConnectionTimeout() {
        return this.socketConnectionTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setSocketConnectionTimeout(long socketConnectionTimeout) {
        this.socketConnectionTimeout = socketConnectionTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public abstract void connect();

    public abstract void disconnect();

    public String[] listConfigurations(String type) throws ESBAPIException {
        try {
            Map map = this.m_configManager.listElementsName(type);
            String[] ret = new String[map.size()];
            int i = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                ret[i++] = (String)iter.next();
            }
            return ret;
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public boolean doesConfigurationExist(String name, String type) {
        return this.m_configManager.doesElementExist(name, type);
    }

    public IConfiguration getConfiguration(String name, String type) throws ESBAPIException {
        ESBAPIContext ctx = new ESBAPIContext("get config");
        ctx.setObjectType(type);
        ctx.setObjectId(name);
        try {
            return this.m_configManager.lookupSafe(name, type);
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e), ctx);
        }
    }

    public void saveConfiguration(IConfiguration config) throws ESBAPIException {
        try {
            config.writeToDS();
            this.m_configManager.writeComponentToDS(config, config.getName(), config.getType());
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public IConfiguration createConfiguration(String name, String type) throws ESBAPIException {
        ESBAPIContext ctx = new ESBAPIContext("creating new configuration");
        ctx.setObjectId(name);
        ctx.setObjectType(type);
        ctx.setOperation("check duplicate");
        if (this.doesConfigurationExist(name, type)) {
            throw new ESBAPIException(ctx);
        }
        ctx.setOperation("creating config");
        IConfiguration config = XQConfigHelper.createConfigObject((XQConfigManager)this.m_configManager, (String)type);
        ctx.setOperation("create element");
        ((XQConfiguration)config).createElement(name);
        return config;
    }

    public IMgmtBeanBase getBean(IConfigSPI.ConfigBeanType type, String id) {
        if (type == MFCONTAINER_BEAN) {
            try {
                return this.m_esbBeanFactory.getBean(id);
            }
            catch (MgmtException e) {
                throw new ESBAPIException((Exception)((Object)e));
            }
        }
        return null;
    }

    public IConfigElement createConfigBean(String configID, String type, String releaseVersion) throws ESBAPIException {
        try {
            return this.m_configServer.createConfigBean(configID, type, releaseVersion, false);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public Map getMetaAttributes(String path) throws ESBAPIException {
        try {
            return this.m_configServer.getMetaAttributes(path);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public void setMetaAttributes(String path, Map attrs) throws ESBAPIException {
        try {
            this.m_configServer.setMetaAttributes(path, attrs);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public void deleteConfiguration(String name, String type) throws ESBAPIException {
        try {
            this.m_configManager.deleteElement(name, type);
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void setConnectionListener(IConnectionListener listener) {
        this.m_connectionListener = listener;
    }

    public IConfigElement loadConfigElement(String configName) throws ESBAPIException {
        try {
            return this.m_configServer.loadConfigElement(configName);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public IDirElement getElement(String configName, boolean forUpdate) throws ESBAPIException {
        try {
            return this.m_adminService.getElement(configName, forUpdate);
        }
        catch (DirectoryServiceException dirE) {
            throw new ESBAPIException((Exception)((Object)dirE));
        }
    }

    public void setElement(IDirElement element, boolean createDirectories) throws ESBAPIException {
        try {
            if (createDirectories) {
                String[] names = element.getIdentity().getNameComponents();
                String name = "/" + names[0];
                if (names.length > 1) {
                    for (int i = 1; i < names.length - 1; ++i) {
                        name = name + "/" + names[i];
                    }
                }
                this.m_configManager.createDirectoryAndParents(name);
            }
            this.m_adminService.setElement(element.doneUpdate(), null);
        }
        catch (ReadOnlyException dirE) {
            throw new ESBAPIException((Exception)((Object)dirE));
        }
        catch (DirectoryServiceException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void deleteElement(String configID) throws ESBAPIException {
        try {
            this.m_adminService.deleteElement(configID, null);
        }
        catch (VersionOutofSyncException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
        catch (DirectoryServiceException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void storeConfigElement(IConfigElement configElement) throws ESBAPIException {
        try {
            this.m_configServer.storeConfigElement(configElement);
        }
        catch (ConfigServiceException configE) {
            throw new ESBAPIException((Exception)((Object)configE));
        }
    }

    public void createFSElement(IDirElement newEl) {
        try {
            this.m_fsService.createFSElement(newEl);
        }
        catch (DirectoryServiceException ex) {
            throw new ESBAPIException((Exception)((Object)ex));
        }
    }

    public Set listAllOfType(String type) throws ESBAPIException {
        Query typeQuery = new Query();
        typeQuery.setFrom((From)new FromElementType(type));
        try {
            return this.m_configServer.listConfigElements(typeQuery);
        }
        catch (ConfigServiceException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void importFile(String source, String sonicfs, boolean overwrite) throws ESBAPIException {
        try {
            this.m_sfs.createDirectoryPath(sonicfs.substring(0, sonicfs.lastIndexOf(47)));
            if (overwrite) {
                this.m_sfs.updateFile(sonicfs, source, true);
            } else {
                this.m_sfs.createFile(sonicfs, source);
            }
        }
        catch (SonicFSException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void exportFile(String sonicfs, String dest, boolean overwrite) throws ESBAPIException {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            ((OutputStream)out).write(this.m_sfs.getContentBytes(sonicfs));
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new ESBAPIException((Exception)e);
        }
        catch (SonicFSException sfs) {
            throw new ESBAPIException((Exception)((Object)sfs));
        }
    }

    public InputStream fetchFile(String fullPath) {
        IOException failure = null;
        ESBAPIContext ctx = new ESBAPIContext("fetch file");
        ctx.setDescr(fullPath);
        try {
            ctx.setOperation("parse url");
            URL u = new URL(fullPath);
            ctx.setOperation("open connection");
            URLConnection connection = u.openConnection();
            connection.setRequestProperty("java.naming.provider.url", this.url);
            connection.setRequestProperty("DOMAIN_NAME", this.domainName);
            ctx.setOperation("get inputstream");
            return connection.getInputStream();
        }
        catch (MalformedURLException e) {
            failure = e;
        }
        catch (IOException e) {
            failure = e;
        }
        if (failure != null) {
            throw new ESBAPIException((Exception)failure, ctx);
        }
        return null;
    }

    public Set executePhysQuery(String sourceType, String attributeName, String matches, String desiredName) {
        IDirElement[] elements = null;
        Query q = new Query();
        FromDirectory f = new FromDirectory(sourceType);
        q.setFrom((From)f);
        AttributeName name = new AttributeName(attributeName);
        EqualExpression b = new EqualExpression(name, matches);
        elements = this.getIDirElements((BooleanExpression)b, q);
        return ConfigBase.addDesiredAttrToRet(desiredName, elements);
    }

    public Set executePhysQueryListContains(String sourceType, String attributeName, String contains, String desiredName) {
        IDirElement[] elements = null;
        Query q = new Query();
        FromDirectory f = new FromDirectory(sourceType);
        q.setFrom((From)f);
        AttributeName name = new AttributeName(attributeName);
        ListContainsExpression b = new ListContainsExpression(name, contains);
        elements = this.getIDirElements((BooleanExpression)b, q);
        return ConfigBase.addDesiredAttrToRet(desiredName, elements);
    }

    private IDirElement[] getIDirElements(BooleanExpression b, Query q) {
        IDirElement[] elements = null;
        Where where = new Where(new BooleanExpression[]{b});
        q.setWhere(where);
        try {
            elements = this.m_adminService.getElements(q, false);
        }
        catch (DirectoryServiceException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
        return elements;
    }

    public Set executeLogicQueryListContains(String sourceType, String attributeName, String contains, String desiredName) {
        IDirElement[] elements = null;
        Query q = new Query();
        FromElementType f = new FromElementType(sourceType);
        q.setFrom((From)f);
        AttributeName name = new AttributeName(attributeName);
        ListContainsExpression b = new ListContainsExpression(name, contains);
        Where where = new Where(new BooleanExpression[]{b});
        q.setWhere(where);
        try {
            elements = this.m_fsService.getFSElements(q, false);
        }
        catch (DirectoryServiceException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
        return ConfigBase.addDesiredAttrToRet(desiredName, elements);
    }

    private static Set addDesiredAttrToRet(String desiredName, IDirElement[] elements) {
        AttributeName desiredAttr = new AttributeName(desiredName);
        HashSet<Object> ret = new HashSet<Object>();
        for (int j = 0; j < elements.length; ++j) {
            IDirElement elm = elements[j];
            Object attribute = elm.getAttribute(desiredAttr);
            ret.add(attribute);
        }
        return ret;
    }

    public String exportConfiguration(IConfiguration config) {
        try {
            config.writeToDS();
            return config.serializeToXML();
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public IConfiguration importConfiguration(String content, String type, boolean overwrite, boolean validate) {
        try {
            IConfiguration component = XQConfigHelper.createConfigObject((XQConfigManager)this.m_configManager, (String)type);
            component.initFromXMLString(null, content, validate, !overwrite);
            component.initFromDS(component.getElement());
            this.saveConfiguration(component);
            return component;
        }
        catch (XQConfigurationException e) {
            throw new ESBAPIException((Exception)((Object)e));
        }
    }

    public void addXQContainerToMFContainer(String mfContainerName, String xqContainerName, boolean createMissing) {
        ESBAPIContext ctx = new ESBAPIContext("creating new configuration");
        ctx.setObjectId(mfContainerName);
        ctx.setObjectType("XQ_CONTAINER");
        try {
            IDirElement mfContainerElement;
            block6: {
                ctx.setOperation("check MF exists");
                mfContainerElement = null;
                try {
                    mfContainerElement = this.m_fsService.getFSElement(mfContainerName, true);
                }
                catch (DirectoryServiceException e) {
                    if (createMissing) break block6;
                    throw new ESBAPIException((Exception)((Object)e), ctx);
                }
            }
            IContainerBean mfContainer = null;
            if (mfContainerElement == null) {
                ctx.setOperation("createmf container");
                mfContainer = this.m_esbBeanFactory.createContainerBean(mfContainerName);
                IContainerBean.IConnectionType connection = mfContainer.getConnection();
                connection.setConnectionURLs(this.url);
                connection.setDefaultUser(this.user);
                connection.setDefaultPassword(this.password);
            } else {
                ctx.setOperation("get mf container");
                mfContainer = this.m_esbBeanFactory.getContainerBean(mfContainerName);
            }
            IContainerBean.IComponentsType components = mfContainer.getComponents();
            ctx.setOperation("get esb container");
            XQContainerBean xqBean = new XQContainerBean((MgmtBeanFactory)this.m_esbBeanFactory);
            xqBean.loadBean("/ESB Containers//" + xqContainerName, "XQ_CONTAINER");
            ctx.setOperation("create startup params");
            IContainerBean.IStartupParams startupParams = components.createEntry();
            startupParams.setAutoStart(true);
            startupParams.setConfigRef((IMgmtBeanBase)xqBean);
            ctx.setOperation("add entry");
            components.addEntry(xqContainerName, startupParams);
            ctx.setOperation("save mf container");
            this.m_esbBeanFactory.saveContainerBean(mfContainer);
            ctx.setOperation("commit");
            this.m_esbBeanFactory.commit();
        }
        catch (MgmtException e) {
            throw new ESBAPIException((Exception)((Object)e), ctx);
        }
    }

    public void removeXQContainerFromMFContainer(String mfContainerName, String xqContaienrName) {
        ESBAPIContext ctx = new ESBAPIContext("");
        ctx.setObjectId(mfContainerName);
        ctx.setObjectType(IConfigSPI.MFCONTAINER_BEAN.getName());
        try {
            IContainerBean mfContainer = null;
            ctx.setOperation("get mf container");
            mfContainer = this.m_esbBeanFactory.getContainerBean(mfContainerName);
            ctx.setDescr("get componenets");
            IContainerBean.IComponentsType components = mfContainer.getComponents();
            ctx.setDescr("remove ESB container");
            components.removeAttribute(xqContaienrName);
            this.m_esbBeanFactory.commit();
        }
        catch (MgmtException e) {
            throw new ESBAPIException((Exception)((Object)e), ctx);
        }
    }
}

