/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactComparator;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.compare.ConfigBeanComparator;
import com.sonicsw.deploy.compare.ESBComparator;
import com.sonicsw.deploy.compare.SonicFSComparator;

public final class ComparatorFactory {
    public static IArtifactComparator createComparator(IArtifact artifact) throws Exception {
        if (artifact == null) {
            throw new Exception("createComparator(null) is not valid");
        }
        if (artifact.isRootPath() || artifact.isDirectory()) {
            throw new Exception("createComparator for a directory is not supported");
        }
        if (artifact instanceof ESBArtifact) {
            return new ESBComparator(artifact);
        }
        if (artifact instanceof SonicFSArtifact) {
            return new SonicFSComparator(artifact);
        }
        if (artifact instanceof ConfigBeanArtifact) {
            return new ConfigBeanComparator(artifact);
        }
        throw new UnsupportedOperationException("Not yet implemeneted");
    }
}

