/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl;

import com.sonicsw.esb.client.CompletionReferee;
import com.sonicsw.esb.client.CountCompletionReferee;
import com.sonicsw.esb.client.ExchangePattern;
import com.sonicsw.esb.client.FaultAndRMEReceiveOption;
import com.sonicsw.esb.client.Output;
import com.sonicsw.esb.client.impl.ExchangeInternal;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;

public class ExchangeImpl
implements ExchangeInternal {
    private XQAddress m_addressee;
    private XQQualityofService m_qos = XQQualityofService.BEST_EFFORT;
    private XQMessage m_in;
    private XQEnvelope m_inEnv;
    private Output m_out;
    private ExchangePattern m_pattern;
    private CompletionReferee m_referee;
    private XQEnvelopeFactory m_localEnvFactImpl = new EnvelopeFactory();
    private FaultAndRMEReceiveOption m_option;

    public ExchangeImpl(ExchangePattern pattern) {
        this.m_pattern = pattern;
        this.m_referee = new CountCompletionReferee(1);
        this.m_option = FaultAndRMEReceiveOption.FAULTS_AND_RMES;
    }

    @Override
    public void setQOS(XQQualityofService qos) {
        this.m_qos = qos;
    }

    @Override
    public void setFaultAndRMEReceiveOption(FaultAndRMEReceiveOption option) {
        this.m_option = option;
    }

    @Override
    public void setAddressee(XQAddress address) {
        this.m_addressee = address;
        if (this.m_addressee != null) {
            this.m_inEnv = null;
        }
    }

    @Override
    public void setInput(XQMessage in) {
        this.m_in = in;
        if (this.m_in != null) {
            this.m_inEnv = null;
        }
    }

    @Override
    public void setInputAsAddressedEnvelope(XQEnvelope in) {
        this.m_inEnv = in;
        if (this.m_inEnv != null) {
            this.m_addressee = null;
            this.m_in = null;
        }
    }

    @Override
    public void setExchangePattern(ExchangePattern pattern) {
        this.m_pattern = pattern;
    }

    @Override
    public void setCompletionReferee(CompletionReferee referee) {
        this.m_referee = referee;
    }

    @Override
    public void setOutput(Output o) {
        this.m_out = o;
    }

    @Override
    public XQQualityofService getQOS() {
        return this.m_qos;
    }

    @Override
    public FaultAndRMEReceiveOption getFaultAndRMEReceiveOption() {
        return this.m_option;
    }

    @Override
    public XQAddress getAddressee() {
        return this.m_addressee;
    }

    @Override
    public XQMessage getInput() {
        return this.m_in;
    }

    @Override
    public XQEnvelope getInputAsAddressedEnvelope() {
        if (this.m_inEnv != null) {
            return this.m_inEnv;
        }
        XQEnvelope env = this.m_localEnvFactImpl.createTargetedEnvelope(this.m_addressee, this.m_in);
        return env;
    }

    @Override
    public Output getOutput() {
        return this.m_out;
    }

    @Override
    public ExchangePattern getExchangePattern() {
        return this.m_pattern;
    }

    @Override
    public CompletionReferee getCompletionReferee() {
        return this.m_referee;
    }
}

