/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl.interior;

import com.sonicsw.esb.client.ESBClientException;
import com.sonicsw.esb.client.ESBClientTimeoutException;
import com.sonicsw.esb.client.ESBInteractor;
import com.sonicsw.esb.client.EndpointListener;
import com.sonicsw.esb.client.Exchange;
import com.sonicsw.esb.client.ExchangeListener;
import com.sonicsw.esb.client.ExchangePattern;
import com.sonicsw.esb.client.FaultAndRMEReceiveOption;
import com.sonicsw.esb.client.ListenerAlreadyRegistered;
import com.sonicsw.esb.client.ProcessOutputListener;
import com.sonicsw.esb.client.ServiceOutputListener;
import com.sonicsw.esb.client.impl.ExchangeInternal;
import com.sonicsw.esb.client.impl.OutputImpl;
import com.sonicsw.esb.client.impl.interior.ColocExchangeImpl;
import com.sonicsw.esb.client.impl.interior.ExchangeDirector;
import com.sonicsw.esb.client.impl.util.Utils;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalVisitor;
import com.sonicsw.xqimpl.container.ICorrelatedTimedListener;
import com.sonicsw.xqimpl.container.IRegistration;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import java.util.Iterator;

public class ESBColocInteractorImpl
implements ESBInteractor {
    private String m_apiId;
    private XQDispatch m_dispatch;
    private ExchangeDirector m_exchangeDirector;

    public ESBColocInteractorImpl(XQParameters parms, XQDispatch dispatch) throws Exception {
        String serviceName = parms.getParameter("SonicXQ.ServiceInstanceName", 1);
        String modelName = ESBColocInteractorImpl.getModelEndpoint(parms);
        this.m_apiId = serviceName;
        this.m_dispatch = dispatch;
        this.m_exchangeDirector = new ExchangeDirector(this.m_apiId, modelName);
    }

    private static String getModelEndpoint(XQParameters params) {
        XQAddress entryEndpoint = (XQAddress)params.getParameterObject("SonicXQ.EntryEndpointAddress", 3);
        if (entryEndpoint != null) {
            return entryEndpoint.getName();
        }
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public void performExchange(Exchange aex, long timeout) throws ESBClientTimeoutException, ESBClientException {
        this.performExchangeInternal(aex, timeout, null);
    }

    private void performExchangeInternal(Exchange aex, long timeout, ExchangeListener listener) throws ESBClientTimeoutException, ESBClientException {
        if (aex.getExchangePattern() == ExchangePattern.IN_ONLY) {
            XQEnvelope env = aex.getInputAsAddressedEnvelope();
            this.send(env, aex.getQOS());
            if (listener != null) {
                listener.exchangeCompleted(aex);
            }
            return;
        }
        boolean isAsyncCall = listener != null;
        String correlationId = Utils.generateCorrelationID();
        try {
            XQMessage message;
            XQEnvelope env = aex.getInputAsAddressedEnvelope();
            if (env == null || (message = env.getMessage()) == null) {
                throw new ESBClientException("Exchange has no input message.");
            }
            Iterator addresses = env.getAddresses();
            if (addresses == null || !addresses.hasNext()) {
                throw new ESBClientException("Exchange has no input address.");
            }
            XQAddress addressee = (XQAddress)addresses.next();
            if (addresses.hasNext()) {
                throw new ESBClientException("Exchange input has multiple addresses.");
            }
            XQEnvelope exchangeEnvelope = this.m_exchangeDirector.createExchangeEnvelope(message, correlationId, addressee, aex.getFaultAndRMEReceiveOption());
            AsyncCorrelatedListener clistener = this.establishCorrelatedListener(correlationId, aex, listener, timeout);
            this.m_exchangeDirector.setupMessageHandler(correlationId, clistener);
            this.m_dispatch.dispatch(exchangeEnvelope, aex.getQOS());
            if (isAsyncCall) {
                return;
            }
            clistener.waitPosting(timeout);
        }
        catch (Exception e) {
            throw new ESBClientException(e);
        }
        if (aex.getOutput() == null) {
            throw new ESBClientTimeoutException();
        }
    }

    private void applyMessageToExchange(XQMessage msg, Exchange aex) {
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        ExchangeInternal internalExchange = (ExchangeInternal)aex;
        OutputImpl o = (OutputImpl)aex.getOutput();
        if (o == null) {
            o = new OutputImpl();
            internalExchange.setOutput(o);
        }
        String entryPoint = (String)internalMsg.getSidebandProperty("SonicESB.CurrentEntryEndpoint");
        ((ColocExchangeImpl)aex).applyCallerContext(internalMsg);
        if (entryPoint.indexOf("AsynchTmp.Exit") != -1) {
            o.addOut(msg);
        } else if (entryPoint.indexOf("AsynchTmp.Fault") != -1) {
            o.addFault(msg);
        } else if (entryPoint.indexOf("AsynchTmp.RME") != -1) {
            o.setRME(msg);
        } else if (entryPoint.indexOf("AsynchTmp.ReplyTo") != -1) {
            if (this.isFaulted(msg)) {
                o.addFault(msg);
            } else if (this.isRMEd(msg)) {
                o.setRME(msg);
            } else {
                o.addOut(msg);
            }
        }
    }

    private boolean isFaulted(XQMessage xqMessage) {
        try {
            return Utils.isFault(xqMessage);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isRMEd(XQMessage xqMessage) {
        return xqMessage.doesPartExist("SonicESB.RME");
    }

    private AsyncCorrelatedListener establishCorrelatedListener(String correlationId, Exchange aex, ExchangeListener listener, long timeout) {
        return new AsyncCorrelatedListener(correlationId, aex, listener, timeout);
    }

    public void initiateExchange(Exchange aex, long timeout, FaultAndRMEReceiveOption option, ExchangeListener listener) throws ESBClientException {
        this.performExchangeInternal(aex, timeout, listener);
    }

    private void send(XQEnvelope env, XQQualityofService qos) throws ESBClientException {
        try {
            this.m_dispatch.dispatch(env, qos);
        }
        catch (Exception e) {
            throw new ESBClientException();
        }
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        ColocExchangeImpl exc = new ColocExchangeImpl(pattern);
        return exc;
    }

    @Override
    public void initiateExchange(Exchange aex, long timeout, ExchangeListener listener) throws ESBClientException {
        this.performExchangeInternal(aex, timeout, listener);
    }

    @Override
    public void registerEndpointListener(String endpointName, EndpointListener listener) throws ListenerAlreadyRegistered {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    @Override
    public void registerProcessOutputListener(String name, FaultAndRMEReceiveOption option, ProcessOutputListener listener) throws ListenerAlreadyRegistered {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    @Override
    public void registerServiceOutputListener(String name, FaultAndRMEReceiveOption option, ServiceOutputListener listener) throws ListenerAlreadyRegistered {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    @Override
    public void unregisterProcessOutputListener(String name) {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    @Override
    public void unregisterServiceOutputListener(String name) {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    @Override
    public void unregisterEndpointListener(String endpointName) {
        throw new UnsupportedOperationException("Unsupported for interior clients.");
    }

    class AsyncCorrelatedListener
    implements ICorrelatedTimedListener {
        protected ExchangeListener m_listener;
        protected Exchange m_exchange;
        protected String m_correlationId;
        long m_timeout;
        private Object m_mutex = new Object();
        private boolean m_posted;
        private boolean m_failed;
        private Object m_requestorStub = null;

        AsyncCorrelatedListener(String correlationId, Exchange exchange, ExchangeListener listener, long timeout) {
            this.m_timeout = timeout;
            this.m_listener = listener;
            this.m_exchange = exchange;
            this.m_correlationId = correlationId;
            if (XQContainer.isActionalEnabled()) {
                this.m_requestorStub = ActionalVisitor.getSplitStubOfActiveServerInteraction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitPosting(long ms) throws InterruptedException {
            Object object = this.m_mutex;
            synchronized (object) {
                if (!this.m_posted && !this.m_failed) {
                    this.m_mutex.wait(ms);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(XQMessage msg) throws XQServiceException {
            if (XQContainer.isActionalEnabled() && this.m_requestorStub != null) {
                ActionalVisitor.asyncReply(this.m_requestorStub, msg);
            }
            ESBColocInteractorImpl.this.applyMessageToExchange(msg, this.m_exchange);
            boolean done = this.m_exchange.getCompletionReferee().isComplete(this.m_exchange);
            if (done) {
                ESBColocInteractorImpl.this.m_exchangeDirector.cleanupMessageHandler(this.m_correlationId);
                if (this.m_listener != null) {
                    this.m_listener.exchangeCompleted(this.m_exchange);
                }
                Object object = this.m_mutex;
                synchronized (object) {
                    this.m_posted = true;
                    this.m_mutex.notify();
                }
            }
        }

        @Override
        public long getTimeout() {
            return this.m_timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout(IRegistration registration, Object jmsCorrID) {
            ESBColocInteractorImpl.this.m_exchangeDirector.cleanupMessageHandler(this.m_correlationId);
            if (this.m_listener != null) {
                this.m_listener.exchangeFailed(this.m_exchange, new ESBClientTimeoutException());
            }
            Object object = this.m_mutex;
            synchronized (object) {
                this.m_failed = true;
                this.m_mutex.notify();
            }
        }
    }
}

