/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.MapCtxExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.IndexConstructProcessor;

public class MapCtxExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor,
IndexConstructProcessor.Callback {
    private MapCtxExpressionDef m_expressionDef;

    public MapCtxExpressionDefProcessor() {
    }

    public MapCtxExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new MapCtxExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        this.m_expressionDef.setRValue(isRValue);
        IndexConstructProcessor.processIndexConstruct(this.m_remaining, this);
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        assert (expressionDef instanceof MapCtxExpressionDef);
        MapCtxExpressionDef mapCtxExpression = (MapCtxExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${mapctx");
        if (mapCtxExpression.isCursorIndexDefined()) {
            sbuf.append(".sourceCursorIndex");
        } else if (mapCtxExpression.isCursorElementDefined()) {
            sbuf.append(".sourceCursorElement");
            if (this.isDefined(mapCtxExpression.getCursorElementProperty())) {
                sbuf.append("['").append(MapCtxExpressionDefProcessor.getString(mapCtxExpression.getCursorElementProperty())).append("']");
            }
        } else if (mapCtxExpression.isSourceElementDefined()) {
            sbuf.append(".source");
            if (this.isDefined(mapCtxExpression.getSourceElementProperty())) {
                sbuf.append("['").append(MapCtxExpressionDefProcessor.getString(mapCtxExpression.getSourceElementProperty())).append("']");
            }
        } else {
            throw new ExpressionException("Required information has not been populated to generate a valid mapctx expression");
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setIndex(String indexName) {
        if (this.m_expressionDef.isSourceElementDefined()) {
            this.m_expressionDef.setSourceElementProperty(indexName);
        } else if (this.m_expressionDef.isCursorElementDefined()) {
            this.m_expressionDef.setCursorElementProperty(indexName);
        }
    }

    @Override
    public void setSource(String source) {
        if ("sourceCursorIndex".equals(source)) {
            this.m_expressionDef.setCursorIndexDefined(true);
        } else if ("sourceCursorElement".equals(source)) {
            this.m_expressionDef.setCursorElementDefined(true);
        } else if ("source".equals(source)) {
            this.m_expressionDef.setSourceElementDefined(true);
        }
    }

    @Override
    public void setFunction(String function) {
    }

    @Override
    public void setEmbeddedExpression(String expression) {
        ExpressionDef expressionDef = this.parseAsExpressionDef(expression);
        if (this.m_expressionDef.isSourceElementDefined()) {
            this.m_expressionDef.setSourceElementProperty(expressionDef != null ? expressionDef : expression);
        } else if (this.m_expressionDef.isCursorElementDefined()) {
            this.m_expressionDef.setCursorElementProperty(expressionDef != null ? expressionDef : expression);
        }
    }
}

