/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.el.ELExpressionFactory;
import com.sonicsw.esb.expression.el.ParamValueConverter;
import com.sonicsw.esb.expression.el.XMLParamTypeConverter;
import com.sonicsw.esb.expression.el.XQPartConverter;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import java.util.Map;

public class ELUtils {
    public static ELExpressionFactory createExpressionFactory() {
        ELExpressionFactory exprFactory = new ELExpressionFactory();
        exprFactory.addTypeConverter(new XQPartConverter());
        exprFactory.addTypeConverter(new ParamValueConverter());
        exprFactory.addTypeConverter(new XMLParamTypeConverter());
        return exprFactory;
    }

    public static void prepareDefaultExpressionContext(ExpressionContext context, XQMessage message, XQServiceContext serviceContext) {
        context.setValue("esbmsg", message);
        context.setValue("system", System.getProperties());
        IComponentContext cc = XQConfigManager.getInstance(null).getComponentContext();
        if (cc != null) {
            context.setValue("container", cc);
        }
        if (serviceContext != null) {
            context.setValue("esbdl", serviceContext.getInvocationContext());
            context.setValue("esbp", serviceContext.getProcessContext());
        }
    }

    public static void setNamespaceMap(ExpressionContext context, Map<String, Namespace> nsMap) {
        if (nsMap != null) {
            context.putContextObject(Map.class, nsMap);
        }
    }

    public static Map<String, Namespace> getNamespaceMap(ExpressionContext exprCtx) {
        return (Map)exprCtx.getContextObject(Map.class);
    }

    public static void setNamespaceMap(MappingContext mappingCtx, ExpressionContext context) {
        if (null != mappingCtx) {
            MessageMapper msgMapper = (MessageMapper)mappingCtx.getObject(MessageMapper.class, true);
            Map<String, Namespace> nsMap = msgMapper != null ? msgMapper.getNamespaceMap() : null;
            ELUtils.setNamespaceMap(context, nsMap);
        }
    }

    public static void setEsbpContext(MappingContext mappingCtx, ExpressionContext context) {
        XQProcessContext procCtx = (XQProcessContext)mappingCtx.getObject(XQProcessContext.class, false);
        if (procCtx != null) {
            context.setValue("esbp", procCtx);
        } else {
            XQParameters params = (XQParameters)mappingCtx.getObject(XQParameters.class, true);
            context.setValue("esbp", new XQProcessContextImpl(params));
        }
    }

    public static XQAddress getAddress(ExpressionContext exprCtx, Expression expression, Token token, XQLog log) {
        Object value = null;
        try {
            value = expression.getValue(exprCtx);
        }
        catch (Throwable e) {
            log.logDebug("Error executing expression " + expression);
            log.logDebug(e);
        }
        String xqAddressStr = null;
        xqAddressStr = value == null || value instanceof String ? (String)value : value.toString();
        XQAbstractAddressImpl resolvedAddress = null;
        if (xqAddressStr != null) {
            try {
                resolvedAddress = new XQAbstractAddressImpl(xqAddressStr);
            }
            catch (Throwable e) {
                String errorMsg = "Error while parsing resolved address `" + xqAddressStr + "` as an XQAddress";
                log.logError(errorMsg);
                log.logError(e);
                throw new ItineraryException(errorMsg, token);
            }
            if (resolvedAddress.getType() == 4) {
                String errorMsg = "The dynamic address resolved to another dynamic address `" + xqAddressStr + "`. This is not supported";
                log.logError(errorMsg);
                throw new ItineraryException(errorMsg, token);
            }
        }
        return resolvedAddress;
    }
}

