/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.TrackingMessage;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.rules.EvaluatorException;
import com.sonicsw.xq.rules.IRuleEvaluator;
import com.sonicsw.xq.rules.NoRuleFileException;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQTrackingDetailsConfig;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.service.AccessorFactory;
import com.sonicsw.xqimpl.service.XQEndpointManagerImpl;
import com.sonicsw.xqimpl.service.XQServiceContextImpl;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;

public class ProcessTracker {
    static final String JS_HELPER_FUNCTIONS = "jsHelperFunctions";
    static final String RULE_FILE = "ruleFile";
    private static Map<String, Class<?>> classCache = new Hashtable();
    private static XQLog log = XQLogImpl.getCategoryLog((int)32768);
    private boolean m_doTracking = false;
    private XQTrackingDetailsConfig m_trackingDetails = null;
    private String m_trackingId;
    private static String hostname;
    protected static Object syncObj;
    private static long lastTime;
    private static int lastSuffix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateTrackingId(XQTrackingDetailsConfig trackingConfig, String processName, XQMessage message) throws ClassNotFoundException, IllegalAccessException, InstantiationException, EvaluatorException {
        String idGeneratorClassname = trackingConfig.getIdClassname();
        if (idGeneratorClassname.equals("com.sonicsw.xqimpl.service.accessor.ScriptEvaluator")) {
            idGeneratorClassname = "com.sonicsw.xq.service.common.ScriptEvaluator";
        }
        Class<?> idGeneratorClass = null;
        Map<String, Class<?>> map = classCache;
        synchronized (map) {
            if (classCache.containsKey(idGeneratorClassname)) {
                idGeneratorClass = classCache.get(idGeneratorClassname);
            } else {
                idGeneratorClass = Class.forName(idGeneratorClassname);
                classCache.put(idGeneratorClassname, idGeneratorClass);
            }
        }
        if (!IRuleEvaluator.class.isAssignableFrom(idGeneratorClass)) {
            throw new IllegalArgumentException("The idGenerator must implement IRuleEvaluator");
        }
        IRuleEvaluator idGenerator = (IRuleEvaluator)idGeneratorClass.newInstance();
        XQParametersImpl idParameters = trackingConfig.getIdParameters();
        if (idParameters == null || !idParameters.containsParameter(RULE_FILE, 1)) {
            return ProcessTracker.generateDefaultTrackingId(processName);
        }
        if (idParameters.getParameterObject(RULE_FILE, 1) == null) {
            String id = ProcessTracker.generateDefaultTrackingId(processName);
            log.logWarning("RuleFile for generating tracking id not found for process:" + processName + ".Using default tracking id:" + id);
            return id;
        }
        try {
            idGenerator.init((XQParameters)idParameters);
        }
        catch (NoRuleFileException nrfe) {
            // empty catch block
        }
        XQServiceContextImpl dummyContext = null;
        dummyContext = XQServiceContextImpl.createServiceContextImpl(new XQEndpointManagerImpl(null, null), new EnvelopeFactory(), AccessorFactory.getInstance(), new XQMessageFactoryImpl(), new XQAddressFactoryImpl(null, -1));
        Object id = idGenerator.evaluateRule(null, (XQServiceContext)dummyContext, message);
        return id != null ? id.toString() : (String)id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateDefaultTrackingId(String processName) {
        StringBuilder id = new StringBuilder();
        id.append("ID:");
        id.append(processName);
        id.append(':');
        id.append(hostname);
        id.append(':');
        int suffix = 0;
        long currentTime = System.currentTimeMillis();
        Object object = syncObj;
        synchronized (object) {
            if (currentTime == lastTime) {
                suffix = ++lastSuffix;
            } else {
                lastTime = currentTime;
                lastSuffix = 0;
            }
        }
        id.append(currentTime);
        if (suffix != 0) {
            id.append('_');
            id.append(suffix);
        }
        return id.toString();
    }

    public ProcessTracker(ProcessInstanceProps processProps) {
        this.m_trackingDetails = new XQTrackingDetailsConfig();
        this.override(processProps);
        this.m_doTracking = this.m_trackingDetails != null && this.m_trackingDetails.getTrackingLevel() != 0;
    }

    public ProcessTracker(XQProcessConfig currentProcess, XQTrackingDetailsConfig trackingDetails, EsbMessageExchange mex) {
        this.m_trackingDetails = trackingDetails;
        boolean bl = this.m_doTracking = this.m_trackingDetails != null && this.m_trackingDetails.getTrackingLevel() != 0;
        if (this.m_doTracking) {
            if (this.m_trackingDetails.getTrackingId() != null) {
                this.m_trackingId = this.m_trackingDetails.getTrackingId();
            } else {
                try {
                    this.m_trackingId = ProcessTracker.generateTrackingId(this.m_trackingDetails, currentProcess.getName(), mex.getInputMessage());
                }
                catch (Exception e) {
                    throw new ItineraryException(e, "Error generating Tracking ID due to: `" + e.getMessage() + "`", null);
                }
            }
        }
    }

    public String getTrackingID() {
        return this.m_trackingId;
    }

    public void populateTrackingProps(XQParameters params, ProcessInstanceProps processProps) {
        if (this.m_doTracking && processProps != null) {
            params.setParameter("SonicXQ.process.trackingID", 1, processProps.getTrackingId());
            params.setParameterObject("SonicXQ.process.eventAddress", 3, (Object)processProps.getTrackingEndpoint());
        }
    }

    public XQTrackingDetailsConfig getTrackingDetails() {
        return this.m_trackingDetails;
    }

    public boolean isTracking() {
        return this.m_doTracking;
    }

    public void sendTrackingMessage(String msgText, XQMessage message, XQAddress destinationAddr, EsbMessageExchange mex, int minimumTrackingLevel) {
        if (this.m_doTracking && this.m_trackingDetails.getTrackingLevel() >= minimumTrackingLevel) {
            this.sendTrackingMessageInternal(msgText, message, destinationAddr, mex);
        }
    }

    private void sendTrackingMessageInternal(String type, XQMessage message, XQAddress messageDestination, EsbMessageExchange mex) {
        block4: {
            XQParameters params = mex.getXQParameters();
            try {
                new TrackingMessage(this.m_trackingId, this.m_trackingDetails, params, type, message, messageDestination, mex.getMessageFactory() == null ? new XQMessageFactoryImpl() : mex.getMessageFactory()).send(this.toString(), params, mex.getQOS(), mex.getEndpointRegistry());
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": onMessageImmediate: sent process entry tracking message");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": onMessageImmediate: caught exception while sending tracking message: " + e);
                }
                log.logError("Error sending service tracking messages: " + e.getMessage());
                if (!log.isDebugLoggingEnabled()) break block4;
                log.logDebug(e);
            }
        }
    }

    public final void override(ProcessInstanceProps processProps) {
        if (processProps.getTrackingLevel() > 0 && this.m_trackingDetails == null) {
            this.m_trackingDetails = new XQTrackingDetailsConfig();
        }
        if (this.m_trackingDetails != null) {
            this.m_trackingDetails.setTrackingId(processProps.getTrackingId());
            this.m_trackingDetails.setTrackingLevel(processProps.getTrackingLevel());
            this.m_trackingDetails.setEventEndpoint(processProps.getTrackingEndpoint());
        }
        this.m_doTracking = this.m_trackingDetails != null && this.m_trackingDetails.getTrackingLevel() != 0;
    }

    static {
        syncObj = new Object();
        lastTime = 0L;
        lastSuffix = 0;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostname = "UnknownHost";
        }
    }
}

