/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.ProcessTracker;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.engine.XQProcessInstanceLiteGenerator;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.engine.Pid;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import java.util.List;

public final class XQProcessInstanceLite
extends XQProcessInstance {
    private List<ProcessStepTuple> m_parentProcs = null;

    public XQProcessInstanceLite(XQProcessInstanceLiteGenerator instGen, MainProcess processDef, XQProcessConfig procConfig, EsbMessageExchange mex) {
        super(instGen, processDef, procConfig, mex);
    }

    protected XQProcessInstanceLite(XQProcessInstanceLiteGenerator instGen, ProcessInstanceProps procInstProps, List<ProcessStepTuple> processStepTuples, Token token, boolean insertFirstStep) throws Throwable {
        this.m_instGenerator = instGen;
        this.m_processState = ProcessState.OPEN;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        this.m_procInstProps = procInstProps;
        this.m_parentProcs = processStepTuples;
        mex.setRMEAddress(this.m_procInstProps.getRMEAddress());
        ProcessStepTuple processStepTuple = processStepTuples.remove(processStepTuples.size() - 1);
        ESBProcess currentProcess = instGen.getESBProcess(this, processStepTuple);
        this.setProcess(currentProcess);
        this.m_isSubProcess = this.m_parentProcs.size() > 0;
        this.m_pid = new Pid(currentProcess.getProcessName());
        this.setActiveNode(currentProcess.getActivityNodeByName(processStepTuple.stepName), null);
        if (this.m_procInstProps.getTrackingLevel() > 0) {
            this.setProcessTracker(new ProcessTracker(this.m_procInstProps));
        }
    }

    public XQProcessInstanceLite(XQProcessInstanceLiteGenerator instGen, ESBProcess process, XQProcessConfig additionalConfig, XQProcessInstance parentInst) {
        super((ProcessInstanceGenerator)instGen, process, additionalConfig, parentInst);
    }

    protected XQProcessInstanceLite(XQProcessInstanceLiteGenerator instGen, List<ProcessStepTuple> processParts, ProcessInstanceProps procInstProps, Token token, boolean insertFirstStep) throws Throwable {
        this.m_instGenerator = instGen;
        this.m_processState = ProcessState.OPEN;
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        this.m_parentProcs = processParts;
        this.m_procInstProps = procInstProps;
        mex.setRMEAddress(this.m_procInstProps.getRMEAddress());
        this.m_process = instGen.getESBProcess(this, this.m_parentProcs.remove(0));
        this.m_isSubProcess = this.m_parentProcs.size() > 0;
        this.m_pid = new Pid(this.m_process.getProcessName());
        String activeStepName = this.m_procInstProps.getCurrentProcessStepName();
        this.setActiveNode(((ESBProcess)this.m_process).getActivityNodeByName(activeStepName), null);
        if (this.m_procInstProps.getTrackingLevel() > 0) {
            this.setProcessTracker(new ProcessTracker(this.m_procInstProps));
        }
    }

    public XQProcessInstanceLite(XQProcessInstanceLiteGenerator instGen, XQProcessInstanceLite childInstance, int index) {
        this.m_instGenerator = instGen;
        this.m_processState = ProcessState.OPEN;
        try {
            this.m_parentProcs = childInstance.getParentProcs();
            this.m_procInstProps = childInstance.getProcessInstanceProperties();
            ProcessStepTuple tuple = this.m_parentProcs.remove(index);
            if (index == 0) {
                this.m_process = instGen.getESBProcess(this, tuple);
                this.m_isSubProcess = this.m_parentProcs.size() > 0;
            } else {
                this.m_process = instGen.getESBProcess(this, tuple);
            }
            this.m_pid = new Pid(this.m_process.getProcessName());
            ActivityNode activeNode = ((ESBProcess)this.m_process).getActivityNodeByName(tuple.stepName);
            this.setActiveNode(activeNode, null);
            this.setProcessTracker(childInstance.getprocessTracker());
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error creating process instance", null);
        }
    }

    @Override
    public XQProcessInstance getParentProcessInstance(Token token, boolean create) {
        if (this.m_parentInstance == null && create && this.m_parentProcs != null && this.m_parentProcs.size() > 0) {
            this.m_parentInstance = new XQProcessInstanceLite((XQProcessInstanceLiteGenerator)this.m_instGenerator, this, 0);
        }
        return this.m_parentInstance;
    }

    List<ProcessStepTuple> getParentProcs() {
        return this.m_parentProcs;
    }

    static class ProcessStepTuple {
        String processName;
        String stepName;

        ProcessStepTuple() {
        }
    }
}

