/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.ESBProcess;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.engine.ProcessInstanceSerializer;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.axis.encoding.Base64;
import org.apache.axis.utils.ByteArrayOutputStream;

public class XQProcessInstanceLiteSerializer
implements ProcessInstanceSerializer {
    @Override
    public void serialize(ActivityNode node, Token token) throws IOException, XQMessageException {
        assert (node != null);
        assert (node.getParentProcess() instanceof ESBProcess);
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        ProcessInstanceProps processProps = procInst.getProcessInstanceProperties();
        processProps.setStepName(node.getDisplayName(), procInst);
        this.serializeProcessContents(procInst, token, this);
    }

    private void serializeProcessContents(XQProcessInstance procInst, Token token, XQProcessInstanceLiteSerializer serializer) throws XQMessageException, IOException {
        XQMessage message = ((EsbMessageExchange)token.getData()).getInputMessage();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);
            ProcessInstanceProps procInstProps = procInst.getProcessInstanceProperties();
            Properties props = procInstProps.getAllProcessProps();
            String completeStepName = procInstProps.getStepName();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> processNames = new ArrayList<String>();
            for (ProcessInstance parentProcInst = procInst; parentProcInst != null; parentProcInst = parentProcInst.getParentProcessInstance(token)) {
                processNames.add(parentProcInst.getProcessDefinition().getProcessName());
            }
            for (int i = processNames.size() - 1; i >= 0; --i) {
                sb.append((String)processNames.get(i));
                if (i <= 0) continue;
                sb.append(":");
            }
            props.setProperty("SonicXQ.ProcessTrail", sb.toString());
            procInstProps.setStepName(completeStepName);
            oos.writeObject(props);
            String base64Str = Base64.encode((byte[])baos.toByteArray());
            message.setHeaderValue("SonicESB.ProcessContext", (Object)base64Str);
        }
        catch (Throwable e) {
            throw new ItineraryException(e, "Error while saving process context header", token);
        }
    }
}

