/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.def.EsbdlExpressionDef;
import com.sonicsw.esb.expression.def.EsbpExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.XQMsgExpressionDef;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;
import com.sonicsw.esb.itinerary.mapping.BaseMappingRule;
import com.sonicsw.esb.process.mapping.MappingRule;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultMappingRuleList
implements MappingRuleList {
    private List<MappingRule> m_ruleList = new ArrayList<MappingRule>();
    private Set<EsbdlExpressionDef> m_interfaceParams = new HashSet<EsbdlExpressionDef>();
    private int m_paramType;
    private ExpressionDefProcessorFactory m_expressionDefFactory;
    private boolean m_xqMsgMapping;
    private boolean m_xqMsgRHSMapping;

    DefaultMappingRuleList(int paramType) {
        this.m_paramType = paramType;
        this.m_expressionDefFactory = new ELExpressionDefProcessFactory(false);
    }

    @Override
    public void addMappingRule(MappingRule rule) {
        this.m_ruleList.add(rule);
        if (rule instanceof BaseMappingRule) {
            BaseMappingRule bmr = (BaseMappingRule)rule;
            if (this.m_paramType == 0) {
                this.setXQMsgCollectionType(bmr, bmr.getSource());
                this.setProcessContextCollectionType(bmr, bmr.getSource());
                this.addInterfaceParamsIfApplicable(bmr, bmr.getTarget(), false);
            } else {
                this.addInterfaceParamsIfApplicable(bmr, bmr.getSource(), true);
                this.addXQMsgMappingInfo(bmr.getSource(), bmr.getTarget());
            }
        }
    }

    private void addXQMsgMappingInfo(String sourceString, String targetString) {
        if (!this.m_xqMsgMapping) {
            boolean bl = this.m_xqMsgMapping = sourceString.startsWith("${esbmsg") && targetString.startsWith("${esbmsg");
        }
        if (!this.m_xqMsgRHSMapping) {
            this.m_xqMsgRHSMapping = targetString.startsWith("${esbmsg");
        }
    }

    private void addInterfaceParamsIfApplicable(BaseMappingRule bmr, String expressionStr, boolean isSource) {
        if (expressionStr.startsWith("${esbdl")) {
            ExpressionDefProcessor expressionDefProcessor = this.m_expressionDefFactory.getExpressionDefProcessor(expressionStr);
            if (expressionDefProcessor == null) {
                return;
            }
            ExpressionDef expressionDef = expressionDefProcessor.getExpressionDef(expressionStr, false);
            if (this.m_paramType == 0) {
                this.m_interfaceParams.add((EsbdlExpressionDef)expressionDef);
            } else if (this.m_paramType == 1) {
                this.m_interfaceParams.add((EsbdlExpressionDef)expressionDef);
            } else {
                this.m_interfaceParams.add((EsbdlExpressionDef)expressionDef);
            }
            if (isSource) {
                bmr.setCollectionType(((EsbdlExpressionDef)expressionDef).isCollection());
            }
        }
    }

    private void setXQMsgCollectionType(BaseMappingRule bmr, String expressionStr) {
        if (expressionStr.startsWith("${esbmsg")) {
            ExpressionDefProcessor expressionDefProcessor = this.m_expressionDefFactory.getExpressionDefProcessor(expressionStr);
            if (expressionDefProcessor == null) {
                return;
            }
            ExpressionDef expressionDef = expressionDefProcessor.getExpressionDef(expressionStr, false);
            bmr.setCollectionType(((XQMsgExpressionDef)expressionDef).isCollection());
        }
    }

    private void setProcessContextCollectionType(BaseMappingRule bmr, String expressionStr) {
        if (expressionStr.startsWith("${esbp")) {
            ExpressionDefProcessor expressionDefProcessor = this.m_expressionDefFactory.getExpressionDefProcessor(expressionStr);
            if (expressionDefProcessor == null) {
                return;
            }
            ExpressionDef expressionDef = expressionDefProcessor.getExpressionDef(expressionStr, false);
            bmr.setCollectionType(((EsbpExpressionDef)expressionDef).isCollection());
        }
    }

    @Override
    public Set<EsbdlExpressionDef> getInterfaceParameters() {
        return this.m_interfaceParams;
    }

    @Override
    public boolean isXQMsgToXQMsgMappingDefined() {
        return this.m_xqMsgMapping;
    }

    @Override
    public boolean isXQMsgMappingForRHSDefined() {
        return this.m_xqMsgRHSMapping;
    }

    @Override
    public Iterator<MappingRule> getMappingRules() {
        return this.m_ruleList.iterator();
    }

    @Override
    public boolean removeMappingRule(MappingRule rule) {
        if (rule instanceof BaseMappingRule) {
            BaseMappingRule bmr = (BaseMappingRule)rule;
            String expressionStr = null;
            expressionStr = this.m_paramType == 0 ? bmr.getTarget() : bmr.getSource();
            ExpressionDefProcessor expressionDefProcessor = this.m_expressionDefFactory.getExpressionDefProcessor(expressionStr);
            if (expressionDefProcessor == null) {
                return this.m_ruleList.remove(rule);
            }
            ExpressionDef expressionDef = expressionDefProcessor.getExpressionDef(expressionStr, false);
            if (expressionDef instanceof EsbdlExpressionDef) {
                if (this.m_paramType == 0) {
                    this.m_interfaceParams.remove(((EsbdlExpressionDef)expressionDef).getInputParamName());
                } else if (this.m_paramType == 1) {
                    this.m_interfaceParams.remove(((EsbdlExpressionDef)expressionDef).getOutputParamName());
                } else {
                    this.m_interfaceParams.remove(((EsbdlExpressionDef)expressionDef).getFaultParamName());
                }
            }
        }
        return this.m_ruleList.remove(rule);
    }

    @Override
    public int getSize() {
        return this.m_ruleList.size();
    }
}

