/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.def.EsbdlExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ListParameterValue;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InvocationContextImpl
implements InvocationContext {
    private ParameterValueMap m_inputParamValues;
    private ParameterValueMap m_outputParamValues;
    private MessageMapper m_messageMapper;
    private boolean m_outputParamsAccessed;
    private boolean m_faultParamsAccessed;
    private Map<String, ParameterValueMap> m_faultParamMap;

    public InvocationContextImpl(MessageMapper msgMapper) {
        this.m_messageMapper = msgMapper;
    }

    @Override
    public ParameterValueMap getInputParameterValues() {
        return this.m_inputParamValues;
    }

    @Override
    public ParameterValueMap getOutputParameterValues() {
        if (!this.m_outputParamsAccessed) {
            this.populateOutputParameterValues();
            this.m_outputParamsAccessed = true;
        }
        return this.m_outputParamValues;
    }

    @Override
    public ParameterValueMap getFaultParameterValues(String faultName) {
        if (!this.m_faultParamsAccessed) {
            this.populateFaultParameterValues();
            this.m_faultParamsAccessed = true;
        }
        return this.m_faultParamMap != null ? this.m_faultParamMap.get(faultName) : null;
    }

    @Override
    public Map<String, ParameterValueMap> getFaultParameterMap() {
        if (!this.m_faultParamsAccessed) {
            this.populateFaultParameterValues();
            this.m_faultParamsAccessed = true;
        }
        return this.m_faultParamMap;
    }

    @Override
    public void setInputParameterValues(ParameterValueMap inputParamValues) {
        this.m_inputParamValues = inputParamValues;
    }

    @Override
    public void assignPrepopulatedOutputParameterValues(ParameterValueMap outputParamValues) {
        this.m_outputParamValues = outputParamValues;
        this.m_outputParamsAccessed = true;
    }

    @Override
    public void setOutputParameterValues(ParameterValueMap outputParamValues) {
        this.m_outputParamValues = outputParamValues;
    }

    @Override
    public void setFaultParameterMap(Map<String, ParameterValueMap> faultParamsMap) {
        this.m_faultParamMap = faultParamsMap;
    }

    public MessageMapper getMessageMapper() {
        return this.m_messageMapper;
    }

    private void populateOutputParameterValues() {
        MappingRuleList outputRules;
        MappingRuleList mappingRuleList = outputRules = this.m_messageMapper != null ? this.m_messageMapper.getOutputMappingRules() : null;
        if (outputRules != null && outputRules.getSize() > 0) {
            Set<EsbdlExpressionDef> outputParams = outputRules != null ? outputRules.getInterfaceParameters() : null;
            ParameterValueMap outputParamsMap = new ParameterValueMap();
            for (EsbdlExpressionDef expression : outputParams) {
                ParameterValue paramVal = null;
                paramVal = expression.isCollection() ? new ListParameterValue(ExpressionDefProcessorBase.getString(expression.getParamName()), null) : new ParameterValue(ExpressionDefProcessorBase.getString(expression.getParamName()), null);
                outputParamsMap.add(paramVal);
            }
            this.m_outputParamValues = outputParamsMap;
        }
    }

    private void populateFaultParameterValues() {
        Map<String, MappingRuleList> ruleMap;
        Map<String, MappingRuleList> map = ruleMap = this.m_messageMapper != null ? this.m_messageMapper.getFaultMappingRules() : null;
        if (ruleMap != null && ruleMap.size() > 0) {
            this.m_faultParamMap = new HashMap<String, ParameterValueMap>();
            for (Map.Entry<String, MappingRuleList> entry : ruleMap.entrySet()) {
                MappingRuleList faultRules = entry.getValue();
                Set<EsbdlExpressionDef> faultParams = faultRules != null ? faultRules.getInterfaceParameters() : null;
                if (faultParams == null || faultParams.size() == 0) continue;
                ParameterValueMap faultParamsMap = new ParameterValueMap();
                for (EsbdlExpressionDef expression : faultParams) {
                    ParameterValue paramVal = null;
                    paramVal = expression.isCollection() ? new ListParameterValue(ExpressionDefProcessorBase.getString(expression.getParamName()), null) : new ParameterValue(ExpressionDefProcessorBase.getString(expression.getParamName()), null);
                    faultParamsMap.add(paramVal);
                }
                this.m_faultParamMap.put(entry.getKey(), faultParamsMap);
            }
        }
    }
}

