/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DataToken;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.service.RMEMessage;
import java.util.HashSet;

public abstract class InlineEsbStepNode
extends EsbStepNode {
    public InlineEsbStepNode(String id, String stepName, ActivityGroup parent, String internalServiceName) {
        super(id, parent);
        this.initEndpointRef(stepName, internalServiceName);
    }

    private void initEndpointRef(String stepName, String internalServiceName) {
        this.setEndpointRef((XQAddress)new XQAbstractAddressImpl(internalServiceName, 1, stepName));
    }

    @Override
    public Token execute(Token token) {
        XQProcessInstance procInstance = (XQProcessInstance)token.getProcessInstance();
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        try {
            this.populateXQParameters(mex);
            try {
                token = this.executeInline(token);
            }
            catch (Exception exception) {
                try {
                    RMEMessage rmeMessage = new RMEMessage(exception, mex.getRMEAddress(), mex.getMessageFactory(), mex.getInputMessage(), mex.getXQParameters(), "XQ_SERVICE_EXCEPTION");
                    EsbMessageExchange newMex = (EsbMessageExchange)mex.clone();
                    newMex.setInputMessage(mex.getInputMessage());
                    newMex.setRMEMessage(rmeMessage);
                    newMex.setXQDispatcher(mex.getXQDispatcher());
                    DataToken rmeToken = new DataToken((ActivityNode)this, (ProcessInstance)token.getProcessInstance(), newMex);
                    rmeToken.tagType(Token.Type.RME);
                    token = rmeToken;
                }
                catch (Exception rmeException) {
                    throw new ItineraryException(rmeException, "Error creating RME.", token);
                }
            }
            if (token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.FAULT, false)) {
                return token;
            }
            mex = (EsbMessageExchange)token.getData();
            HashSet<XQAddress> nextAddresses = new HashSet<XQAddress>();
            procInstance.computeNextAddresses(this, nextAddresses, token);
            int nAddr = nextAddresses.size();
            if (nAddr == 0) {
                procInstance.populateExitEndpoints(nextAddresses, token);
            } else if (nAddr == 1) {
                mex.setDestinationAddress((XQAddress)nextAddresses.iterator().next());
            } else {
                token = CompositeToken.createCompositeToken(this, token, mex, nextAddresses);
            }
            if (procInstance.getprocessTracker() != null) {
                procInstance.getprocessTracker().sendTrackingMessage("SERVICE_EXIT", mex.getInputMessage(), mex.getDestinationAddress(), mex, 2);
            }
        }
        catch (Throwable t) {
            EsbStepNode.handleException(t, this, token, mex);
        }
        return token;
    }

    protected abstract Token executeInline(Token var1) throws Exception;

    protected abstract void populateXQParameters(EsbMessageExchange var1);
}

