/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.ConnectionCfg;
import java.util.HashMap;

public class JMSConnectionCfg
extends ConnectionCfg {
    public JMSConnectionCfg(XQConnectionConfig config, XQConnectionTypeConfig typeConfig) throws XQEndpointCreationException {
        super(config, typeConfig);
    }

    public String getURL() {
        return this.m_params.getParameter("url", 1);
    }

    public Integer getFlowToDisk() {
        Integer flowToDisk = null;
        try {
            flowToDisk = Integer.valueOf(this.m_params.getParameter("flowToDisk", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flowToDisk;
    }

    public HashMap<String, Object> getSecurityParams() {
        HashMap<String, Object> cfMap = new HashMap<String, Object>();
        cfMap.put("SSL_CA_CERTIFICATES_DIR", this.m_params.getParameter("SSL_CA_CERTIFICATES_DIR", 1));
        cfMap.put("SSL_CERTIFICATE_CHAIN", this.m_params.getParameter("SSL_CERTIFICATE_CHAIN", 1));
        cfMap.put("SSL_PRIVATE_KEY", this.m_params.getParameter("SSL_PRIVATE_KEY", 1));
        cfMap.put("SSL_PRIVATE_KEY_PASSWORD", this.m_params.getParameter("SSL_PRIVATE_KEY_PASSWORD", 1));
        cfMap.put("SSL_PROVIDER_CLASS", this.m_params.getParameter("SSL_PROVIDER_CLASS", 1));
        cfMap.put("SSL_CERTIFICATE_CHAIN_FORM", this.m_params.getParameter("SSL_CERTIFICATE_CHAIN_FORM", 1));
        cfMap.put("SSL_CIPHER_SUITES", this.m_params.getParameter("SSL_CIPHER_SUITES", 1));
        cfMap.put("SSL_JSSE_KEY_STORE_KEY_ALIAS", this.m_params.getParameter("SSL_JSSE_KEY_STORE_KEY_ALIAS", 1));
        cfMap.put("SSL_JSSE_KEY_STORE_KEY_PASSWORD", this.m_params.getParameter("SSL_JSSE_KEY_STORE_KEY_PASSWORD", 1));
        cfMap.put("SSL_JSSE_KEY_STORE_LOCATION", this.m_params.getParameter("SSL_JSSE_KEY_STORE_LOCATION", 1));
        cfMap.put("SSL_JSSE_KEY_STORE_PASSWORD", this.m_params.getParameter("SSL_JSSE_KEY_STORE_PASSWORD", 1));
        cfMap.put("SSL_JSSE_KEY_STORE_TYPE", this.m_params.getParameter("SSL_JSSE_KEY_STORE_TYPE", 1));
        cfMap.put("SSL_JSSE_TRUST_MANAGER", this.m_params.getParameter("SSL_JSSE_TRUST_MANAGER", 1));
        cfMap.put("SSL_JSSE_TRUST_STORE_LOCATION", this.m_params.getParameter("SSL_JSSE_TRUST_STORE_LOCATION", 1));
        cfMap.put("SSL_JSSE_TRUST_STORE_PASSWORD", this.m_params.getParameter("SSL_JSSE_TRUST_STORE_PASSWORD", 1));
        cfMap.put("SSL_JSSE_TRUST_STORE_TYPE", this.m_params.getParameter("SSL_JSSE_TRUST_STORE_TYPE", 1));
        return cfMap;
    }

    public int getMaxReceiveSessionsPerConnection() {
        int maxSessions = 0;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_RECEIVE_SESSIONS_PER_CONNECTION", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public int getMaxSessionsBestEffortPool() {
        int maxSessions = 0;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_SESSIONS_BEST_EFFORT_POOL", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public int getMaxSessionsAtLeastOncePool() {
        int maxSessions = 0;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_SESSIONS_AT_LEAST_ONCE_POOL", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public int getMaxSessionsAtLeastOnceFastPool() {
        int maxSessions = 0;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_SESSIONS_AT_LEAST_ONCE_FAST_POOL", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public int getMaxSessionsExactlyOncePool() {
        int maxSessions = 0;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_SESSIONS_EXACTLY_ONCE_POOL", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public int getMaxWebServiceSessionsPerConnection() {
        int maxSessions = 10;
        try {
            maxSessions = Integer.parseInt(this.m_params.getParameter("MAX_SESSIONS_WEB_SERVICES_POOL", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxSessions;
    }

    public HashMap<String, Object> getCFMap() {
        HashMap<String, Object> cfMap = this.getSecurityParams();
        cfMap.put("name", this.m_config.getName());
        cfMap.put("url", this.getURL());
        cfMap.put("pingInterval", this.getPingInterval());
        cfMap.put("socketConnectTimeout", this.getSocketConnectTimeout());
        cfMap.put("monitorInterval", this.getMonitorInterval());
        cfMap.put("faultTolerant", this.isFaultTolerant());
        cfMap.put("initialConnectTimeout", this.getInitialConnectTimeout());
        cfMap.put("faultTolerantReconnectTimeout", this.getFaultTolerantReconnectTimeout());
        cfMap.put("loadBalanced", this.isLoadBalanced());
        cfMap.put("loginSPIClass", this.getLoginSPIClassname());
        cfMap.put("connectionID", this.getConnectionID());
        cfMap.put("flowToDisk", this.getFlowToDisk());
        cfMap.put("enableCompression", this.getEnableCompression());
        cfMap.put("compressionFactory", this.getCompressionFactory());
        cfMap.put("jndi", this.getJndi());
        cfMap.put("loadBalancingClientData", this.getLoadBalancingClientData());
        cfMap.put("defaultTxnBatchSize", this.getDefaultTxnBatchSize());
        cfMap.put("clientTransactionBufferSize", this.getClientTransactionBufferSize());
        return cfMap;
    }

    private Long getClientTransactionBufferSize() {
        try {
            return Long.valueOf(this.m_params.getParameter("clientTransactionBufferSize", 1));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Integer getDefaultTxnBatchSize() {
        try {
            return Integer.valueOf(this.m_params.getParameter("defaultTxnBatchSize", 1));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object getJndi() {
        return this.m_params.getParameter("jndi", 1);
    }

    public String getUser() {
        return this.m_params.getParameter("user", 1);
    }

    public String getPassword() {
        return this.m_params.getParameter("password", 1);
    }

    public String getConnectionID() {
        return this.m_params.getParameter("connectionID", 1);
    }

    public Boolean isFaultTolerant() {
        Boolean faultTolerant = Boolean.FALSE;
        try {
            faultTolerant = Boolean.valueOf(this.m_params.getParameter("faultTolerant", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return faultTolerant;
    }

    public Boolean isLoadBalanced() {
        Boolean loadBalanced = Boolean.FALSE;
        try {
            loadBalanced = Boolean.valueOf(this.m_params.getParameter("loadBalanced", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return loadBalanced;
    }

    private String getLoadBalancingClientData() {
        return this.m_params.getParameter("loadBalancingClientData", 1);
    }

    public Integer getInitialConnectTimeout() {
        Integer initialConnectTimeout = 30;
        try {
            initialConnectTimeout = Integer.valueOf(this.m_params.getParameter("initialConnectTimeout", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return initialConnectTimeout;
    }

    public Integer getFaultTolerantReconnectTimeout() {
        Integer ftReconnectTimeout = 60;
        try {
            ftReconnectTimeout = Integer.valueOf(this.m_params.getParameter("faultTolerantReconnectTimeout", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ftReconnectTimeout;
    }

    private Long getPingInterval() {
        Long pingInterval = 90L;
        try {
            pingInterval = Long.valueOf(this.m_params.getParameter("pingInterval", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pingInterval;
    }

    private Integer getMonitorInterval() {
        Integer monitorInterval = 60;
        try {
            monitorInterval = Integer.valueOf(this.m_params.getParameter("monitorInterval", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return monitorInterval;
    }

    private Integer getSocketConnectTimeout() {
        Integer socketConnectTimeout = 0;
        try {
            socketConnectTimeout = Integer.valueOf(this.m_params.getParameter("socketConnectTimeout", 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socketConnectTimeout;
    }

    private String getLoginSPIClassname() {
        return this.m_params.getParameter("loginSPIClass", 1);
    }

    public boolean retry() {
        boolean retry = false;
        try {
            String val = this.m_params.getParameter("retry", 1);
            retry = Boolean.getBoolean(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retry;
    }

    public int retryCount() {
        int retryCount = 1;
        try {
            String val = this.m_params.getParameter("retryCount", 1);
            retryCount = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retryCount;
    }

    private String getCompressionFactory() {
        return this.m_params.getParameter("compressionFactory", 1);
    }

    private Boolean getEnableCompression() {
        boolean enableCompression = false;
        try {
            String val = this.m_params.getParameter("enableCompression", 1);
            enableCompression = Boolean.parseBoolean(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return enableCompression;
    }
}

