/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.context.impl;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQInvocationContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQMitigationContext;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.context.ParameterDefinitions;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStreamFactory;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLString;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLTagMarker;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.Session;
import javax.xml.namespace.NamespaceContext;

public class InvocationContextImpl
implements InvocationContext {
    private long startupTime_;
    private long initializeTime_;
    private XQServiceContext serviceContext_;
    private XQEnvelope incoming_;
    private ArrayList<XQAddress> incomingAddresses_;
    private String incomingAsXML_;
    private XQLog log_;
    private ParameterDefinitions parameterDefinitions_;

    public InvocationContextImpl(ParameterDefinitions argDefinitions) throws XQServiceException {
        if (argDefinitions != null) {
            this.setParameterDefinitions(argDefinitions);
        }
    }

    public void addFault(XQEnvelope arg0) {
        this.serviceContext_.addFault(arg0);
    }

    public void addFault(XQMessage arg0) {
        this.serviceContext_.addFault(arg0);
    }

    public void addOutgoing(XQEnvelope arg0) {
        this.serviceContext_.addOutgoing(arg0);
    }

    public void addOutgoing(XQMessage arg0) {
        this.serviceContext_.addOutgoing(arg0);
    }

    public void clearFaults() {
        this.serviceContext_.clearFaults();
    }

    public void clearOutgoing() {
        this.serviceContext_.clearOutgoing();
    }

    public XQAccessorFactory getAccessorFactory() {
        return this.serviceContext_.getAccessorFactory();
    }

    public int getCurrentListener() {
        return this.serviceContext_.getCurrentListener();
    }

    public XQDispatch getDispatcher() {
        return this.serviceContext_.getDispatcher();
    }

    public ESBInteractorFactory getInteractorFactory() {
        return this.serviceContext_.getInteractorFactory();
    }

    public String getEntryEndpoint() {
        return this.serviceContext_.getEntryEndpoint();
    }

    public XQEnvelope getFirstIncoming() {
        return this.incoming_;
    }

    public XQEnvelope getNextIncoming() {
        return this.incoming_;
    }

    public XQProcessContext getProcessContext() {
        return this.serviceContext_.getProcessContext();
    }

    public Connection getCurrentJMSConnection() {
        return this.serviceContext_.getCurrentJMSConnection();
    }

    public Session getCurrentJMSSession() {
        return this.serviceContext_.getCurrentJMSSession();
    }

    public XQQualityofService getQoS() {
        return this.serviceContext_.getQoS();
    }

    public XQAddress getRMEAddress() {
        return this.serviceContext_.getRMEAddress();
    }

    public boolean hasNextIncoming() {
        return this.serviceContext_.hasNextIncoming();
    }

    public XQEndpointManager getEndpointManager() {
        return this.serviceContext_.getEndpointManager();
    }

    public XQAddressFactory getAddressFactory() {
        return this.serviceContext_.getAddressFactory();
    }

    public XQEnvelopeFactory getEnvelopeFactory() {
        return this.serviceContext_.getEnvelopeFactory();
    }

    public XQLifeCycleManager getLifeCycle() {
        return this.serviceContext_.getLifeCycle();
    }

    public XQLog getLog() {
        return this.serviceContext_.getLog();
    }

    public XQMessageFactory getMessageFactory() {
        return this.serviceContext_.getMessageFactory();
    }

    public XQParameters getParameters() {
        return this.serviceContext_.getParameters();
    }

    public XQMitigationContext getMitigationContext() {
        return this.serviceContext_.getMitigationContext();
    }

    public XQInvocationContext getInvocationContext() {
        return this.serviceContext_.getInvocationContext();
    }

    @Override
    public String getProcessID() throws XQServiceException {
        String returnValue = "";
        if (this.isInProcess()) {
            returnValue = this.serviceContext_.getProcessContext().getTrackingID();
        }
        return returnValue;
    }

    @Override
    public String getProcessName() throws XQServiceException {
        String returnValue = "";
        if (this.isInProcess()) {
            returnValue = this.serviceContext_.getProcessContext().getName();
        }
        return returnValue;
    }

    @Override
    public String getProcessStepName() throws XQServiceException {
        String returnValue = "";
        if (this.isInProcess()) {
            returnValue = this.serviceContext_.getProcessContext().getStepName();
        }
        return returnValue;
    }

    @Override
    public String getParameter(String argName) throws XQServiceException {
        if (this.parameterDefinitions_ != null) {
            return this.parameterDefinitions_.getParameter(argName).getValue();
        }
        throw new XQServiceException("Parameter " + argName + " is not defined");
    }

    @Override
    public boolean getBooleanParameter(String argName) throws XQServiceException {
        if (this.parameterDefinitions_ != null) {
            return this.parameterDefinitions_.getParameter(argName).getBooleanParameter();
        }
        throw new XQServiceException("Parameter " + argName + " is not defined");
    }

    @Override
    public int getIntParameter(String argName) throws XQServiceException {
        if (this.parameterDefinitions_ != null) {
            return this.parameterDefinitions_.getParameter(argName).getIntParameter();
        }
        throw new XQServiceException("Parameter " + argName + " is not defined");
    }

    @Override
    public long getLongParameter(String argName) throws XQServiceException {
        if (this.parameterDefinitions_ != null) {
            return this.parameterDefinitions_.getParameter(argName).getLongParameter();
        }
        throw new XQServiceException("Parameter " + argName + " is not defined");
    }

    @Override
    public String getStringParameter(String argName) throws XQServiceException {
        if (this.parameterDefinitions_ != null) {
            return this.parameterDefinitions_.getParameter(argName).getStringParameter();
        }
        throw new XQServiceException("Parameter " + argName + " is not defined");
    }

    @Override
    public void initialize(XQServiceContext argServiceContext, XQEnvelope argIncoming) throws XQServiceException {
        this.setServiceContext(argServiceContext);
        this.getServiceContext();
        this.setInitializeTime();
        this.setIncoming(argIncoming);
    }

    @Override
    public long getStartTime() throws XQServiceException {
        return this.startupTime_;
    }

    @Override
    public void endServiceCall() throws XQServiceException {
        this.serviceContext_ = null;
        if (this.parameterDefinitions_ != null) {
            this.parameterDefinitions_.unsetRuntimeParameters();
        }
    }

    @Override
    public void log(int argLevel, String argMessage) throws XQServiceException {
        this.log_.logError(argMessage);
    }

    private void setInitializeTime() throws XQServiceException {
        this.initializeTime_ = System.currentTimeMillis();
    }

    private void setServiceContext(XQServiceContext argServiceContext) throws XQServiceException {
        if (argServiceContext == null) {
            throw new XQServiceException("Cannot initialize Invocation context with null service context");
        }
        this.serviceContext_ = argServiceContext;
        if (this.parameterDefinitions_ != null) {
            this.parameterDefinitions_.setRuntimeParameters(argServiceContext);
        }
    }

    @Override
    public boolean isInProcess() throws XQServiceException {
        return this.serviceContext_.getProcessContext() != null;
    }

    @Override
    public XQServiceContext getServiceContext() {
        if (this.serviceContext_ == null) {
            throw new IllegalStateException("The Service execution context cannot be null");
        }
        return this.serviceContext_;
    }

    private void setParameterDefinitions(ParameterDefinitions argParams) throws XQServiceException {
        this.parameterDefinitions_ = argParams;
    }

    @Override
    public XQPart getPart(int argIndex) throws XQServiceException {
        try {
            int index = argIndex;
            if (argIndex == -1) {
                index = this.incoming_.getMessage().getPartCount() - 1;
            }
            return this.incoming_.getMessage().getPart(index);
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public boolean removePart(int argIndex) throws XQServiceException {
        try {
            int index = argIndex;
            if (argIndex == -1) {
                index = this.incoming_.getMessage().getPartCount() - 1;
            }
            this.incoming_.getMessage().removePart(index);
            return true;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public boolean removePart(String argPartName) throws XQServiceException {
        try {
            boolean returnValue = false;
            this.incoming_.getMessage().removePart(argPartName);
            returnValue = true;
            return returnValue;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public XQPart getPart(String argContentID) throws XQServiceException {
        try {
            XQPart returnValue = this.incoming_.getMessage().getPart(argContentID);
            return returnValue;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getMessagePartAsXML(int argIndex, boolean guessIfXML) throws XQServiceException {
        try {
            XQPart part = this.incoming_.getMessage().getPart(argIndex);
            return this.getMessagePartAsXML(part, guessIfXML);
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getMessagePartAsXML(String argContentID, boolean guessIfXML) throws XQServiceException {
        try {
            XQPart part = this.incoming_.getMessage().getPart(argContentID);
            return this.getMessagePartAsXML(part, guessIfXML);
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    public String getMessagePartAsXML(XQPart part, boolean guessIfXML) throws XQServiceException {
        Object contentObject = part.getContent();
        String contentString = null;
        if (contentObject != null && contentObject instanceof String) {
            contentString = (String)contentObject;
        }
        String id = part.getContentId();
        String type = part.getContentType();
        if (guessIfXML && contentString != null && contentString.startsWith("<")) {
            return contentString;
        }
        try {
            XMLOutputStream argStream = XMLOutputStreamFactory.create();
            argStream.startDocument();
            argStream.startTag("part");
            argStream.addAttribute("id", id);
            argStream.addAttribute("type", type);
            if (contentString != null) {
                argStream.writeTagData(XMLString.convertStringToXML(contentString));
            }
            argStream.endTag();
            argStream.endDocument();
            return argStream.toString();
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getMessagePartAsString(int argIndex) throws XQServiceException {
        try {
            String returnValue = null;
            XQPart part = this.incoming_.getMessage().getPart(argIndex);
            returnValue = (String)part.getContent();
            return returnValue;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getMessagePartAsString(String argContentID) throws XQServiceException {
        try {
            String returnValue = null;
            XQPart part = this.incoming_.getMessage().getPart(argContentID);
            returnValue = (String)part.getContent();
            return returnValue;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public boolean isPartPresent(int argIndex) throws XQServiceException {
        try {
            return this.incoming_.getMessage().getPart(argIndex) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isPartPresent(String argPartName) throws XQServiceException {
        try {
            return this.incoming_.getMessage().doesPartExist(argPartName);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getMessagePropertyValue(String argMessagePropertyName) throws XQServiceException {
        String returnValue = null;
        if (this.isMessagePropertyDefined(argMessagePropertyName)) {
            try {
                returnValue = this.incoming_.getMessage().getHeaderValue(argMessagePropertyName).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnValue;
    }

    @Override
    public boolean isMessagePropertyDefined(String argMessagePropertyName) throws XQServiceException {
        try {
            return this.incoming_.getMessage().getHeaderValue(argMessagePropertyName) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getMessagePropertyAsXML(String argMessagePropertyName, boolean guessIfXML) throws XQServiceException {
        String headerValue = this.getMessagePropertyValue(argMessagePropertyName);
        if (guessIfXML && headerValue != null && headerValue.startsWith("<")) {
            return headerValue;
        }
        try {
            XMLOutputStream argStream = XMLOutputStreamFactory.create();
            argStream.startDocument();
            argStream.startTag("header");
            String headerName = argMessagePropertyName;
            argStream.addAttribute("name", headerName);
            if (headerValue != null) {
                argStream.writeTagData(XMLString.convertStringToXML(headerValue));
            }
            argStream.endTag();
            argStream.endDocument();
            return argStream.toString();
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getRoutingExpressionValue(Expression expression) throws XQServiceException {
        ExpressionContext exprCtx = MappingUtils.getExpressionContext(this.getNextIncoming().getMessage(), this.serviceContext_);
        Object value = expression.getValue(exprCtx);
        if (value == null || value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Override
    public String getRoutingExpressionAsXML(Expression expression, boolean guessIfXML) throws XQServiceException {
        String value = this.getRoutingExpressionValue(expression);
        if (guessIfXML && value != null && value.startsWith("<")) {
            return value;
        }
        try {
            XMLOutputStream argStream = XMLOutputStreamFactory.create();
            argStream.startDocument();
            argStream.startTag("routingExpression");
            argStream.addAttribute("name", expression.toString());
            if (value != null) {
                argStream.writeTagData(XMLString.convertStringToXML(value));
            }
            argStream.endTag();
            argStream.endDocument();
            return argStream.toString();
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    @Override
    public String getXQMessageAsXML(int version) throws XQServiceException {
        if (version == -1) {
            return this.getIncomingAsXML(null);
        }
        return this.getIncomingAsXML(null);
    }

    private void setIncoming(XQEnvelope argIncoming) throws XQServiceException {
        this.incoming_ = argIncoming;
        this.incomingAddresses_ = new ArrayList();
        Iterator addresses = argIncoming.getAddresses();
        while (addresses.hasNext()) {
            this.incomingAddresses_.add((XQAddress)addresses.next());
        }
        argIncoming.clearAddresses();
    }

    @Override
    public void addAddressToIncoming(XQAddress argAddress) {
        this.incoming_.addAddress(argAddress);
    }

    @Override
    public void addDefaultAddressesToIncoming() {
        this.incoming_.addAddresses(this.incomingAddresses_);
    }

    @Override
    public void addIncomingToOutbox() {
        if (!this.incoming_.getAddresses().hasNext()) {
            this.addDefaultAddressesToIncoming();
        }
        this.addOutgoing(this.incoming_);
    }

    private String getIncomingAsXML(NamespaceContext argNamespaceContext) throws XQServiceException {
        try {
            if (this.incomingAsXML_ == null) {
                XMLOutputStream messageStream = XMLOutputStreamFactory.create();
                messageStream.startDocument();
                messageStream.startTag("message");
                this.addHeaders(messageStream);
                this.addParts(messageStream);
                messageStream.endTag();
                messageStream.endDocument();
                this.incomingAsXML_ = messageStream.toString();
            }
            return this.incomingAsXML_;
        }
        catch (Exception e) {
            if (e instanceof XQServiceException) {
                throw (XQServiceException)((Object)e);
            }
            throw new XQServiceException((Throwable)e);
        }
    }

    private void addHeaders(XMLOutputStream argStream) throws XQServiceException {
        try {
            XMLTagMarker marker = argStream.getTagMarker();
            argStream.startTag("headers");
            Iterator itr = this.incoming_.getMessage().getHeaderNames();
            while (itr.hasNext()) {
                argStream.startTag("header");
                String headerName = (String)itr.next();
                argStream.addAttribute("name", headerName);
                Object headerValueObject = this.incoming_.getMessage().getHeaderValue(headerName);
                if (headerValueObject != null) {
                    String headerValue = headerValueObject.toString();
                    if (headerValue.startsWith("<")) {
                        if (headerValue.startsWith("<?")) {
                            int endPIIndex = headerValue.indexOf("?>");
                            argStream.writeTagData(headerValue.substring(endPIIndex + 2));
                        } else {
                            argStream.writeTagData(headerValue);
                        }
                    } else {
                        argStream.writeTagData(XMLString.convertStringToXML(headerValue));
                    }
                }
                argStream.endTag();
            }
            argStream.endTag();
            argStream.closeTags(marker);
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQServiceException((Throwable)e);
        }
    }

    private void addParts(XMLOutputStream argStream) throws XQServiceException {
        try {
            XMLTagMarker marker = argStream.getTagMarker();
            argStream.startTag("parts");
            XQMessage currentMessage = this.getNextIncoming().getMessage();
            for (int i = 0; i < currentMessage.getPartCount(); ++i) {
                try {
                    XQPart currentPart = currentMessage.getPart(i);
                    XMLTagMarker partMarker = argStream.getTagMarker();
                    argStream.startTag("part");
                    String contentType = currentPart.getContentType();
                    argStream.addAttribute("type", contentType);
                    argStream.addAttribute("id", currentPart.getContentId());
                    Object contentObject = currentPart.getContent();
                    if (contentObject != null && contentObject instanceof String) {
                        String content = (String)contentObject;
                        if (content.startsWith("<")) {
                            if (content.startsWith("<?")) {
                                int endPIIndex = content.indexOf("?>");
                                argStream.writeTagData(content.substring(endPIIndex + 2));
                            } else {
                                argStream.writeTagData(content);
                            }
                        } else {
                            argStream.writeTagData(XMLString.convertStringToXML(content));
                        }
                    }
                    argStream.closeTags(partMarker);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof XQServiceException) {
                        throw (XQServiceException)((Object)e);
                    }
                    throw new XQServiceException((Throwable)e);
                }
            }
            argStream.closeTags(marker);
        }
        catch (Exception e) {
            if (e instanceof XQServiceException) {
                throw (XQServiceException)((Object)e);
            }
            throw new XQServiceException((Throwable)e);
        }
    }

    public String getFileFromDS(String argFileURL) throws XQServiceException {
        try {
            String returnValue = null;
            return returnValue;
        }
        catch (Exception e) {
            if (e instanceof XQServiceException) {
                throw (XQServiceException)((Object)e);
            }
            throw new XQServiceException((Throwable)e);
        }
    }

    public XQAddress getProcessContinuationAddress(XQProcessContinuation continuation) {
        return this.getServiceContext().getProcessContinuationAddress(continuation);
    }
}

