/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Config {
    private Document m_doc = null;

    Config() {
    }

    public void setConfig(Document doc) throws Exception {
        if (doc == null) {
            throw new NullPointerException("Can't access / read / parse the specified Deployment Descriptor.  This may be because the deployment descriptor is malformed or that it is not at the location specified in the ConnectionType.");
        }
        this.m_doc = doc;
        this.m_doc.normalize();
    }

    public Document getConfig() throws Exception {
        return this.m_doc;
    }

    public Element[] getElements(Node parent, String tagName, String attributeName, String attributeValue) {
        int childCount;
        Element[] elements = null;
        Vector<Node> childElements = new Vector<Node>();
        if (parent == null) {
            parent = this.m_doc;
        }
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int childCount2 = children.getLength();
            while (childCount2-- > 0) {
                boolean tobeAdded = true;
                Node child = children.item(childCount2);
                if (child == null || child.getNodeType() != 1) continue;
                if (tagName != null) {
                    tobeAdded = false;
                    if (tagName.equalsIgnoreCase(((Element)child).getTagName()) && (attributeName == null || attributeValue == null || attributeValue.equalsIgnoreCase(((Element)child).getAttribute(attributeName)))) {
                        tobeAdded = true;
                    }
                }
                if (!tobeAdded) continue;
                childElements.add(child);
            }
        }
        if ((childCount = childElements.size()) > 0) {
            elements = new Element[childCount];
            while (childCount-- > 0) {
                elements[childCount] = (Element)childElements.elementAt(childCount);
            }
        }
        return elements;
    }

    public Element getElement(Node parent, String tagName, String attributeName, String attributeValue, boolean deepSearch) {
        boolean found = false;
        Element element = null;
        if (parent == null) {
            parent = this.m_doc;
        }
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int childCount = children.getLength();
            while (childCount-- > 0) {
                Node child = children.item(childCount);
                if (child == null || child.getNodeType() != 1) continue;
                if (tagName != null && tagName.equalsIgnoreCase(((Element)child).getTagName()) && (attributeName == null || attributeValue == null || attributeValue.equalsIgnoreCase(((Element)child).getAttribute(attributeName)))) {
                    element = (Element)child;
                    found = true;
                    break;
                }
                if (found || !deepSearch || (element = this.getElement(child, tagName, attributeName, attributeValue, deepSearch)) == null) continue;
                found = true;
                break;
            }
        }
        return element;
    }

    public String getAttributeValue(Node parent, String name) {
        NamedNodeMap childAttributes;
        String value = null;
        if (parent != null && parent.getNodeType() == 1 && (childAttributes = parent.getAttributes()) != null) {
            int childAttributesCount = childAttributes.getLength();
            while (childAttributesCount-- > 0) {
                Node childAttribute = childAttributes.item(childAttributesCount);
                if (childAttribute == null || !childAttribute.getNodeName().equalsIgnoreCase(name)) continue;
                value = childAttribute.getNodeValue();
                break;
            }
        }
        return value;
    }

    public void getAttributes(Node parent, Map table) {
        NamedNodeMap childAttributes;
        if (table != null && parent != null && parent.getNodeType() == 1 && (childAttributes = parent.getAttributes()) != null) {
            int childAttributesCount = childAttributes.getLength();
            while (childAttributesCount-- > 0) {
                Node childAttribute = childAttributes.item(childAttributesCount);
                if (childAttribute == null) continue;
                table.put(childAttribute.getNodeName(), childAttribute.getNodeValue());
            }
        }
    }

    public String getNodeValue(Node parent) {
        NodeList children;
        String value = null;
        if (parent != null && (value = parent.getNodeValue()) == null && (children = parent.getChildNodes()) != null) {
            int childCount = children.getLength();
            while (childCount-- > 0) {
                Node child = children.item(childCount);
                if (child.getNodeType() != 3) continue;
                value = child.getNodeValue();
                break;
            }
        }
        return value;
    }

    public String[] getTokens(String source) {
        String[] tokens = null;
        if (source != null && source.length() > 0) {
            StringTokenizer strtok = new StringTokenizer(source);
            int tokenCount = strtok.countTokens();
            tokens = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                tokens[i] = strtok.nextToken();
            }
        }
        return tokens;
    }
}

