/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.IEndpointCleanerFuture;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class EndpointCleaner
extends Thread {
    private final IEndpointCleanerFuture m_cleaner;
    private volatile boolean m_isActive = true;
    private volatile Exception m_exception;
    private static final XQLog log = XQLogImpl.getCategoryLog((int)512);
    public static final long END_POINT_WAIT_TIME = 30000L;
    public static final String STOP = "Stop";
    public static final String STOPNOWAIT = "StopNoWait";

    public EndpointCleaner(IEndpointCleanerFuture cleaner) {
        this.m_cleaner = cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.m_cleaner.clean();
        }
        catch (Exception e) {
            this.m_exception = e;
        }
        finally {
            this.m_isActive = false;
        }
    }

    public Endpoint getCurrentEndpoint() {
        if (this.m_isActive) {
            return this.m_cleaner.getCurrentEndpoint();
        }
        return null;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    public void cleanEndpoint(String action) throws InterruptedException {
        this.start();
        if (action.equalsIgnoreCase(STOPNOWAIT)) {
            return;
        }
        while (this.isActive()) {
            JMSEndpoint jmsEndpoint;
            this.join(30000L);
            Endpoint endpoint = this.getCurrentEndpoint();
            if (endpoint == null || !endpoint.isJMS() || !(jmsEndpoint = (JMSEndpoint)endpoint).isInListener()) continue;
            String sendingDestination = jmsEndpoint.getSendingDestination();
            log.logInformation(EndpointCleaner.getLogInfo(action, jmsEndpoint.getName(), sendingDestination));
        }
    }

    public static String getLogInfo(String action, String endpointName, String sendingDestination) {
        String result = action + " is waiting for a service or process listening on endpoint: '" + endpointName + "' " + "to complete. ";
        result = sendingDestination != null ? result + " Currently an attempt to being made to send to endpoint: '" + sendingDestination + "'. This could be due JMS flow control." : result + " This could be due to a blocked service.";
        return result;
    }
}

