/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl;

import com.sonicsw.xqimpl.invk.ESBException;
import com.sonicsw.xqimpl.invk.ESBMessage;
import com.sonicsw.xqimpl.invk.ESBMessageContext;
import com.sonicsw.xqimpl.invk.ESBReturnParam;
import com.sonicsw.xqimpl.invkimpl.ESBMessageImpl;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;

public class ESBMessageContextImpl
implements ESBMessageContext {
    protected WSIFOperation m_wsifOperation;
    protected WSIFMessage m_wsifContext;
    protected String m_inputName;
    protected String m_outputName;
    protected HashMap m_inputMap = new HashMap();
    protected HashMap m_outputMap = new HashMap();
    protected HashMap m_faultMap = new HashMap();

    public ESBMessageContextImpl(WSIFOperation wsifOperation, String inputName, String outputName) throws ESBException {
        try {
            this.m_inputName = inputName;
            this.m_outputName = outputName;
            this.m_wsifOperation = wsifOperation;
            this.m_wsifContext = this.m_wsifOperation.getContext();
            this.init();
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    private void init() throws ESBException {
        try {
            this.m_wsifContext.setLongPart("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout", 90L);
            this.m_wsifContext.setIntPart("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService", 1);
            this.m_wsifContext.setIntPart("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_HTTP_PROVIDER", 1);
            this.m_wsifContext.setIntPart("com_sonicsw_xqimpl_invk_ESBConstants_RequestMessageType", 0);
            this.m_wsifContext.setLongPart("X-HTTP-RequestTimeout", 60L);
            this.m_wsifContext.setBooleanPart("IsSyncRequestReply", false);
            this.m_wsifContext.setBooleanPart("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP", false);
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public ESBMessage createInputMessage() throws ESBException {
        WSIFMessage WSIFInput = null;
        WSIFInput = this.m_inputName == null ? this.m_wsifOperation.createInputMessage() : this.m_wsifOperation.createInputMessage(this.m_inputName);
        if (WSIFInput == null) {
            throw new ESBException("unable-to-create-input-message", new Object[]{this.m_inputName}, 3);
        }
        return this.m_inputName == null ? new ESBMessageImpl(WSIFInput) : new ESBMessageImpl(this.m_inputName, WSIFInput);
    }

    @Override
    public ESBMessage createInputMessage(String name) throws ESBException {
        WSIFMessage WSIFInput = null;
        WSIFInput = name != null ? this.m_wsifOperation.createInputMessage(name) : (this.m_inputName != null ? this.m_wsifOperation.createInputMessage(this.m_inputName) : this.m_wsifOperation.createInputMessage());
        if (WSIFInput == null) {
            throw new ESBException("unable-to-create-input-message", new Object[]{name}, 3);
        }
        return new ESBMessageImpl(name, WSIFInput);
    }

    @Override
    public ESBMessage createOutputMessage() throws ESBException {
        WSIFMessage WSIFOutput = null;
        WSIFOutput = this.m_outputName == null ? this.m_wsifOperation.createOutputMessage() : this.m_wsifOperation.createOutputMessage(this.m_outputName);
        if (WSIFOutput == null) {
            throw new ESBException("unable-to-create-output-message", new Object[]{this.m_outputName}, 3);
        }
        return new ESBMessageImpl(this.m_outputName, WSIFOutput);
    }

    @Override
    public ESBMessage createOutputMessage(String name) throws ESBException {
        WSIFMessage WSIFOutput = null;
        WSIFOutput = name != null ? this.m_wsifOperation.createOutputMessage(name) : (this.m_outputName != null ? this.m_wsifOperation.createOutputMessage(this.m_outputName) : this.m_wsifOperation.createOutputMessage());
        if (WSIFOutput == null) {
            throw new ESBException("unable-to-create-output-message", new Object[]{name}, 3);
        }
        return new ESBMessageImpl(name, WSIFOutput);
    }

    public ESBMessage createFaultMessage() throws ESBException {
        WSIFMessage WSIFFault = this.m_wsifOperation.createFaultMessage();
        if (WSIFFault == null) {
            throw new ESBException("unable-to-create-fault-message", new Object[]{""}, 3);
        }
        return new ESBMessageImpl(null, WSIFFault);
    }

    public ESBMessage createFaultMessage(String name) throws ESBException {
        WSIFMessage WSIFFault = null;
        WSIFFault = name != null ? this.m_wsifOperation.createFaultMessage(name) : this.m_wsifOperation.createFaultMessage();
        if (WSIFFault == null) {
            throw new ESBException("unable-to-create-fault-message", new Object[]{name}, 3);
        }
        return new ESBMessageImpl(name, WSIFFault);
    }

    @Override
    public void addInputMessage(String name, ESBMessage message) throws ESBException {
        this.m_inputMap.put(name, message);
    }

    @Override
    public ESBMessage getInputMessage(String name) {
        ESBMessage input = (ESBMessage)this.m_inputMap.get(name);
        if (input == null && this.m_inputMap.values().iterator().hasNext()) {
            input = (ESBMessage)this.m_inputMap.values().iterator().next();
        }
        return input;
    }

    @Override
    public void removeInputMessage(String name) {
        this.m_inputMap.remove(name);
    }

    @Override
    public Iterator getInputMessages() {
        return this.m_inputMap.values().iterator();
    }

    @Override
    public void addOutputMessage(String name, ESBMessage message) throws ESBException {
        this.m_outputMap.put(name, message);
    }

    @Override
    public ESBMessage getOutputMessage(String name) {
        ESBMessage output = (ESBMessage)this.m_outputMap.get(name);
        if (output == null && this.m_outputMap.values().iterator().hasNext()) {
            output = (ESBMessage)this.m_outputMap.values().iterator().next();
        }
        return output;
    }

    @Override
    public void removeOutputMessage(String name) {
        this.m_outputMap.remove(name);
    }

    @Override
    public Iterator getOutputMessages() {
        return this.m_outputMap.values().iterator();
    }

    public void addFaultMessage(String name, ESBMessage message) throws ESBException {
        this.m_faultMap.put(name, message);
    }

    public ESBMessage getFaultMessage(String name) {
        ESBMessage fault = (ESBMessage)this.m_faultMap.get(name);
        if (fault == null && this.m_faultMap.values().iterator().hasNext()) {
            fault = (ESBMessage)this.m_faultMap.values().iterator().next();
        }
        return fault;
    }

    public void removeFaultMessage(String name) {
        this.m_faultMap.remove(name);
    }

    public Iterator getFaultMessages() {
        return this.m_faultMap.values().iterator();
    }

    @Override
    public Object getProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getObjectPart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public void setProperty(String key, Object value) throws ESBException {
        try {
            if (value != null && value instanceof String) {
                String stringPropValue = (String)value;
                stringPropValue = stringPropValue.trim();
                if (key.equals("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout")) {
                    this.m_wsifContext.setObjectPart(key, (Object)Long.valueOf(stringPropValue));
                } else if (key.equals("X-HTTP-RequestTimeout") || key.equals("X-HTTP-Retries") || key.equals("X-HTTP-RetryInterval")) {
                    this.m_wsifContext.setObjectPart(key, (Object)Integer.valueOf(stringPropValue));
                } else if (key.equals("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService") || key.equals("com_sonicsw_xqimpl_invk_ESBConstants_RequestMessageType") || key.equals("JMSXGroupSeq")) {
                    this.m_wsifContext.setObjectPart(key, (Object)Integer.valueOf(stringPropValue));
                } else if (key.equals("X-HTTP-ReplyAsSOAP") || key.equals("IsSyncRequestReply") || key.equals("load_external_dtds") || key.equals("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FAULT_AS_SOAP") || key.equals("com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest") || key.equals("JMS_SonicMQ_lastMessageInGroup") || key.equals("UseReplyTo") || key.equals("AsyncReplyTo") || key.equals("AutoGenerateGroupID")) {
                    this.m_wsifContext.setObjectPart(key, (Object)Boolean.valueOf(stringPropValue));
                } else {
                    this.m_wsifContext.setObjectPart(key, value);
                }
            } else {
                this.m_wsifContext.setObjectPart(key, value);
            }
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public int getIntProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getIntPart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public short getShortProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getShortPart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public long getLongProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getLongPart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public boolean getBooleanProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getBooleanPart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public double getDoubleProperty(String key) throws ESBException {
        try {
            return this.m_wsifContext.getDoublePart(key);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public void setBooleanProperty(String key, boolean value) throws ESBException {
        try {
            this.m_wsifContext.setBooleanPart(key, value);
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public void setLongProperty(String key, long value) throws ESBException {
        try {
            this.m_wsifContext.setLongPart(key, value);
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public void setShortProperty(String key, short value) throws ESBException {
        try {
            this.m_wsifContext.setShortPart(key, value);
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public void setDoubleProperty(String key, double value) throws ESBException {
        try {
            this.m_wsifContext.setDoublePart(key, value);
            this.m_wsifOperation.setContext(this.m_wsifContext);
        }
        catch (Throwable ex) {
            throw new ESBException(ex);
        }
    }

    @Override
    public Iterator getPropertyNames() {
        return this.m_wsifContext.getPartNames();
    }

    @Override
    public Iterator getProperties() {
        return this.m_wsifContext.getParts();
    }

    @Override
    public ESBReturnParam getRawRequest() {
        try {
            return (ESBReturnParam)this.m_wsifOperation.getContext().getObjectPart("RawRequest");
        }
        catch (WSIFException e) {
            return null;
        }
    }

    @Override
    public ESBReturnParam getRawResponse() {
        try {
            return (ESBReturnParam)this.m_wsifOperation.getContext().getObjectPart("RawResponse");
        }
        catch (WSIFException e) {
            return null;
        }
    }
}

