/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.DirectHTTPSender;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.script.Command;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ParameterValueFactory;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.rm.handlers.OutboundRMHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class ESBJmsSender
extends BasicHandler {
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);
    private static XQLog m_RMLog = XQLogImpl.getCategoryLog((int)16384);
    private DirectHTTPSender m_directSender = new DirectHTTPSender();
    private static final int ROUND_ROBIN_COUNT = 1024;
    private static int index = 0;

    public void invoke(MessageContext msgContext) throws AxisFault {
        block14: {
            if (this.m_directSender.delegatesToDirectSender(msgContext)) {
                this.m_directSender.invoke(msgContext);
                return;
            }
            try {
                Endpoint xqEndpoint;
                ESBWSIFJMSDestination dest = (ESBWSIFJMSDestination)msgContext.getProperty("Destination");
                long timeout = 90000L;
                if (msgContext.containsProperty("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout")) {
                    timeout = (Long)msgContext.getProperty("com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout") * 1000L;
                }
                int qos = 1;
                if (msgContext.containsProperty("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService")) {
                    qos = (Integer)msgContext.getProperty("com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService");
                }
                if ((xqEndpoint = dest.getEndpoint()) == null) {
                    throw new AxisFault("ESBJmsSender:xqEndpoint is null!");
                }
                XQMessage xqRequestMessage = dest.createXQMessage(msgContext);
                this.logRawRequest(msgContext, xqRequestMessage, dest);
                boolean waitForResponse = false;
                if (msgContext.containsProperty("IsSyncRequestReply")) {
                    waitForResponse = (Boolean)msgContext.getProperty("IsSyncRequestReply");
                }
                boolean forceRequestResponse = false;
                if (msgContext.containsProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP")) {
                    forceRequestResponse = (Boolean)msgContext.getProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP");
                }
                this.applyPolicyProperties(dest, xqRequestMessage, waitForResponse, msgContext);
                if (waitForResponse) {
                    int count;
                    log.logDebug("Invoking synchronous SOAP request-response callout. Waiting for response...");
                    this.setX_HTTPGroupIDProperty(dest, xqRequestMessage, msgContext);
                    XQMessage xqResponseMessage = ((JMSEndpoint)xqEndpoint).syncWSInvokeWithQoS(xqRequestMessage, timeout, XQQualityofService.valueOf((int)qos));
                    try {
                        String strippedContent = DOMUtils.stripByteOrderMark((String)((String)xqResponseMessage.getPart(0).getContent()));
                        if (strippedContent != null) {
                            XQPart prt = xqResponseMessage.getPart(0);
                            prt.setContent((Object)strippedContent, "text/xml");
                            xqResponseMessage.replacePart(prt, 0);
                        }
                    }
                    catch (IOException e) {
                        log.logDebug((Throwable)e);
                    }
                    dest.setOutMessage(xqResponseMessage);
                    int n = count = xqResponseMessage == null ? 0 : xqResponseMessage.getPartCount();
                    if (count <= 0) {
                        throw new AxisFault("Response Message is null!");
                    }
                    Object soap = this.getSoap(xqResponseMessage);
                    if (forceRequestResponse && soap instanceof String && ((String)soap).length() == 0) {
                        return;
                    }
                    Message axisMsg = new Message(soap);
                    msgContext.setResponseMessage(axisMsg);
                    msgContext.setPastPivot(true);
                    break block14;
                }
                log.logDebug("Invoking one-way SOAP request callout...");
                ((JMSEndpoint)xqEndpoint).asyncWSInvokeWithQoS(XQQualityofService.valueOf((int)qos), xqRequestMessage);
                log.logDebug("Done invoking one-way SOAP request callout.");
            }
            catch (Exception e) {
                throw new AxisFault("Axis SOAP request failed.", (Throwable)e);
            }
        }
    }

    public void undo(MessageContext messageContext) {
    }

    private void logRawRequest(MessageContext msgContext, XQMessage xqRequestMessage, ESBWSIFJMSDestination dest) throws Exception {
        boolean logRawRequest = false;
        if (msgContext.containsProperty("com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest")) {
            logRawRequest = (Boolean)msgContext.getProperty("com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest");
        }
        if (logRawRequest) {
            log.logInformation("Raw SOAP Request:" + (String)this.getSoap(xqRequestMessage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugSOAP(String name, String soap, int location, ParameterDirection direction) {
        Command c = Command.getCommand();
        if (c != null) {
            try {
                ArrayList<IParameterValue> result = new ArrayList<IParameterValue>();
                ParameterValueFactory factory = new ParameterValueFactory(false);
                IParameterValue value = factory.createParameterValue(name, "xsd:anyType", soap);
                value.setDisplayType(name);
                value.setDirection(direction);
                result.add(value);
                Location scriptLocation = c.pushRunDebugLocation(location);
                c.processParameterTestLocation(result, scriptLocation);
            }
            catch (Throwable t) {
            }
            finally {
                c.popRunDebugLocation();
            }
        }
    }

    private Object getSoap(XQMessage xqMessage) throws Exception {
        return xqMessage.getPart(0).getContent();
    }

    private void setX_HTTPGroupIDProperty(ESBWSIFJMSDestination dest, XQMessage xqRequestMessage, MessageContext msgContext) throws Exception {
        boolean autoGenerate;
        Map props = dest.getGroupIDProps();
        boolean bl = autoGenerate = props.containsKey("AutoGenerateGroupID") ? (Boolean)props.get("AutoGenerateGroupID") : true;
        if (autoGenerate && !props.containsKey("X-HTTP-GroupID")) {
            String url = dest.getLocationURL();
            String id = this.generateGroupId(url);
            xqRequestMessage.setStringHeader("X-HTTP-GroupID", id);
        }
    }

    private synchronized String generateGroupId(String url) {
        String urlString = url == null ? "UNKNOWN_URL" : url;
        StringBuilder id = new StringBuilder(urlString);
        id.append("$$");
        id.append(index);
        index = (index + 1) % 1024;
        return id.toString();
    }

    private void applyPolicyProperties(ESBWSIFJMSDestination dest, XQMessage xqRequestMessage, boolean waitForResponse, MessageContext msgContext) throws Exception {
        IWSRMSequence rmSeq;
        String wsPolicy = dest.getPolicy();
        String wsResponsePolicy = dest.getResponsePolicy();
        String wsFaultPolicy = dest.getFaultPolicy();
        if (wsPolicy == null && wsResponsePolicy == null && wsFaultPolicy == null) {
            return;
        }
        if (wsPolicy != null) {
            xqRequestMessage.setStringHeader("X-WS-MessagePolicy", wsPolicy);
        }
        if (wsResponsePolicy != null) {
            xqRequestMessage.setStringHeader("X-WS-MessagePolicy-Out", wsResponsePolicy);
        } else if (waitForResponse) {
            xqRequestMessage.setStringHeader("X-WS-MessagePolicy-Out", "");
        }
        if (wsFaultPolicy != null) {
            xqRequestMessage.setStringHeader("X-WS-MessagePolicy-Fault", wsFaultPolicy);
        } else if (waitForResponse) {
            xqRequestMessage.setStringHeader("X-WS-MessagePolicy-Fault", "");
        }
        Map rmProps = dest.getRMProps();
        String serializedRMEngine = (String)rmProps.get("SonicESB.RM.SequenceMap");
        OutboundRMHandler rmHandler = null;
        boolean bTerminateSequence = false;
        if (serializedRMEngine != null && dest.getESBWSType() == 1 || dest.getESBWSType() == 2) {
            bTerminateSequence = true;
        }
        m_RMLog.logDebug("bTerminateSequence=" + bTerminateSequence + " for epr=" + dest.getDynamicEPR());
        if (serializedRMEngine != null && !dest.isCreateSequence() && (rmSeq = (rmHandler = new OutboundRMHandler(dest)).getSequence()) != null) {
            xqRequestMessage.setStringHeader("JMSXGroupID", rmSeq.getSequenceID());
            xqRequestMessage.setIntHeader("JMSXGroupSeq", rmSeq.getSequenceNumber());
            xqRequestMessage.setBooleanHeader("JMS_SonicMQ_lastMessageInGroup", bTerminateSequence);
            if (m_RMLog.isDebugLoggingEnabled()) {
                m_RMLog.logDebug("epr=" + dest.getDynamicEPR());
                m_RMLog.logDebug("rmHandler.getId()=" + rmSeq.getSequenceID());
                m_RMLog.logDebug("rmHandler.getNr()=" + rmSeq.getSequenceNumber());
            }
        }
        if (bTerminateSequence && !dest.isCreateSequence()) {
            IWSRMEngine rmEngine = rmHandler.getRMEngine();
            IWSRMSequence rmSeq2 = rmHandler.getSequence();
            if (rmSeq2 != null) {
                if (m_RMLog.isDebugLoggingEnabled()) {
                    m_RMLog.logDebug("Engine=" + rmEngine.serialize());
                    m_RMLog.logDebug("Sequence=" + rmHandler.getSequence());
                    m_RMLog.logDebug("EPR=" + dest.getDynamicEPR());
                }
                rmEngine.removeSequence(rmSeq2);
            }
        }
        if (rmHandler != null) {
            if (m_RMLog.isDebugLoggingEnabled()) {
                m_RMLog.logDebug("Serializing map into msgContext,map=" + rmHandler.getRMEngine().serialize());
            }
            msgContext.setProperty("SonicESB.RM.SequenceMap", (Object)rmHandler.getRMEngine().serialize());
        }
    }
}

