/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xqimpl.invkimpl.ESBReturnParamImpl;
import com.sonicsw.xqimpl.invkimpl.WSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.AxisFaultExceptionCreator;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBJmsTransport;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFPort_ApacheAxis;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.HRefUtils;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SOAPReturnValueImpl;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SoapBodyFactory;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SoapParameters;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.TypeUtils;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifOperation;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseWsifPort;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Call;
import org.apache.axis.client.Transport;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.types.URI;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ESBWSIFOperation_ApacheAxis
extends BaseEsbWsifOperation {
    private ESBWSIFPort_ApacheAxis m_wsifPort;
    private List m_outputSOAPParts;
    private AxisFaultExceptionCreator m_axisFaultCreator;
    private SoapParameters m_soapParameters;
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public ESBWSIFOperation_ApacheAxis(ESBWSIFPort_ApacheAxis wsifPort, BindingOperation bindingOperation, WSIFDynamicTypeMap typeMap) {
        super((BaseWsifPort)wsifPort, bindingOperation, typeMap);
        this.m_wsifPort = wsifPort;
    }

    @Override
    protected void initializeCall(WSIFMessage context) throws WSIFException {
        super.initializeCall(context);
        this.m_axisFaultCreator = new AxisFaultExceptionCreator(this.m_scriptCommand);
    }

    private void parseBindingInput() throws WSIFException {
        List inJmsPropVals;
        List inExtElems;
        BindingInput bindinginput = this.m_bindingOperation.getBindingInput();
        SOAPBody inSoapBody = (SOAPBody)this.m_wsifPort.getExtElem(bindinginput, SOAPBody.class, inExtElems = bindinginput.getExtensibilityElements());
        if (inSoapBody == null) {
            throw new GeneralWSInvocationException("binding-input-invalid", new Object[]{this.getName()});
        }
        List inJmsProps = this.m_wsifPort.getExtElems(bindinginput, JMSProperty.class, bindinginput.getExtensibilityElements());
        if (inJmsProps != null && inJmsProps.size() > 0) {
            if (this.m_wsifPort.isTransportJMS()) {
                this.setInputJmsProperties(inJmsProps);
            } else {
                throw new GeneralWSInvocationException("esb-property-in-non-jms-binding", null);
            }
        }
        if ((inJmsPropVals = this.m_wsifPort.getExtElems(bindinginput, JMSPropertyValue.class, bindinginput.getExtensibilityElements())) != null && inJmsPropVals.size() > 0) {
            if (this.m_wsifPort.isTransportJMS()) {
                this.addInputJmsPropertyValues(inJmsPropVals);
            } else {
                throw new GeneralWSInvocationException("esb-property-value-in-non-jms-binding", null);
            }
        }
    }

    private void parseBindingOutput() throws WSIFException {
        SOAPBody outSoapBody = null;
        boolean bIsInput = false;
        if (this.m_scriptCommand.getCommandType() == 3) {
            BindingInput bindinginput = this.m_bindingOperation.getBindingInput();
            if (bindinginput != null) {
                List outExtElems = bindinginput.getExtensibilityElements();
                outSoapBody = (SOAPBody)this.m_wsifPort.getExtElem(bindinginput, SOAPBody.class, outExtElems);
            }
            bIsInput = true;
        } else {
            BindingOutput bindingoutput = this.m_bindingOperation.getBindingOutput();
            if (bindingoutput != null) {
                List outExtElems = bindingoutput.getExtensibilityElements();
                outSoapBody = (SOAPBody)this.m_wsifPort.getExtElem(bindingoutput, SOAPBody.class, outExtElems);
                if (outSoapBody == null) {
                    throw new GeneralWSInvocationException("binding-input-invalid", new Object[]{this.getName()});
                }
                List outJmsProps = this.m_wsifPort.getExtElems(bindingoutput, JMSProperty.class, outExtElems);
                if (outJmsProps != null && outJmsProps.size() > 0) {
                    if (this.m_wsifPort.isTransportJMS()) {
                        this.setOutputJmsProperties(outJmsProps);
                    } else {
                        throw new GeneralWSInvocationException("esb-properties-in-non-jms-binding", null);
                    }
                }
            }
        }
        if (outSoapBody != null) {
            this.m_outputSOAPParts = this.parseSoapBody(outSoapBody, bIsInput);
        }
    }

    private List parseSoapBody(SOAPBody soapbody, boolean isInput) throws WSIFException {
        Message m = null;
        if (isInput) {
            Input in = this.m_portTypeOperation.getInput();
            if (in != null) {
                m = in.getMessage();
            }
        } else {
            Output out = this.m_portTypeOperation.getOutput();
            if (out != null) {
                m = out.getMessage();
            }
        }
        return this.getParts(m, soapbody.getParts());
    }

    public String getSoapActionURI() {
        String ret = this.m_scriptCommand.getSOAPInfo().getActionURI();
        if (this.m_scriptCommand.getCommandType() == 0 && ret != null) {
            if (ret.length() == 0) {
                return "\"\"";
            }
            return ret;
        }
        ret = this.calculateDefaultAction();
        return ret;
    }

    public Transport getTransport() throws WSIFException {
        Transport t = this.m_wsifPort.getTransport(this.m_scriptCommand.getSOAPInfo().getEndpointURL());
        return t;
    }

    @Override
    public boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg) throws WSIFException {
        this.m_soapParameters = new SoapParameters(this.m_scriptCommand);
        ESBWSIFJMSDestination dest = this.setTransportProperties();
        this.setDestinationContext(dest);
        Call call = this.initCall(dest);
        this.setCallContext(call);
        if (this.m_scriptCommand.getCommandType() == 2) {
            this.invokeFault(call, inMsg, outMsg);
        } else if (this.m_scriptCommand.getCommandType() == 3) {
            this.invokeUnwrap(call, inMsg, outMsg);
        } else {
            this.invokeInvocation(call, inMsg, outMsg, dest);
        }
        if (this.m_scriptCommand.getCommandType() != 3 && this.m_scriptCommand.getCommandType() != 1) {
            this.reportWSResponseToLG(call, dest.m_responseMsg, null);
        }
        this.setWSResponsePropsInWSIFCtx(call, dest);
        return true;
    }

    private void setWSResponsePropsInWSIFCtx(Call call, ESBWSIFJMSDestination dest) throws WSIFException {
        MessageContext axisContext = call.getMessageContext();
        Object val = axisContext.getProperty("SonicESB.RM.SequenceMap");
        if (val != null) {
            this.context.setObjectPart("SonicESB.RM.SequenceMap", axisContext.getProperty("SonicESB.RM.SequenceMap"));
            this.setContext(this.context);
        }
        if (dest.getOutProperties() != null && (val = dest.getOutProperties().get("JMS_SonicMQ_lastMessageInGroup")) != null) {
            this.context.setBooleanPart("JMS_SonicMQ_lastMessageInGroup", ((Boolean)val).booleanValue());
            this.setContext(this.context);
        }
    }

    private void reportWSResponseToLG(Call call, XQMessage response, String faultResponse) {
        ESBVisitor visitor = null;
        ESBVisitorContext actionalContext = null;
        try {
            visitor = (ESBVisitor)this.context.getObjectPart("com.sonicsw.esb.visitor");
            actionalContext = (ESBVisitorContext)this.context.getObjectPart("com.sonicsw.esb.visitor.ActionalContext");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (visitor != null) {
            HashMap<String, Object> visitorParams = new HashMap<String, Object>();
            if (response != null) {
                visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", response);
            }
            visitorParams.put("ESBVisitor.PARAM_ESBWS_COMMAND", this.m_scriptCommand);
            if (faultResponse != null) {
                visitorParams.put("ESBVisitor.PARAM_WS_FAULT_RESPONSE", faultResponse);
            }
            if (actionalContext != null) {
                visitorParams.put("ESBVisitor.PARAM_RUNTIME_CONTEXT", actionalContext);
            }
            visitor.receivedFromWebService(visitorParams);
        }
    }

    @Override
    protected void setDefaultProps(Map jmsProps) {
        if (!jmsProps.containsKey("X-HTTP-ReplyAsSOAP")) {
            jmsProps.put("X-HTTP-ReplyAsSOAP", new Boolean(true));
        }
        if (!jmsProps.containsKey("X-WS-SuppressWSAHeaders")) {
            jmsProps.put("X-WS-SuppressWSAHeaders", new Boolean(false));
        }
    }

    private ESBWSIFJMSDestination setTransportProperties() throws WSIFException {
        Transport axistransport = this.getTransport();
        ESBWSIFJMSDestination dest = null;
        if (axistransport != null && axistransport instanceof ESBJmsTransport) {
            ESBJmsTransport jmst = (ESBJmsTransport)axistransport;
            dest = jmst.getDestination();
            if (dest != null && this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
                dest.setProperties(this.inJmsPropVals);
            }
            this.setTransportProperties(this.inJmsPropVals);
        }
        return dest;
    }

    private Call initCall(ESBWSIFJMSDestination dest) throws WSIFException {
        boolean suppressWSAHeaders;
        Call call = this.m_wsifPort.getCall();
        call.removeAllParameters();
        call.clearHeaders();
        call.setTargetEndpointAddress((URL)null);
        this.prepare(call);
        call.setOperationStyle("message");
        String s = this.getSoapActionURI();
        call.setUseSOAPAction(true);
        call.setSOAPActionURI(s);
        call.setEncodingStyle(this.getInputEncodingStyle());
        call.setProperty("call.CheckMustUnderstand", (Object)Boolean.FALSE);
        Transport axistransport = this.getTransport();
        if (axistransport != null) {
            call.setTransport(axistransport);
        }
        if (!(suppressWSAHeaders = this.evaluateProperty(dest, "X-WS-SuppressWSAHeaders", false))) {
            this.initWSCall(call, dest);
        }
        return call;
    }

    private void initWSCall(Call call, ESBWSIFJMSDestination dest) throws WSIFException {
        String wsaAction;
        this.setWSANamespace(call);
        AxisEngine.getCurrentMessageContext();
        String url = null;
        Element eprElem = this.m_scriptCommand.getEndpointReference();
        if (eprElem != null) {
            try {
                String wsaNS = eprElem.getNamespaceURI();
                EndpointReference epr = new EndpointReference(eprElem);
                AttributedURI addr = epr.getAddress();
                if (addr != null) {
                    url = addr.toString();
                }
                this.addReferenceData(call, epr, wsaNS);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((wsaAction = this.m_scriptCommand.getWSAAction()) != null) {
            call.setSOAPActionURI(wsaAction);
            call.setUseSOAPAction(true);
        } else if (call.getSOAPActionURI() == null || call.getSOAPActionURI().length() == 0 || "\"\"".equals(call.getSOAPActionURI())) {
            call.setSOAPActionURI(this.calculateDefaultAction());
            call.setUseSOAPAction(true);
        }
        dest.inProps.put("SOAPAction", call.getSOAPActionURI());
        if (url == null) {
            url = this.m_scriptCommand.getSOAPInfo().getEndpointURL();
        }
        if (url == null) {
            url = dest.getLocationURL();
        }
        this.setWSATo(url, call, dest);
        try {
            this.setWSAReply(url, call, dest);
            this.setWSAFault(url, call, dest);
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            throw new GeneralWSInvocationException("malformed-uri", new Object[0], e);
        }
        AddressingHandler reqAddressingHandler = new AddressingHandler();
        reqAddressingHandler.setOption("allowNonSpecificActions", (Object)"true");
        reqAddressingHandler.init();
        AddressingHandler resAddressingHandler = new AddressingHandler();
        resAddressingHandler.setOption("allowNonSpecificActions", (Object)"true");
        resAddressingHandler.init();
        call.setClientHandlers((Handler)reqAddressingHandler, (Handler)resAddressingHandler);
    }

    private void setWSANamespace(Call call) {
        String ns = this.getWSANamespace();
        if (ns != null) {
            call.setProperty("addressing.namespace.URI", (Object)ns);
        }
    }

    private String getWSANamespace() {
        try {
            String s = (String)this.getContextNoClone().getObjectPart("WSA_NAMESPACE");
            return s;
        }
        catch (WSIFException ex) {
            return null;
        }
    }

    private void setWSATo(String url, Call call, ESBWSIFJMSDestination dest) throws WSIFException {
        ESBJmsTransport transport;
        Boolean ReqRep;
        if (url != null) {
            call.setProperty("transport.url", (Object)url);
        }
        boolean reqRep = (ReqRep = (transport = (ESBJmsTransport)this.getTransport()).getSyncRequestReply()) != null && ReqRep != false;
        String returnURL = AddressingUtils.getAnonymousRoleURI(this.getWSANamespace());
        if (dest.assertAsyncResponse()) {
            returnURL = "urn:REQUEST_SYSTEM_ASSIGNED";
        }
        call.setProperty("addressing.from.URI", (Object)returnURL);
        if (reqRep) {
            call.setProperty("addressing.sendReplyTo", (Object)"true");
            call.setProperty("addressing.replyTo.URI", (Object)returnURL);
            call.setProperty("addressing.faultTo.URI", (Object)returnURL);
        }
    }

    private void setWSAReply(String url, Call call, ESBWSIFJMSDestination dest) throws URI.MalformedURIException, GeneralWSInvocationException {
        EndpointReference epr = null;
        AddressingHeaders replyHeaders = null;
        WSAHeaders inboundWSA = dest.getWSAHeaders();
        if (inboundWSA != null && (dest.getUseReplyTo() || dest.getESBWSType() == 1)) {
            epr = dest.getDynamicReplyTo();
            if (epr != null) {
                replyHeaders = new AddressingHeaders(epr);
            } else if (dest.getJMSReplyTo() == null && "http://www.sonicsw.com/esb/replyto-destination-required".equals(url)) {
                throw new GeneralWSInvocationException("no-epr-supplied", new Object[0]);
            }
            if (replyHeaders == null) {
                replyHeaders = new AddressingHeaders();
            }
            if (inboundWSA.getMessageID() != null) {
                replyHeaders.addRelatesTo(inboundWSA.getMessageID().toString(), AddressingUtils.getResponseRelationshipType(inboundWSA.getWSANamespace()));
            }
            if (dest.isCreateSequence()) {
                replyHeaders.setFrom(new EndpointReference(AddressingUtils.getAnonymousRoleURI(inboundWSA.getWSANamespace())));
            } else if (inboundWSA.getTo() != null) {
                replyHeaders.setFrom(new EndpointReference(inboundWSA.getTo().toString()));
            }
            call.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)replyHeaders);
            call.setProperty("addressing.namespace.URI", (Object)inboundWSA.getWSANamespace());
        }
    }

    private void setWSAFault(String url, Call call, ESBWSIFJMSDestination dest) throws URI.MalformedURIException, GeneralWSInvocationException {
        EndpointReference epr = null;
        AddressingHeaders faultHeaders = null;
        WSAHeaders inboundWSA = dest.getWSAHeaders();
        if (inboundWSA != null && dest.getESBWSType() == 2) {
            epr = dest.getDynamicFaultTo();
            if (epr != null) {
                faultHeaders = new AddressingHeaders(epr);
            } else if (dest.getJMSReplyTo() == null && "http://www.sonicsw.com/esb/replyto-destination-required".equals(url)) {
                throw new GeneralWSInvocationException("no-epr-supplied", new Object[0]);
            }
            if (faultHeaders == null) {
                faultHeaders = new AddressingHeaders();
            }
            if (inboundWSA.getMessageID() != null) {
                faultHeaders.addRelatesTo(inboundWSA.getMessageID().toString(), AddressingUtils.getResponseRelationshipType(inboundWSA.getWSANamespace()));
            }
            if (dest.isCreateSequence()) {
                faultHeaders.setFrom(new EndpointReference(AddressingUtils.getAnonymousRoleURI(inboundWSA.getWSANamespace())));
            } else if (inboundWSA.getTo() != null) {
                faultHeaders.setFrom(new EndpointReference(inboundWSA.getTo().toString()));
            }
            call.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)faultHeaders);
            call.setProperty("addressing.namespace.URI", (Object)inboundWSA.getWSANamespace());
        }
    }

    private void serializeReferenceProperties(Call call, AddressingHeaders hdr) throws Exception {
        ReferencePropertiesType referenceProperties = hdr.getReferenceProperties();
        if (referenceProperties == null) {
            return;
        }
        SOAPHeaderElement element = null;
        for (int i = 0; i < referenceProperties.size(); ++i) {
            Object refProp = referenceProperties.get(i);
            element = this.getReferencePropertyElement(element, refProp);
            call.addHeader(element);
        }
    }

    private void addReferenceData(Call call, EndpointReference epr, String wsaNS) throws Exception {
        List params;
        int i;
        ReferencePropertiesType referenceProperties = epr.getProperties();
        if (referenceProperties != null) {
            SOAPHeaderElement element = null;
            for (i = 0; i < referenceProperties.size(); ++i) {
                Object refProp = referenceProperties.get(i);
                element = this.getReferencePropertyElement(element, refProp);
                call.addHeader(element);
            }
        }
        if (!(params = epr.getParameters()).isEmpty()) {
            for (i = 0; i < params.size(); ++i) {
                MessageElement me = (MessageElement)params.get(i);
                SOAPHeaderElement element = new SOAPHeaderElement(me.getAsDOM());
                element.setAttribute(wsaNS, "isReferenceParameter", "true");
                call.addHeader(element);
            }
        }
    }

    private SOAPHeaderElement getReferencePropertyElement(SOAPHeaderElement element, Object refProp) throws Exception {
        if (refProp instanceof SOAPHeaderElement) {
            element = (SOAPHeaderElement)refProp;
        } else if (refProp instanceof MessageElement) {
            MessageElement msgElement = (MessageElement)refProp;
            element = new SOAPHeaderElement(msgElement.getAsDOM());
        } else if (refProp instanceof Element) {
            Element refPropElement = (Element)refProp;
            element = new SOAPHeaderElement(refPropElement);
        } else {
            throw new Exception("Unable to create a Reference Property for " + refProp.getClass().getName());
        }
        return element;
    }

    private void addWSAProperties(Call call, EndpointReference eprRef) throws Exception {
    }

    private void invokeUnwrap(Call call, WSIFMessage inMsg, WSIFMessage outMsg) throws WSInvocationException {
        try {
            ESBWSParameter p = this.m_scriptCommand.getParameter("SOAPEnvelope");
            String envXML = p.getParameterValue().getAsStringIncludeXMLHeader();
            SOAPEnvelope requestEnvelope = SoapBodyFactory.createSOAPEnvelope(envXML);
            SOAPEnvelope responseEnvelope = HRefUtils.flattenResponse(requestEnvelope);
            this.setResponseHeaders(responseEnvelope);
            if (outMsg != null) {
                boolean isRPC = this.m_scriptCommand.getSOAPInfo().getOperationStyle().equalsIgnoreCase("rpc");
                if (isRPC) {
                    this.setOutputRPCMessageValues(responseEnvelope.getBodyElements(), outMsg);
                } else {
                    this.setOutputMessageValues(responseEnvelope.getBodyElements(), outMsg);
                }
            }
        }
        catch (ScriptEngineException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
        catch (AxisFault fault) {
            throw this.m_axisFaultCreator.createException(fault, call.getResponseMessage(), this.m_faultAsSoap);
        }
        catch (RemoteException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    private void invokeFault(Call call, WSIFMessage inMsg, WSIFMessage outMsg) throws WSInvocationException {
        try {
            List soapBodies = SoapBodyFactory.createFaultBody(this.m_scriptCommand, this.m_soapParameters);
            SOAPEnvelope requestEnvelope = SoapBodyFactory.createSOAPEnvelope(call.getMessageContext(), soapBodies);
            call.invoke(requestEnvelope);
            this.addRawSoapRequest(requestEnvelope);
        }
        catch (AxisFault fault) {
            throw this.m_axisFaultCreator.createException(fault, call.getResponseMessage(), this.m_faultAsSoap);
        }
        catch (RemoteException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    private void invokeInvocation(Call call, WSIFMessage inMsg, WSIFMessage outMsg, ESBWSIFJMSDestination dest) throws WSInvocationException {
        boolean isRPC = this.m_scriptCommand.getSOAPInfo().getOperationStyle().equalsIgnoreCase("rpc");
        try {
            List soapBodies = isRPC ? SoapBodyFactory.createRPCBody(this.m_scriptCommand, this.m_soapParameters) : SoapBodyFactory.createDocLitBody(this.m_scriptCommand, this.m_soapParameters);
            SOAPEnvelope requestEnvelope = SoapBodyFactory.createSOAPEnvelope(call.getMessageContext(), soapBodies);
            SOAPEnvelope responseEnvelope = call.invoke(requestEnvelope);
            responseEnvelope = HRefUtils.flattenResponse(responseEnvelope);
            Vector axisResponse = responseEnvelope == null ? null : responseEnvelope.getBodyElements();
            this.addRawSoapRequest(requestEnvelope);
            this.addRawSoapResponse(responseEnvelope);
            this.setResponseHeaders(responseEnvelope);
            if (axisResponse != null && outMsg != null) {
                if (isRPC) {
                    this.setOutputRPCMessageValues(axisResponse, outMsg);
                } else {
                    this.setOutputMessageValues(axisResponse, outMsg);
                }
            }
        }
        catch (AxisFault fault) {
            this.reportWSResponseToLG(call, dest.m_responseMsg, fault.getFaultString());
            throw this.m_axisFaultCreator.createException(fault, call.getResponseMessage(), this.m_faultAsSoap);
        }
        catch (RemoteException e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    private void prepare(Call call) throws WSIFException {
        this.m_outputSOAPParts = new ArrayList();
        this.parseBindingInput();
        this.parseBindingOutput();
        this.addInputJmsPropertyValues(this.m_wsifPort.getJmsAddressPropVals());
        if (this.getInputNamespace() == null || this.getInputNamespace().length() < 1) {
            this.m_inputNamespace = this.getTargetNamespaceURI();
        }
        WSIFMessage context = this.getContextNoClone();
        TypeMapping tm = call.getTypeMapping();
        TypeUtils.registerDefaultTypeMappings(tm, context);
        TypeUtils.registerDynamicTypes(tm, this.m_typeMap, context);
    }

    private void setOutputMessageValues(Object axisResponse, WSIFMessage outMsg) throws WSIFException {
        Vector v = (Vector)axisResponse;
        if (v.size() == 0) {
            log.logInformation("Output Doc/Literal SOAP Body is null!");
        }
        for (int i = 0; i < v.size(); ++i) {
            Object body = v.elementAt(i);
            if (body instanceof SOAPBodyElement) {
                SOAPBodyElement respEl = (SOAPBodyElement)body;
                if (this.m_outputSOAPParts.size() == 1 && v.size() == 1) {
                    this.setSOAPPart(outMsg, respEl, (Part)this.m_outputSOAPParts.get(0));
                    continue;
                }
                if (this.m_outputSOAPParts.size() <= 1 && v.size() <= 1) continue;
                QName qn = new QName(respEl.getNamespaceURI(), respEl.getName());
                Part p = this.findPart(this.m_outputSOAPParts, qn);
                if (p != null) {
                    this.setSOAPPart(outMsg, respEl, p);
                    continue;
                }
                log.logDebug("Expected SOAP output part not found:" + qn);
                continue;
            }
            throw new GeneralWSInvocationException("invalid-response-type", new Object[]{v.elementAt(i)});
        }
    }

    private void addRawSoapResponse(SOAPEnvelope env) throws WSIFException {
        if (env != null) {
            SOAPReturnValueImpl retParam = new SOAPReturnValueImpl(env);
            this.context.setObjectPart("RawResponse", (Object)retParam);
        }
    }

    private void addRawSoapRequest(SOAPEnvelope env) throws WSIFException {
        if (env != null) {
            SOAPReturnValueImpl retParam = new SOAPReturnValueImpl(env);
            this.context.setObjectPart("RawRequest", (Object)retParam);
        }
    }

    private void setOutputRPCMessageValues(Object axisResponse, WSIFMessage outMsg) throws WSIFException {
        Vector v = (Vector)axisResponse;
        if (v.size() == 0) {
            log.logInformation("Output RPC SOAP Body is null!");
        }
        for (Object body : v) {
            if (body instanceof SOAPBodyElement) {
                boolean set;
                SOAPBodyElement respEl = (SOAPBodyElement)body;
                QName qn = new QName(respEl.getNamespaceURI(), respEl.getName());
                if (this.m_outputSOAPParts.size() <= 0 || (set = this.setRPCSOAPPart(this.m_outputSOAPParts, respEl, outMsg))) continue;
                log.logDebug("Expected RPC SOAP output part not found:" + qn);
                continue;
            }
            throw new GeneralWSInvocationException("invalid-response-type", new Object[]{body.getClass().getName()});
        }
    }

    private void setSOAPPart(WSIFMessage outMsg, SOAPBodyElement respEl, Part p) throws WSIFException {
        Element responseValue = null;
        try {
            responseValue = respEl.getAsDOM();
        }
        catch (Exception e) {
            throw new GeneralWSInvocationException("error-in-soapbody-as-dom", new Object[]{e.getLocalizedMessage()}, e);
        }
        String partName = p.getName();
        ESBReturnParamImpl returnParam = new ESBReturnParamImpl(true, responseValue, null);
        outMsg.setObjectPart(partName, (Object)returnParam);
    }

    private Part findPart(List partsList, QName partName) {
        Part part = null;
        Iterator i = partsList.iterator();
        while (i.hasNext() && part == null) {
            Part p = (Part)i.next();
            if (partName.equals(p.getElementName())) {
                part = p;
                continue;
            }
            if (!partName.getLocalPart().equals(p.getName())) continue;
            part = p;
        }
        return part;
    }

    private boolean setRPCSOAPPart(List partsList, SOAPBodyElement respElem, WSIFMessage outMsg) throws WSIFException {
        String outPartName = null;
        Node responseValue = null;
        boolean outSet = false;
        try {
            for (Part p : partsList) {
                if (respElem == null) continue;
                SOAPBodyElement topLevel = respElem;
                NodeList children = topLevel.getChildNodes();
                for (int z = 0; z < children.getLength(); ++z) {
                    Node child = children.item(z);
                    outPartName = null;
                    String elementName = child.getLocalName();
                    if (elementName == null) {
                        elementName = child.getNodeName();
                    }
                    if (elementName.equals(p.getName())) {
                        outPartName = p.getName();
                        ESBWSParameter parm = this.m_scriptCommand.getParameter(p.getName());
                        if (parm.isComplexType()) {
                            if (!this.m_soapParameters.isOutputParamElement(p.getName())) {
                                responseValue = child;
                            } else if (child.getNodeType() == 1) {
                                responseValue = DOMUtils.getFirstChildElement((Element)((Element)child));
                            }
                        } else {
                            responseValue = child.getFirstChild();
                        }
                    }
                    if (outPartName != null && responseValue != null) {
                        ESBReturnParamImpl returnParam = new ESBReturnParamImpl(true, responseValue, null);
                        outMsg.setObjectPart(outPartName, (Object)returnParam);
                        outSet = true;
                    }
                    responseValue = null;
                    outPartName = null;
                }
            }
        }
        catch (Exception ex) {
            throw new GeneralWSInvocationException("error-in-soapbody-as-dom", new Object[]{ex.getLocalizedMessage()}, ex);
        }
        return outSet;
    }

    @Override
    public Map createDestinationContext() throws WSIFException {
        Map jmsProps = super.createDestinationContext();
        String jmsSOAPAction = this.getSoapActionURI();
        jmsProps.put("SOAPAction", jmsSOAPAction);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("Prop JMS SOAPAction=" + jmsProps.get("SOAPAction"));
        }
        return jmsProps;
    }

    private void setContextProperty(Call call, String propertyName) {
        try {
            Object obj = this.getContextNoClone().getObjectPart(propertyName);
            call.getMessageContext().setProperty(propertyName, obj);
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
    }

    private void setCallContext(Call call) {
        this.setContextProperty(call, "com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService");
        this.setContextProperty(call, "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_HTTP_PROVIDER");
        this.setContextProperty(call, "com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout");
        this.setContextProperty(call, "com_sonicsw_xqimpl_invk_ESBConstants_RequestMessageType");
        this.setContextProperty(call, "X-HTTP-Retries");
        this.setContextProperty(call, "X-HTTP-RetryInterval");
        this.setContextProperty(call, "X-HTTP-GroupID");
        this.setContextProperty(call, "X-HTTP-RequestTimeout");
        try {
            Object obj = this.context.getObjectPart("ESBRequestSOAPHeaders");
            if (obj instanceof Map) {
                this.addSOAPHeader(call, (Map)obj);
            }
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
    }

    private void setResponseHeaders(SOAPEnvelope env) throws WSIFException {
        if (env != null) {
            SOAPHeader soapHeader;
            try {
                soapHeader = env.getHeader();
            }
            catch (SOAPException e) {
                throw new GeneralWSInvocationException("error-in-getting-response-headers", null, e);
            }
            this.addContextResponseSOAPHeaders(soapHeader);
        }
    }

    private void addSOAPHeader(Call call, Map soapHeaders) throws WSIFException {
        Document doc = DOMUtils.createDocument();
        for (String name : soapHeaders.keySet()) {
            Element elem;
            Object value = soapHeaders.get(name);
            if (value instanceof Element) {
                Element el = this.m_soapParameters.createElementFromComplexDoc(name, (Element)value, doc);
                call.addHeader(new SOAPHeaderElement(el));
                continue;
            }
            if (!(value instanceof String) || (elem = this.m_soapParameters.createElementFromSimple(name, (String)value, false, doc)) == null) continue;
            call.addHeader(new SOAPHeaderElement(elem));
        }
    }

    private void addContextResponseSOAPHeaders(SOAPHeader soapHeader) throws WSIFException {
        if (soapHeader == null) {
            return;
        }
        HashMap<String, SOAPHeaderElement> contextResponseHeaders = new HashMap<String, SOAPHeaderElement>();
        Iterator i = soapHeader.getChildElements();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SOAPHeaderElement) {
                SOAPHeaderElement she = (SOAPHeaderElement)o;
                if (she.hasAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "root") && "0".equals(she.getAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "root"))) continue;
                QName sheQName = new QName(she.getNamespaceURI(), she.getName());
                String partName = this.m_soapParameters.getNameFromSoapHeaderOutputQName(sheQName);
                try {
                    if (partName == null) continue;
                    contextResponseHeaders.put(partName, she);
                }
                catch (Exception e) {
                    log.logInformation("Exception in getting response SOAP header:" + sheQName + " due to " + e.getMessage());
                    log.logInformation((Throwable)e);
                }
                continue;
            }
            log.logDebug("unexpected response SOAP header type: " + o);
        }
        this.context.setObjectPart("ESBResponseSOAPHeaders", contextResponseHeaders);
        this.setContext(this.context);
    }

    private void setTransportProperties(Map inJmsPropVals) throws WSIFException {
        if (inJmsPropVals != null) {
            Iterator i = inJmsPropVals.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (this.setTransportProperty(name, inJmsPropVals.get(name))) {
                    // empty if block
                }
                i.remove();
            }
        }
        WSIFMessage context = this.getContextNoClone();
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            try {
                this.setTransportProperty(partName, context.getObjectPart(partName));
            }
            catch (Throwable ex) {}
        }
    }

    private boolean setTransportProperty(String propertyName, Object value) throws WSIFException {
        if (value == null) {
            return false;
        }
        if (!this.isTransportProperty(propertyName)) {
            return false;
        }
        ESBJmsTransport transport = (ESBJmsTransport)this.getTransport();
        if (this.isTimeoutProperty(propertyName)) {
            this.setTimeoutProperty(value, transport);
        }
        if (this.isQoSProperty(propertyName)) {
            this.setQosProperty(value, transport);
        }
        if (this.isRequestReplyProperty(propertyName)) {
            this.setRequestResponse(value, transport);
        }
        if (this.isForceRequestResponseProperty(propertyName)) {
            this.setForceRequestResponse(value, transport);
        }
        if (this.isLogRawRequestProperty(propertyName)) {
            this.setLogRawRequestProperty(value, transport);
        }
        if (this.isHTTPProviderOptionProperty(propertyName)) {
            this.setHTTPProviderOptionProperty(value, transport);
        }
        return true;
    }

    private void setRequestResponse(Object value, ESBJmsTransport transport) {
        Boolean reqRep = null;
        reqRep = value instanceof String ? Boolean.valueOf(value.toString()) : (Boolean)value;
        transport.setSyncRequestReply(reqRep);
    }

    private void setForceRequestResponse(Object value, ESBJmsTransport transport) {
        Boolean reqRep = null;
        reqRep = value instanceof String ? Boolean.valueOf(value.toString()) : (Boolean)value;
        transport.setForceRequestResponse(reqRep);
    }

    private void setLogRawRequestProperty(Object value, ESBJmsTransport transport) {
        Boolean reqRep = null;
        reqRep = value instanceof String ? Boolean.valueOf(value.toString()) : (Boolean)value;
        transport.setLogRawRequest(reqRep);
    }

    private void setHTTPProviderOptionProperty(Object value, ESBJmsTransport transport) {
        Integer httpProviderOption = null;
        httpProviderOption = value instanceof String ? Integer.valueOf(value.toString()) : (Integer)value;
        transport.setHTTPProviderOption(httpProviderOption);
    }

    private void setQosProperty(Object value, ESBJmsTransport transport) {
        Integer qos = null;
        qos = value instanceof String ? new Integer(value.toString()) : (Integer)value;
        transport.setESBQoS(qos);
    }

    private void setTimeoutProperty(Object value, ESBJmsTransport transport) {
        Long syncTimeout = null;
        syncTimeout = value instanceof String ? new Long(value.toString()) : (Long)value;
        transport.setESBRequestTimeout(syncTimeout);
    }

    private boolean isTransportProperty(String propertyName) {
        return this.isTimeoutProperty(propertyName) || this.isQoSProperty(propertyName) || this.isRequestReplyProperty(propertyName) || this.isForceRequestResponseProperty(propertyName) || this.isLogRawRequestProperty(propertyName) || this.isHTTPProviderOptionProperty(propertyName);
    }

    private boolean isRequestReplyProperty(String propertyName) {
        return "IsSyncRequestReply".equals(propertyName);
    }

    private boolean isForceRequestResponseProperty(String propertyName) {
        return "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP".equals(propertyName);
    }

    private boolean isQoSProperty(String propertyName) {
        return "com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService".equals(propertyName);
    }

    private boolean isTimeoutProperty(String propertyName) {
        return "com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout".equals(propertyName);
    }

    private boolean isLogRawRequestProperty(String propertyName) {
        return "com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest".equals(propertyName);
    }

    private boolean isHTTPProviderOptionProperty(String propertyName) {
        return "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_HTTP_PROVIDER".equals(propertyName);
    }

    private boolean evaluateProperty(ESBWSIFJMSDestination dest, String propertyName, boolean deflt) {
        boolean result = deflt;
        Object pO = dest.inProps.get(propertyName);
        if (pO != null) {
            if (pO instanceof String) {
                result = "true".equalsIgnoreCase((String)pO);
            } else if (pO instanceof Boolean) {
                result = (Boolean)pO;
            }
        }
        return result;
    }
}

