/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.common;

import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.envelope.XQURLAddressImpl;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifJmsProperties;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.IDynamicDestination;
import com.sonicsw.xqimpl.script.wsdl.WSDLScriptCommand;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import com.sonicsw.xqimpl.ws.addressing.WSEndpointReferenceImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.types.URI;
import org.apache.wsif.WSIFException;

public abstract class BaseEsbWsifJmsDestination
implements IDynamicDestination {
    public boolean asyncMode = false;
    public Queue syncTempQueue = null;
    public BaseEsbWsifJmsProperties inProps;
    public BaseEsbWsifJmsProperties outProps;
    public XQMessage m_responseMsg = null;
    public long timeout;
    public String replyToName = null;
    public String m_locationURL;
    private Endpoint m_xqEndpoint;
    private String m_endpointName = null;
    protected boolean m_runningInContainer = true;
    protected static Object m_endpointManagerLock = new Object();
    protected static Map m_endpointInstanceTracker = new HashMap();
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);
    private XQAddressFactoryImpl m_factory = new XQAddressFactoryImpl(null, -1);
    protected static List IGNORED_PROPERTIES = Arrays.asList("ConnectionConfig", "DefaultJMSConnectionConfig", "DefaultHTTPConnectionConfig", "ConfigManagerProps", "DirectoryServiceProxy", "IComponentContext", "ESBRequestSOAPHeaders", "ESBResponseSOAPHeaders", "com_sonicsw_xqimpl_invk_ESBConstants_RequestMessageType", "com_sonicsw_xqimpl_invk_ESBConstants_ESBQualityofService", "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_HTTP_PROVIDER", "com_sonicsw_xqimpl_invk_ESBConstants_ESBRequestTimeout", "com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest", "ScriptCommand", "com_sonicsw_xqimpl_invk_ESBConstants_Command", "com.sonicsw.esb.visitor", "com.sonicsw.esb.visitor.ActionalContext", "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FAULT_AS_SOAP", "SonicESB.RM.WSAHeaders", "SonicESB.RM.SequenceMap", "RoutingNode", "UseReplyTo", "AsyncReplyTo", "SonicESB.RM.JMSReplyTo", "SonicESB.RM.ESBWSType", "SonicESB.RM.WSPolicy", "SonicESB.RM.WSResponsePolicy", "SonicESB.RM.WSFaultPolicy", "IsCreateSequenceForResponse", "DESTINATION_EPR", "AutoGenerateGroupID", "WSA_NAMESPACE", "IsSyncRequestReply", "com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP");

    public BaseEsbWsifJmsDestination(String location) throws WSIFException {
        this.inProps = new BaseEsbWsifJmsProperties("in");
        this.outProps = new BaseEsbWsifJmsProperties("out");
        this.setLocationURL(location, null);
    }

    public void setUserDefinedProperty(Class type, XQMessage message, String prop, Object value) throws XQMessageException {
        if (type.equals(String.class)) {
            message.setHeaderValue(prop, (Object)value.toString());
        } else if (type.equals(Integer.class)) {
            message.setIntHeader(prop, ((Integer)value).intValue());
        } else if (type.equals(Boolean.class)) {
            message.setBooleanHeader(prop, ((Boolean)value).booleanValue());
        } else if (type.equals(Byte.class)) {
            message.setByteHeader(prop, ((Byte)value).byteValue());
        } else if (type.equals(Double.class)) {
            message.setDoubleHeader(prop, ((Double)value).doubleValue());
        } else if (type.equals(Float.class)) {
            message.setFloatHeader(prop, ((Float)value).floatValue());
        } else if (type.equals(Long.class)) {
            message.setLongHeader(prop, ((Long)value).longValue());
        } else if (type.equals(Short.class)) {
            message.setShortHeader(prop, ((Short)value).shortValue());
        } else {
            message.setHeaderValue(prop, value);
        }
    }

    public XQConnectionConfig getConnectionConfig() throws WSIFException {
        XQConnectionConfig connectionConfig = (XQConnectionConfig)this.inProps.get("ConnectionConfig");
        if (connectionConfig == null) {
            connectionConfig = (XQConnectionConfig)this.inProps.get(this.getDefaultConnectionKey());
        }
        if (connectionConfig == null) {
            throw new GeneralWSInvocationException("connections-are-null", null);
        }
        return connectionConfig;
    }

    public String getDefaultConnectionKey() {
        return "DefaultJMSConnectionConfig";
    }

    public void setProperty(String name, Object value) throws WSIFException {
        if (name != null && value != null) {
            this.inProps.put(name, value);
        }
    }

    public void setProperties(Map propMap) {
        if (propMap != null && !propMap.isEmpty()) {
            this.inProps.putAll(propMap);
        }
    }

    public Map getOutProperties() throws WSIFException {
        if (this.m_responseMsg == null) {
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.getPropertiesFromMessage(this.m_responseMsg);
        }
        if (!this.outProps.isEmpty()) {
            return this.outProps;
        }
        return null;
    }

    public Object getOutProperty(String name) throws WSIFException {
        if (this.m_responseMsg == null) {
            return null;
        }
        if (this.outProps.isEmpty()) {
            this.getPropertiesFromMessage(this.m_responseMsg);
        }
        Object prop = null;
        if (name != null) {
            prop = this.outProps.get(name);
        }
        return prop;
    }

    public void setOutMessage(XQMessage responseMsg) {
        this.m_responseMsg = responseMsg;
    }

    public void getPropertiesFromMessage(XQMessage message) throws WSIFException {
        this.outProps.clear();
        try {
            this.outProps.put("JMSCorrelationID", message.getHeaderValue("JMSCorrelationID"));
            this.outProps.put("JMSDeliveryMode", message.getHeaderValue("JMSDeliveryMode"));
            this.outProps.put("JMSDestination", message.getHeaderValue("JMSDestination"));
            this.outProps.put("JMSExpiration", message.getHeaderValue("JMSExpiration"));
            this.outProps.put("JMSMessageID", message.getHeaderValue("JMSMessageID"));
            this.outProps.put("JMSPriority", message.getHeaderValue("JMSPriority"));
            this.outProps.put("JMSRedelivered", message.getHeaderValue("JMSRedelivered"));
            this.outProps.put("JMSReplyTo", message.getHeaderValue("JMSReplyTo"));
            this.outProps.put("JMSTimestamp", message.getHeaderValue("JMSTimestamp"));
            this.outProps.put("JMSType", message.getHeaderValue("JMSType"));
            Iterator itr = message.getHeaderNames();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                this.outProps.put(name, message.getHeaderValue(name));
            }
        }
        catch (XQMessageException je) {
            throw new GeneralWSInvocationException(je.getMessage(), null, je);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws WSIFException {
        Endpoint currentEndpoint;
        if (!this.m_runningInContainer && (currentEndpoint = this.getCurrentEndpoint()) != null) {
            Object object = m_endpointManagerLock;
            synchronized (object) {
                Integer counter = (Integer)m_endpointInstanceTracker.get(currentEndpoint);
                if (counter != null) {
                    if ((counter = new Integer(counter - 1)) == 0) {
                        m_endpointInstanceTracker.remove(currentEndpoint);
                    } else {
                        m_endpointInstanceTracker.put(currentEndpoint, counter);
                    }
                }
                if (counter == null || counter == 0) {
                    try {
                        EndpointManager.getInstance().removeEndpoint(this.getCurrentEndpoint().getConfig().getName());
                        EndpointManager.getInstance().releaseConnection(this.getCurrentEndpoint().getConnectionName());
                        EndpointManager.getInstance().removeConnection(this.getCurrentEndpoint().getConnectionName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.getCurrentEndpoint().destroy();
                }
                this.setCurrentEndpoint(null);
            }
        }
    }

    public void setCurrentEndpoint(Endpoint xqEndpoint) {
        this.m_xqEndpoint = xqEndpoint;
    }

    Endpoint getCurrentEndpoint() {
        return this.m_xqEndpoint;
    }

    public void finalize() throws WSIFException {
        this.close();
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(this.toString() + "\n");
            buff = buff + " asyncMode: " + this.asyncMode;
            buff = buff + " syncTempQueue: " + this.syncTempQueue;
            buff = buff + " inProps: " + this.inProps;
            buff = buff + " outProps: " + this.outProps;
            buff = buff + " lastMessage: " + this.m_responseMsg;
            buff = buff + " timeout: " + this.timeout;
            buff = buff + " replyToName: " + this.replyToName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buff;
    }

    public Map getSendProps() throws WSIFException {
        HashMap<String, Number> sendProps = new HashMap<String, Number>();
        if (this.inProps.isEmpty()) {
            return null;
        }
        for (String prop : this.inProps.keySet()) {
            Object value = this.inProps.get(prop);
            Class<?> type = value.getClass();
            if (!BaseEsbWsifJmsProperties.predefinedProps.contains(prop)) continue;
            try {
                if (prop.equals("JMSDeliveryMode")) {
                    sendProps.put("JMSDeliveryMode", (Integer)value);
                    continue;
                }
                if (prop.equals("JMSPriority")) {
                    sendProps.put("JMSPriority", (Integer)value);
                    continue;
                }
                if (!prop.equals("timeToLive")) continue;
                sendProps.put("timeToLive", (Long)value);
            }
            catch (ClassCastException ce) {
                throw new GeneralWSInvocationException("unexpected-jms-type", new Object[]{type, prop});
            }
        }
        return sendProps;
    }

    public Map getGroupIDProps() throws WSIFException {
        HashMap httpGroupIDProps = new HashMap();
        if (this.inProps.isEmpty()) {
            return null;
        }
        for (String prop : this.inProps.keySet()) {
            Object value = this.inProps.get(prop);
            Class<?> type = value.getClass();
            try {
                if (prop.equals("AutoGenerateGroupID")) {
                    httpGroupIDProps.put("AutoGenerateGroupID", value);
                    continue;
                }
                if (!prop.equals("X-HTTP-GroupID")) continue;
                httpGroupIDProps.put("X-HTTP-GroupID", (String)value);
            }
            catch (ClassCastException ce) {
                throw new GeneralWSInvocationException("unexpected-type", new Object[]{type, prop});
            }
        }
        return httpGroupIDProps;
    }

    public Map getRMProps() throws WSIFException {
        HashMap<String, Object> rmProps = new HashMap<String, Object>();
        if (this.inProps.isEmpty()) {
            return null;
        }
        for (String prop : this.inProps.keySet()) {
            Object value = this.inProps.get(prop);
            Class<?> type = value.getClass();
            try {
                if (prop.equals("SonicESB.RM.SequenceMap")) {
                    rmProps.put("SonicESB.RM.SequenceMap", (String)value);
                    continue;
                }
                if (prop.equals("SonicESB.RM.WSAHeaders")) {
                    rmProps.put("SonicESB.RM.WSAHeaders", (WSAHeaders)value);
                    continue;
                }
                if (!prop.equals("DESTINATION_EPR")) continue;
                rmProps.put("DESTINATION_EPR", (IWSEndpointReference)value);
            }
            catch (ClassCastException ce) {
                throw new GeneralWSInvocationException("unexpected-type", new Object[]{type, prop});
            }
        }
        return rmProps;
    }

    public String getPolicy() {
        return (String)this.inProps.get("SonicESB.RM.WSPolicy");
    }

    public boolean isCreateSequence() {
        return this.inProps.get("IsCreateSequenceForResponse") != null;
    }

    public String getResponsePolicy() {
        return (String)this.inProps.get("SonicESB.RM.WSResponsePolicy");
    }

    public String getFaultPolicy() {
        return (String)this.inProps.get("SonicESB.RM.WSFaultPolicy");
    }

    public int getESBWSType() {
        String t = (String)this.inProps.get("SonicESB.RM.ESBWSType");
        if (t != null) {
            return WSDLScriptCommand.getESBWSTypeForName(t);
        }
        return 0;
    }

    public boolean getUseReplyTo() {
        boolean useReplyTo = false;
        Boolean prop = (Boolean)this.inProps.get("UseReplyTo");
        if (prop != null) {
            useReplyTo = prop;
        }
        return useReplyTo;
    }

    public String getRoutingNode() {
        return (String)this.inProps.get("RoutingNode");
    }

    public WSAHeaders getWSAHeaders() {
        return (WSAHeaders)this.inProps.get("SonicESB.RM.WSAHeaders");
    }

    public boolean assertAsyncResponse() {
        boolean assertAsyncResponse = false;
        Boolean prop = (Boolean)this.inProps.get("AsyncReplyTo");
        if (prop != null) {
            assertAsyncResponse = prop;
        }
        return assertAsyncResponse;
    }

    public XQAddress getJMSReplyTo() {
        XQAddressImpl jmsReplyTo = null;
        String serailizedReply = (String)this.inProps.get("SonicESB.RM.JMSReplyTo");
        if (serailizedReply != null) {
            int separator = serailizedReply.lastIndexOf(":");
            jmsReplyTo = new XQAddressImpl(serailizedReply.substring(0, separator), serailizedReply.substring(separator + 1));
        }
        return jmsReplyTo;
    }

    @Override
    public void setDynamicReplyTo(EndpointReference ref) {
    }

    @Override
    public EndpointReference getDynamicReplyTo() {
        WSAHeaders wsaHdrs = this.getWSAHeaders();
        if (wsaHdrs != null) {
            return wsaHdrs.getEffectiveReplyTo();
        }
        return null;
    }

    @Override
    public void setDynamicFaultTo(EndpointReference ref) {
    }

    @Override
    public EndpointReference getDynamicFaultTo() {
        WSAHeaders wsaHdrs = this.getWSAHeaders();
        if (wsaHdrs != null) {
            return wsaHdrs.getEffectiveFaultTo();
        }
        return null;
    }

    @Override
    public void setDynamicFrom(EndpointReference ref) {
    }

    @Override
    public EndpointReference getDynamicFrom() {
        WSAHeaders wsaHdrs = this.getWSAHeaders();
        if (wsaHdrs != null) {
            return wsaHdrs.getFrom();
        }
        return null;
    }

    protected Endpoint createXQEndpoint(XQConnectionConfig connectionConfig, Hashtable configMgrProps) throws Exception {
        XQEndpointConfig endpointConfig = this.createSourceXQEndpointConfig(connectionConfig);
        Endpoint xqEndpoint = this.createXQEndpoint(endpointConfig, configMgrProps);
        return xqEndpoint;
    }

    protected XQEndpointConfig createSourceXQEndpointConfig(XQConnectionConfig connectionConfig) throws XQEndpointCreationException, JMSException {
        String connectionName = "jms_defaultConnection";
        if (connectionConfig != null) {
            connectionName = connectionConfig.getName();
        }
        XQEndpointConfig endpointConfig = EndpointManager.getInstance().createXQEndpointConfig("D/C", "D/C", "D/C", connectionName);
        XQParametersImpl params = endpointConfig.getParameters();
        params.setIntParameter("jmsPriority", 1, -1);
        if (this.inProps.get("timeToLive") != null) {
            params.setLongParameter("timeToLive", 1, ((Long)this.inProps.get("timeToLive")).longValue());
        }
        return endpointConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint createXQEndpoint(XQEndpointConfig endpointConfig, Hashtable configMgrProps) throws WSIFException {
        try {
            this.m_runningInContainer = configMgrProps == null;
            EndpointManager endpointManager = EndpointManager.getInstance();
            XQURLAddressImpl address = new XQURLAddressImpl(this.m_locationURL, endpointConfig, this.m_factory, this.getConnectionConfig(), configMgrProps);
            Object object = m_endpointManagerLock;
            synchronized (object) {
                this.m_endpointName = address.getName();
                Endpoint result = (Endpoint)endpointManager.getEndpoint(this.m_endpointName);
                if (!this.m_runningInContainer) {
                    Integer counter = (Integer)m_endpointInstanceTracker.get(result);
                    if (counter == null) {
                        counter = new Integer(0);
                    }
                    counter = new Integer(counter + 1);
                    m_endpointInstanceTracker.put(result, counter);
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    private Endpoint getJMSReplyToEndpoint(XQAddress jmsReply) throws WSIFException {
        try {
            this.m_endpointName = jmsReply.getName();
            Endpoint xqEndpoint = (Endpoint)EndpointManager.getInvocationEndpointRegistry().getEndpoint(this.m_endpointName);
            this.setCurrentEndpoint(xqEndpoint);
            return xqEndpoint;
        }
        catch (Exception ex) {
            throw new GeneralWSInvocationException(ex.getLocalizedMessage(), null, ex);
        }
    }

    private String getLocationFromEPR(IWSEndpointReference epr) {
        if (epr != null) {
            return epr.getAddressURL();
        }
        return null;
    }

    public IWSEndpointReference getDynamicEPR() {
        EndpointReference fault;
        WSEndpointReferenceImpl epr = null;
        if (this.getUseReplyTo() || this.getESBWSType() == 1) {
            EndpointReference reply = this.getDynamicReplyTo();
            if (reply != null) {
                epr = new WSEndpointReferenceImpl(reply);
            }
        } else if (this.getESBWSType() == 2 && (fault = this.getDynamicFaultTo()) != null) {
            epr = new WSEndpointReferenceImpl(fault);
        }
        return epr;
    }

    public Endpoint getEndpoint() throws WSIFException {
        IWSEndpointReference dynamicEPR = this.getDynamicEPR();
        String dynamicLocationURL = this.getLocationFromEPR(dynamicEPR);
        if (dynamicLocationURL != null && !AddressingUtils.isAnonymousURI(dynamicLocationURL)) {
            this.setLocationURL(dynamicLocationURL, dynamicEPR);
        } else if (this.getUseReplyTo() || this.getESBWSType() == 1 || this.getESBWSType() == 2) {
            XQAddress jmsReplyTo = this.getJMSReplyTo();
            if (jmsReplyTo == null) {
                throw new WSIFException("Unable to send a response. No JMSReplyTo set on inbound message.");
            }
            this.setLocationURL(this.m_locationURL, dynamicEPR);
            return this.getJMSReplyToEndpoint(jmsReplyTo);
        }
        Hashtable configManagerProps = (Hashtable)this.inProps.get("ConfigManagerProps");
        Endpoint xqEndpoint = this.getEndpointInternal(configManagerProps);
        this.setCurrentEndpoint(xqEndpoint);
        return xqEndpoint;
    }

    private void setLocationURL(String location, IWSEndpointReference epr) {
        log.logDebug("BaseEsbWsifJmsDestination: setting m_locationURL=" + location);
        this.m_locationURL = location;
        try {
            if (epr == null) {
                epr = new WSEndpointReferenceImpl(location);
            }
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
        }
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("BaseEsbWsifJmsDestination: setting EPR=" + epr.toString());
        }
        this.inProps.put("DESTINATION_EPR", epr);
    }

    public String getLocationURL() {
        return this.m_locationURL;
    }

    public Endpoint getEndpointInternal(Hashtable configMgrProps) throws WSIFException {
        Endpoint xqEndpoint = null;
        XQConnectionConfig connectionConfig = this.getConnectionConfig();
        try {
            xqEndpoint = this.createXQEndpoint(connectionConfig, configMgrProps);
        }
        catch (GeneralWSInvocationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
        }
        return xqEndpoint;
    }

    public XQMessage setJMSProperties(XQMessage message) throws WSIFException {
        if (this.inProps.isEmpty()) {
            return message;
        }
        Iterator it = this.inProps.keySet().iterator();
        while (it.hasNext()) {
            try {
                String prop = (String)it.next();
                if (IGNORED_PROPERTIES.contains(prop)) continue;
                Object value = this.inProps.get(prop);
                Class<?> type = value.getClass();
                if (BaseEsbWsifJmsProperties.predefinedProps.contains(prop)) {
                    try {
                        if (prop.equals("JMSCorrelationID")) {
                            message.setHeaderValue("JMSCorrelationID", (Object)((String)value));
                            continue;
                        }
                        if (prop.equals("Destination")) {
                            message.setHeaderValue("JMSDestination", (Object)((Destination)value));
                            continue;
                        }
                        if (prop.equals("JMSDeliveryMode")) {
                            message.setHeaderValue("JMSDeliveryMode", (Object)((Integer)value));
                            continue;
                        }
                        if (prop.equals("JMSExpiration")) {
                            message.setHeaderValue("JMSExpiration", (Object)((Long)value));
                            continue;
                        }
                        if (prop.equals("JMSPriority")) {
                            message.setHeaderValue("JMSPriority", (Object)((Integer)value));
                            continue;
                        }
                        if (prop.equals("JMSRedelivered")) {
                            message.setHeaderValue("JMSRedelivered", (Object)((Boolean)value));
                            continue;
                        }
                        if (prop.equals("JMSReplyTo")) {
                            message.setHeaderValue("JMSReplyTo", (Object)((Destination)value));
                            continue;
                        }
                        if (prop.equals("JMSTimestamp")) {
                            message.setHeaderValue("JMSTimestamp", (Object)((Long)value));
                            continue;
                        }
                        if (!prop.equals("JMSType")) continue;
                        message.setHeaderValue("JMSType", (Object)((String)value));
                        continue;
                    }
                    catch (ClassCastException ce) {
                        throw new GeneralWSInvocationException("unexpected-jms-type", new Object[]{type, prop});
                    }
                    catch (XQMessageException ex) {
                        throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
                    }
                }
                this.setUserDefinedProperty(type, message, prop, value);
            }
            catch (XQMessageException ex) {
                throw new GeneralWSInvocationException(ex.getMessage(), null, ex);
            }
        }
        return message;
    }
}

