/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.script.Command;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.IScriptCommand;
import com.sonicsw.xqimpl.script.Namespaces;
import com.sonicsw.xqimpl.script.ParameterConstants;
import com.sonicsw.xqimpl.script.ParameterMap;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.Translation;
import com.sonicsw.xqimpl.script.Variable;
import com.sonicsw.xqimpl.script.VariableDirection;
import com.sonicsw.xqimpl.script.VariableValue;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ScriptObject {
    protected DirectoryServiceProxy m_proxy;
    protected IComponentContext m_context;
    private IScriptCommand m_command = null;
    protected Namespaces m_namespaces;
    protected Map m_variablesMap = new HashMap();
    protected ParameterMap m_parameterMap;
    protected ParameterConstants m_parameterConstants;
    protected String m_encoding = null;
    public static final String CURRENT_VERSION = "1.0";
    private static XQLog log = XQLogImpl.getCategoryLog((int)64);
    private XQParameters m_xqParams;
    private XQMessage m_message;
    private String m_scriptURL = null;

    public ScriptObject() {
    }

    public ScriptObject(Element script) throws ScriptEngineException {
        try {
            this.deserializeScript(script);
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    public void setEncoding(String encoding) {
        this.m_encoding = encoding;
    }

    public XQParameters getXQParameters() {
        return this.m_xqParams;
    }

    public XQMessage getXQMessage() {
        return this.m_message;
    }

    public IScriptCommand getScriptCommand() {
        return this.m_command;
    }

    public Namespaces getNamespaces() {
        return this.m_namespaces;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public HashMap getParameterConstants() {
        return this.m_parameterConstants.getParameterConstantsMap();
    }

    public void setParameterMap(ParameterMap paramMap) {
        this.m_parameterMap = paramMap;
    }

    public void setURL(String url) {
        this.m_scriptURL = url;
    }

    public String getURL() {
        return this.m_scriptURL;
    }

    private void deserializeScript(Element scriptElm) throws MalformedURLException, ScriptEngineException {
        String version = scriptElm.getAttribute("version");
        if ("".equals(version)) {
            version = CURRENT_VERSION;
        }
        if (!CURRENT_VERSION.equals(version)) {
            throw new ScriptEngineException("unsupported-verson", new Object[]{new Integer(version)}, 1);
        }
        this.deserializeNamespaces(scriptElm);
        Element invActionElm = DOMUtils.getImmediateChildElementByName((Element)scriptElm, (String)"invocationAction");
        if (invActionElm == null) {
            return;
        }
        this.m_parameterMap = new ParameterMap(this.m_namespaces, this);
        this.deserializeVariables(invActionElm);
        this.deserializeParameterMappings(invActionElm);
        Element scriptCommandEl = DOMUtils.getImmediateChildElementByName((Element)scriptElm, (String)"scriptCommand");
        this.m_command = this.createScriptCommand(scriptCommandEl);
        List parameter = this.m_command.getParameters();
        this.deserializeParameterConstants(scriptElm);
    }

    private void deserializeParameterConstants(Element scriptElm) throws ScriptEngineException {
        this.m_parameterConstants = new ParameterConstants(scriptElm);
    }

    private void deserializeParameterMappings(Element invocationActionElm) throws ScriptEngineException {
        Element tempEl = DOMUtils.getImmediateChildElementByName((Element)invocationActionElm, (String)"parametermap");
        if (tempEl == null) {
            return;
        }
        NodeList tempNl = tempEl.getChildNodes();
        for (int i = 0; i < tempNl.getLength(); ++i) {
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !"parameter".equals(n.getLocalName())) continue;
            Element e = (Element)n;
            String parameterName = e.getAttribute("parameterName");
            if (parameterName == null) {
                throw new ScriptEngineException("parametermap-param-name-not-found", new Object[]{"parameterName"}, 1);
            }
            Element value = DOMUtils.getImmediateChildElementByName((Element)e, (String)"value");
            if (value == null) {
                Element variableNameElement = DOMUtils.getImmediateChildElementByName((Element)e, (String)"variablename");
                if (variableNameElement != null) {
                    Text variableNameValue = DOMUtils.getFirstTextChild((Element)variableNameElement);
                    if (variableNameValue == null) {
                        throw new ScriptEngineException("parametermap-variable-name-value-not-found", new Object[]{parameterName}, 1);
                    }
                    String variableName = variableNameValue.getData().trim();
                    Variable v = (Variable)this.m_variablesMap.get(variableName);
                    if (v == null) {
                        throw new ScriptEngineException("variable-undefined", new Object[]{variableName}, 1);
                    }
                    Element translationType = DOMUtils.getImmediateChildElementByName((Element)e, (String)"translationtype");
                    if (translationType != null) {
                        TranslationInfo info = this.getTranslationInfo(translationType);
                        this.m_parameterMap.add(parameterName, v.getDirection(), variableName, info.translationType, info.translationString);
                        continue;
                    }
                    this.m_parameterMap.add(parameterName, v.getDirection(), variableName, Translation.NONE, null);
                    continue;
                }
                throw new ScriptEngineException("variable-name-not-found-for-parameter", new Object[]{parameterName}, 1);
            }
            Text valueStringValue = DOMUtils.getFirstTextChild((Element)value);
            if (valueStringValue == null) {
                throw new ScriptEngineException("parametermap-constant-value-not-found", new Object[]{parameterName}, 1);
            }
            String valueString = DOMUtils.getFirstTextChild((Element)value).getData();
            this.m_parameterMap.add(parameterName, VariableDirection.IN, valueString);
        }
    }

    private TranslationInfo getTranslationInfo(Element e) {
        Element xpath = DOMUtils.getImmediateChildElementByName((Element)e, (String)"xpath");
        if (xpath != null) {
            String xpathString = DOMUtils.getFirstTextValueOfImmediateChild((Element)xpath, (String)"xpathExpression");
            if (xpathString != null) {
                xpathString = xpathString.trim();
            }
            TranslationInfo result = new TranslationInfo();
            result.translationString = xpathString;
            result.translationType = Translation.XPATH;
            return result;
        }
        Element xslt = DOMUtils.getImmediateChildElementByName((Element)e, (String)"xslt");
        if (xslt != null) {
            String xsltStringURL = DOMUtils.getFirstTextValueOfImmediateChild((Element)xslt, (String)"stylesheetURL");
            if (xsltStringURL != null) {
                xsltStringURL = xsltStringURL.trim();
            }
            TranslationInfo result = new TranslationInfo();
            result.translationString = xsltStringURL;
            result.translationType = Translation.XSLT;
            return result;
        }
        TranslationInfo result = new TranslationInfo();
        result.translationType = Translation.NONE;
        return result;
    }

    private void deserializeNamespaces(Element scriptElm) throws MalformedURLException {
        Element tempEl = DOMUtils.getImmediateChildElementByName((Element)scriptElm, (String)"nameSpaces");
        if (tempEl == null) {
            return;
        }
        this.m_namespaces = new Namespaces(tempEl);
    }

    private void deserializeVariables(Element invocationActionElm) throws MalformedURLException, ScriptEngineException {
        Element tempEl = DOMUtils.getImmediateChildElementByName((Element)invocationActionElm, (String)"variables");
        if (tempEl == null) {
            return;
        }
        NodeList tempNl = tempEl.getChildNodes();
        for (int i = 0; i < tempNl.getLength(); ++i) {
            Node n = tempNl.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            Variable var = new Variable();
            if ("document".equals(n.getLocalName())) {
                var.setDocument(true);
            } else {
                var.setDocument(false);
            }
            String name = e.getAttribute("name");
            if (name == null) {
                throw new ScriptEngineException("variable-name-undefined", 1);
            }
            var.setName(name);
            var.setType(e.getAttribute("type"));
            var.setDirection(VariableDirection.valueOf(e.getAttribute("direction")));
            this.m_variablesMap.put(name, var);
        }
    }

    public IParameterValue getParameterValue(String parameterName, String parameterType, Command command) throws ScriptEngineException, XQMessageException {
        return this.m_parameterMap.getParameterValue(parameterName, parameterType, VariableDirection.IN, command);
    }

    public boolean hasInputParameterMapping(String parameterName) {
        return this.m_parameterMap.hasParameterMapping(parameterName, VariableDirection.IN);
    }

    public boolean hasOutputParameterMapping(String parameterName) {
        return this.m_parameterMap.hasParameterMapping(parameterName, VariableDirection.OUT);
    }

    public VariableValue getVariableValue(IParameterValue value) throws ScriptEngineException {
        return this.m_parameterMap.getVariableValue(value);
    }

    Map getVariableMap() {
        return this.m_variablesMap;
    }

    public abstract IScriptCommand createScriptCommand(Element var1) throws ScriptEngineException;

    public abstract String getScriptType();

    public void initRuntimeContext(XQParameters params, XQMessage message) {
        this.m_xqParams = params;
        this.m_message = message;
    }

    private final class TranslationInfo {
        Translation translationType;
        String translationString;

        private TranslationInfo() {
        }
    }
}

