/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSFaultInfo;
import com.sonicsw.esb.ws.invocation.ESBWSOperation;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.wsdl.AbstractOperation;
import com.sonicsw.xqimpl.script.wsdl.Policy;
import com.sonicsw.xqimpl.script.wsdl.PortInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLFaultInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLParameterInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLScriptCommand;
import com.sonicsw.xqimpl.script.wsdl.WSDLServiceHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLUtils;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;

class WSDLOperation
extends AbstractOperation
implements ESBWSOperation {
    private WSDLServiceHelper m_svcHelper = null;
    private PortInfo m_portInfo = null;
    private ArrayList m_faultList = null;
    private Policy m_inputPolicy = null;
    private Policy m_outputPolicy = null;
    private Policy m_faultPolicy = null;

    WSDLOperation(WSDLServiceHelper helper, PortInfo portInfo, Operation op) throws WSDLHelperException {
        this.m_operation = op;
        this.m_portInfo = portInfo;
        this.m_svcHelper = helper;
        this.m_faultList = this.initializeFaultList();
    }

    @Override
    public String getName() {
        return this.m_operation.getName();
    }

    private void initializeCommon(WSDLScriptCommand cmd) throws WSDLHelperException {
        cmd.setWSDLLocation(this.m_svcHelper.getLocation());
        cmd.setServiceName(this.m_svcHelper.getServiceName());
        cmd.setOperationName(this.m_operation.getName());
        cmd.setPortName(this.m_portInfo.getPortName());
        cmd.setBindingName(this.m_portInfo.getBindingName());
        cmd.setPortType(this.m_portInfo.getPortTypeName());
        cmd.setTargetNamespace(this.m_svcHelper.getWSDLHelper().getDefinition().getTargetNamespace());
        cmd.setSOAPInfo(this.m_portInfo.getSOAPInfo(this.m_operation));
        cmd.setIsSOAPBinding(this.m_portInfo.isSOAPBinding());
        cmd.setEndpointReference(this.m_portInfo.getEndpointReference());
    }

    protected String extractWSAActionExtension(WSDLScriptCommand cmd) {
        Object o;
        QName qname;
        Input ae = null;
        Input in = this.m_operation.getInput();
        Output out = this.m_operation.getOutput();
        if (cmd.getCommandType() == 0) {
            ae = in;
        } else if (cmd.getCommandType() == 1) {
            ae = out;
        } else if (cmd.getCommandType() == 2) {
            Fault flt = this.m_operation.getFault(cmd.getOperationMessageName());
            ae = flt;
        }
        if (ae == null) {
            return null;
        }
        Iterator iter = AddressingUtils.getAddressingURIs();
        while (iter.hasNext()) {
            qname = new QName((String)iter.next(), "Action");
            o = ae.getExtensionAttribute(qname);
            if (o != null && o instanceof String) {
                return (String)o;
            }
            if (o == null || !(o instanceof QName)) continue;
            return ((QName)o).getLocalPart();
        }
        iter = AddressingUtils.getAddressingBindingURIs();
        while (iter.hasNext()) {
            qname = new QName((String)iter.next(), "Action");
            o = ae.getExtensionAttribute(qname);
            if (o != null && o instanceof String) {
                return (String)o;
            }
            if (o == null || !(o instanceof QName)) continue;
            return ((QName)o).getLocalPart();
        }
        return null;
    }

    @Override
    public ESBWSCommand getInvocationCommand() throws ESBWSException {
        WSDLScriptCommand cmd = new WSDLScriptCommand(0);
        this.initializeCommon(cmd);
        cmd.setParameterList(this.getInvocationParameters(false));
        cmd.setRequestResponse(this.isRequestResponse());
        cmd.setEffectivePolicy(this.getEffectivePolicy());
        cmd.setResponsePolicy(this.getEffectiveResponsePolicy());
        cmd.setFaultPolicy(this.getEffectiveFaultPolicy(null));
        if (this.m_operation.getInput() != null) {
            cmd.setOperationMessageName(this.m_operation.getInput().getName());
        }
        cmd.setFaultList(this.m_faultList);
        String wsaAction = this.extractWSAActionExtension(cmd);
        cmd.setWSAAction(wsaAction);
        return cmd;
    }

    @Override
    public ESBWSCommand getResponseCommand() throws ESBWSException {
        WSDLScriptCommand cmd = new WSDLScriptCommand(1);
        this.initializeCommon(cmd);
        if ("rpc".equals(cmd.getOperationStyle())) {
            cmd.setOperationName(cmd.getOperationName());
        }
        List outParams = this.getOutputParameters(this.m_operation.getOutput(), ParameterDirection.IN);
        cmd.setParameterList(outParams);
        cmd.setRequestResponse(false);
        cmd.setResponsePolicy(this.extractEffectiveResponsePolicy());
        cmd.setOperationMessageName(this.m_operation.getOutput().getName());
        if (this.m_portInfo.isSOAPBinding()) {
            BindingOutput outOp;
            outParams.add(new WSDLParameterInfo("RawSoap", "soap", "http://schemas.xmlsoap.org/wsdl/", "Envelope", "xsd:anyType", ParameterDirection.OUT));
            BindingOperation op = this.getBindingOperation();
            if (op != null && (outOp = op.getBindingOutput()) != null) {
                List extElems = outOp.getExtensibilityElements();
                this.getSOAPHeaders(outParams, extElems, ParameterDirection.IN);
            }
        }
        cmd.setSOAPEndpointURL("http://www.sonicsw.com/esb/replyto-destination-required");
        String wsaAction = this.extractWSAActionExtension(cmd);
        cmd.setWSAAction(wsaAction);
        return cmd;
    }

    private BindingOperation getBindingOperation() {
        List bindingOps = this.m_portInfo.getBindingOperations();
        Iterator iter = bindingOps.iterator();
        BindingOperation op = null;
        while (iter.hasNext()) {
            BindingOperation opTemp = (BindingOperation)iter.next();
            if (opTemp.getOperation() != this.m_operation) continue;
            op = opTemp;
        }
        return op;
    }

    @Override
    public ESBWSCommand getFaultCommand(ESBWSFaultInfo fault) throws ESBWSException {
        WSDLScriptCommand cmd = new WSDLScriptCommand(2);
        this.initializeCommon(cmd);
        WSDLFaultInfo f = (WSDLFaultInfo)this.m_faultList.get(this.m_faultList.indexOf(fault));
        List outParams = this.getFaultParameters(f.getFaultMessage());
        cmd.setParameterList(outParams);
        cmd.setRequestResponse(false);
        cmd.setFaultPolicy(this.extractEffectiveFaultPolicy(null));
        cmd.setOperationMessageName(f.getName());
        if (this.m_portInfo.isSOAPBinding()) {
            outParams.add(new WSDLParameterInfo("RawSoap", "soap", "http://schemas.xmlsoap.org/wsdl/", "Envelope", "xsd:anyType", ParameterDirection.OUT));
            cmd.setSOAPEndpointURL("http://www.sonicsw.com/esb/replyto-destination-required");
        }
        String wsaAction = this.extractWSAActionExtension(cmd);
        cmd.setWSAAction(wsaAction);
        return cmd;
    }

    @Override
    public ESBWSCommand getUnwrapCommand() throws ESBWSException {
        WSDLScriptCommand cmd = new WSDLScriptCommand(3);
        this.initializeCommon(cmd);
        cmd.setOperationName(cmd.getOperationName());
        cmd.setRequestResponse(true);
        ArrayList params = this.getInvocationParameters(true);
        WSDLParameterInfo p = new WSDLParameterInfo("SOAPEnvelope", "soapenv", "http://schemas.xmlsoap.org/soap/envelope/", "envelope", "xsd:anyType", ParameterDirection.IN);
        params.add(p);
        cmd.setParameterList(params);
        return cmd;
    }

    public String toScriptCommand() throws ESBWSException {
        return this.getInvocationCommand().serialize();
    }

    @Override
    public List getFaults() {
        return this.m_faultList;
    }

    @Override
    protected ArrayList getInvocationParameters(boolean bUnwrap) throws ESBWSException {
        ArrayList<WSDLParameterInfo> paramList = new ArrayList<WSDLParameterInfo>();
        BindingOperation op = this.getBindingOperation();
        ArrayList invocationParameters = this._getInvocationParameters(bUnwrap, op);
        paramList.addAll(invocationParameters);
        if (!this.m_portInfo.isSOAPBinding()) {
            return paramList;
        }
        if (op == null) {
            return paramList;
        }
        BindingInput inOp = op.getBindingInput();
        List extElems = inOp.getExtensibilityElements();
        this.getSOAPHeaders(paramList, extElems, bUnwrap ? ParameterDirection.OUT : ParameterDirection.IN);
        BindingOutput outOp = op.getBindingOutput();
        if (!bUnwrap && outOp != null) {
            extElems = outOp.getExtensibilityElements();
            this.getSOAPHeaders(paramList, extElems, ParameterDirection.OUT);
        }
        if (!this.m_bOneWay) {
            paramList.add(new WSDLParameterInfo("RawSoapResponse", "soap", "http://schemas.xmlsoap.org/wsdl/", "Envelope", "xsd:anyType", ParameterDirection.OUT));
        }
        if (!bUnwrap) {
            paramList.add(new WSDLParameterInfo("RawSoapRequest", "soap", "http://schemas.xmlsoap.org/wsdl/", "Envelope", "xsd:anyType", ParameterDirection.OUT));
        }
        return paramList;
    }

    protected ArrayList _getInvocationParameters(boolean bUnwrap, BindingOperation bindingOp) throws ESBWSException {
        List outputParams;
        Message msg;
        List extElems;
        BindingInput inOp;
        Message msg2;
        ArrayList<WSDLParameterInfo> paramList = new ArrayList<WSDLParameterInfo>();
        Input in = this.m_operation.getInput();
        List paramOrder = this.m_operation.getParameterOrdering();
        if (paramOrder != null && paramOrder.size() == 0) {
            paramOrder = null;
        }
        ArrayList<Part> inParts = new ArrayList<Part>();
        List orderedParts = null;
        Collection inAllParts = null;
        if (in != null && (msg2 = in.getMessage()) != null) {
            Map parts = msg2.getParts();
            if (parts != null) {
                inAllParts = parts.values();
            }
            orderedParts = msg2.getOrderedParts(paramOrder);
        }
        SOAPBody bd = null;
        if (bindingOp != null && (inOp = bindingOp.getBindingInput()) != null && (extElems = inOp.getExtensibilityElements()) != null) {
            for (ExtensibilityElement o : extElems) {
                if (!(o instanceof SOAPBody)) continue;
                bd = (SOAPBody)o;
            }
        }
        if (orderedParts != null) {
            for (Part p : orderedParts) {
                if (!this.checkIfSoapBodyContainsPart(p, bd)) continue;
                inParts.add(p);
            }
        }
        if (inAllParts != null && inAllParts.size() > inParts.size()) {
            for (Part part : inAllParts) {
                if (inParts.contains(part) || !this.checkIfSoapBodyContainsPart(part, bd)) continue;
                inParts.add(part);
            }
        }
        Output out = this.m_operation.getOutput();
        Map outParams = null;
        HashMap outParamsTmp = null;
        if (out != null && (msg = out.getMessage()) != null) {
            outParams = msg.getParts();
            outParamsTmp = new HashMap(outParams);
        }
        if (inParts != null) {
            for (Part inPart : inParts) {
                Part inOutPart;
                ParameterDirection direction = ParameterDirection.IN;
                if (outParamsTmp != null && (inOutPart = this.findMatchingParam(inPart, outParamsTmp)) != null) {
                    direction = bUnwrap ? ParameterDirection.IN : ParameterDirection.INOUT;
                    this.m_bOneWay = false;
                    outParamsTmp.remove(inOutPart.getName());
                }
                WSDLParameterInfo p = this.getParameterInfo(inPart, bUnwrap ? ParameterDirection.OUT : direction, false);
                paramList.add(p);
            }
        }
        if (!bUnwrap && (outputParams = this.getMessageParameters(outParamsTmp, ParameterDirection.OUT)).size() > 0) {
            this.m_bOneWay = false;
            paramList.addAll(outputParams);
        }
        return paramList;
    }

    private boolean checkIfSoapBodyContainsPart(Part part, SOAPBody bd) {
        if (bd == null) {
            return true;
        }
        List partsList = bd.getParts();
        if (partsList == null || partsList.size() == 0) {
            return true;
        }
        for (String partName : partsList) {
            if (!part.getName().equals(partName)) continue;
            return true;
        }
        return false;
    }

    private ParameterDirection invert(ParameterDirection p) {
        if (p.equals(ParameterDirection.IN)) {
            return ParameterDirection.OUT;
        }
        if (p.equals(ParameterDirection.OUT)) {
            return ParameterDirection.IN;
        }
        return p;
    }

    private List getOutputParameters(Output out, ParameterDirection direction) throws ESBWSException {
        if (out == null) {
            throw new WSDLHelperException("no-output-specified", null);
        }
        Message msg = out.getMessage();
        if (msg == null) {
            throw new WSDLHelperException("no-output-message-specified", null);
        }
        List outParams = this.getMessageParameters(msg.getParts(), direction);
        return outParams;
    }

    private List getFaultParameters(Message faultMessage) throws ESBWSException {
        if (faultMessage == null) {
            throw new WSDLHelperException("no-fault-message-specified", null);
        }
        List outParams = this.getMessageParameters(faultMessage.getParts(), ParameterDirection.IN);
        outParams.add(new WSDLParameterInfo("faultcode", null, null, "xsd:string", "xsd:string", ParameterDirection.IN));
        outParams.add(new WSDLParameterInfo("faultstring", null, null, "xsd:string", "xsd:string", ParameterDirection.IN));
        outParams.add(new WSDLParameterInfo("faultactor", null, null, "xsd:string", "xsd:string", ParameterDirection.IN));
        return outParams;
    }

    private ArrayList initializeFaultList() throws WSDLHelperException {
        ArrayList<WSDLFaultInfo> faultList = new ArrayList<WSDLFaultInfo>();
        Map faults = this.m_operation.getFaults();
        if (!faults.isEmpty()) {
            for (String faultName : faults.keySet()) {
                Message faultMessage = ((Fault)faults.get(faultName)).getMessage();
                WSDLFaultInfo f = new WSDLFaultInfo(this.m_svcHelper, faultName, faultMessage);
                faultList.add(f);
            }
        }
        return faultList;
    }

    @Override
    public boolean isElement(String partName, String direction) throws WSDLHelperException {
        Message m = null;
        if ("IN".equalsIgnoreCase(direction)) {
            Input in = this.m_operation.getInput();
            if (in == null) {
                throw new WSDLHelperException("no-input-message", new Object[]{partName, direction});
            }
            m = in.getMessage();
        } else if ("OUT".equalsIgnoreCase(direction)) {
            Output out = this.m_operation.getOutput();
            if (out == null) {
                throw new WSDLHelperException("no-output-message", new Object[]{partName, direction});
            }
            m = out.getMessage();
        }
        Part p = null;
        if (m != null && (p = m.getPart(partName)) == null) {
            return false;
        }
        return WSDLUtils.isElement(p);
    }

    private void getSOAPHeaders(List paramList, List elems, ParameterDirection direction) throws WSDLHelperException {
        for (ExtensibilityElement elem : elems) {
            if (!(elem instanceof SOAPHeader)) continue;
            QName msgName = ((SOAPHeader)elem).getMessage();
            String partName = ((SOAPHeader)elem).getPart();
            Message msg = this.m_svcHelper.getWSDLHelper().getDefinition().getMessage(msgName);
            if (msg == null) {
                throw new WSDLHelperException("no-message-element", new Object[]{msgName.toString()});
            }
            Part part = msg.getPart(partName);
            if (part == null) {
                throw new WSDLHelperException("no-part", new Object[]{partName, msgName.toString()});
            }
            WSDLParameterInfo p = this.getParameterInfo(part, direction, true);
            paramList.add(p);
        }
    }

    @Override
    protected WSDLParameterInfo getParameterInfo(Part part, ParameterDirection direction, boolean isSoapHeader) throws WSDLHelperException {
        QName typeName = WSDLUtils.getPartTypeName(part);
        WSDLParameterInfo p = new WSDLParameterInfo(this.m_svcHelper.getPartBaseType(part), this.m_svcHelper.getWSDLHelper().getDefinition().getPrefix(typeName.getNamespaceURI()), part, direction);
        p.setIsSoapHeader(isSoapHeader);
        if (this.m_portInfo.isSOAPBinding()) {
            p.setSOAPProperties(this.m_portInfo, this.m_operation, part);
        }
        return p;
    }

    @Override
    public String getEffectivePolicy() throws ESBWSException {
        if (this.m_inputPolicy == null) {
            List policies = this.getServicePolicies(this.m_svcHelper.getService());
            policies.addAll(this.m_portInfo.getNormalizedPolicies(this.m_operation, 0));
            this.m_inputPolicy = Policy.computeEffectivePolicy(policies);
        }
        return this.m_inputPolicy.serialize();
    }

    public String getEffectiveResponsePolicy() throws ESBWSException {
        if (this.m_bOneWay) {
            return null;
        }
        return this.extractEffectiveResponsePolicy();
    }

    private String extractEffectiveResponsePolicy() throws ESBWSException {
        if (this.m_outputPolicy == null) {
            List policies = this.getServicePolicies(this.m_svcHelper.getService());
            policies.addAll(this.m_portInfo.getNormalizedPolicies(this.m_operation, 1));
            this.m_outputPolicy = Policy.computeEffectivePolicy(policies);
        }
        return this.m_outputPolicy.serialize();
    }

    public String getEffectiveFaultPolicy(ESBWSFaultInfo fault) throws ESBWSException {
        if (this.m_bOneWay) {
            return null;
        }
        return this.extractEffectiveFaultPolicy(fault);
    }

    private String extractEffectiveFaultPolicy(ESBWSFaultInfo fault) throws ESBWSException {
        if (this.m_faultPolicy == null) {
            List policies = this.getServicePolicies(this.m_svcHelper.getService());
            policies.addAll(this.m_portInfo.getNormalizedPolicies(this.m_operation, fault));
            this.m_faultPolicy = Policy.computeEffectivePolicy(policies);
        }
        return this.m_faultPolicy.serialize();
    }

    private List getServicePolicies(Service service) throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        if (service != null) {
            policies.addAll(Policy.getPolicyElements(this.m_svcHelper, service.getExtensibilityElements()));
            policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, service.getExtensionAttributes()));
        }
        return policies;
    }
}

