/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEndpointNotFoundException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQState;
import com.sonicsw.xqimpl.config.IEndpointConfigImpl;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfigAdapter;
import com.sonicsw.xqimpl.config.XQJMSEndpointConfigAdapter;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.service.XQDispatcher;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQRegistry;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.util.HashMap;
import java.util.Map;

public class XQEndpointManagerImpl
implements XQEndpointManager {
    private String m_serviceInstanceName = null;
    private String m_entryEndpointName = null;
    private Map<String, XQEndpoint> m_managedTransients = new HashMap<String, XQEndpoint>();

    public XQEndpointManagerImpl(String serviceInstanceName, String entryEndpointName) {
        this.m_serviceInstanceName = serviceInstanceName;
        this.m_entryEndpointName = entryEndpointName;
    }

    public XQEndpoint getEndpoint(String name) throws XQEndpointCreationException {
        XQEndpoint ep = this.getTransientEndpoint(name);
        return ep != null ? ep : EndpointManager.getInstance().getEndpoint(name);
    }

    public boolean isEndpointDefined(String name) {
        XQEndpoint ep = this.getTransientEndpoint(name);
        if (ep != null) {
            return true;
        }
        return EndpointManager.getInstance().isEndpointDefined(name);
    }

    public boolean isEndpointTransient(String name) {
        XQEndpoint ep = this.getTransientEndpoint(name);
        return ep != null;
    }

    public boolean isEndpointConfigured(String name) {
        try {
            XQConfigManager cmgr = XQConfigManager.getInstance(null);
            cmgr.lookupEndpointConfig(name);
            return true;
        }
        catch (XQConfigurationException ne) {
            return false;
        }
    }

    public void removeEndpoint(String name) throws XQEndpointNotFoundException {
        XQEndpoint ep = this.getTransientEndpoint(name);
        if (ep != null) {
            this.removeTransientEndpoint(name);
        } else {
            EndpointManager.getInstance().removeEndpoint(name);
        }
    }

    public IEndpointConfig cloneEndpointConfig(String existingEndpointName, String newEndpointName) throws XQEndpointNotFoundException {
        XQEndpointConfig originalConfig = this.getEndpointConfig(existingEndpointName);
        XQEndpointConfig newConfig = (XQEndpointConfig)originalConfig.clone();
        newConfig.setName(newEndpointName);
        if (newConfig.getType().equalsIgnoreCase("JMSType")) {
            return new XQJMSEndpointConfigAdapter((IEndpointConfigImpl)newConfig);
        }
        return newConfig;
    }

    public IEndpointConfig cloneEntryEndpointConfig(String newEndpointName) throws XQEndpointNotFoundException {
        XQEndpointConfig originalConfig = this.getEntryEndpointConfig();
        XQEndpointConfig newConfig = (XQEndpointConfig)originalConfig.clone();
        newConfig.setName(newEndpointName);
        return newConfig;
    }

    public XQEndpoint createTransientEndpoint(IEndpointConfig config) throws XQEndpointCreationException {
        if (this.isEndpointConfigured(config.getName()) || this.isEndpointTransient(config.getName())) {
            throw new XQEndpointCreationException("Endpoint already exists: " + config.getName());
        }
        XQParametersImpl parms = null;
        IEndpointConfigImpl endpointConfigImpl = null;
        Endpoint ep = null;
        if (config instanceof IEndpointConfigImpl) {
            endpointConfigImpl = (IEndpointConfigImpl)config;
        } else if (config instanceof XQEndpointConfigAdapter) {
            endpointConfigImpl = (IEndpointConfigImpl)((XQEndpointConfigAdapter)config).getDelegate();
        }
        if (endpointConfigImpl != null) {
            parms = endpointConfigImpl.getParameters();
        }
        if (parms != null) {
            parms.setParameter("TransientEndpointServiceName", 1, this.m_serviceInstanceName);
            boolean isTemp = false;
            String isTempDestination = parms.getParameter("TemporaryEndpoint", 1, "false");
            try {
                isTemp = new Boolean(isTempDestination);
            }
            catch (Exception e) {
                // empty catch block
            }
            ep = EndpointManager.getInstance().createUnregisteredEndpoint((XQEndpointConfig)config, isTemp, null, null);
            this.m_managedTransients.put(config.getName(), ep);
        }
        return ep;
    }

    private void removeTransientEndpoint(String name) {
        XQEndpoint ep = this.m_managedTransients.get(name);
        if (ep != null) {
            try {
                this.unregisterAsEntryEndpoint(ep);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_managedTransients.remove(name);
        }
    }

    public XQEndpoint getTransientEndpoint(String name) {
        XQEndpoint ep = this.m_managedTransients.get(name);
        if (ep != null) {
            return ep;
        }
        return null;
    }

    public void registerAsEntryEndpoint(XQEndpoint endpoint, int numListeners) throws XQEndpointException {
        try {
            if (numListeners <= 0) {
                throw new XQEndpointException("Number of listeners invalid. ");
            }
            String contextName = this.m_serviceInstanceName;
            if (this.isEndpointTransient(endpoint.getName())) {
                contextName = "DYNAMIC_" + contextName + "_" + endpoint.getName();
            } else if (!endpoint.getName().equals(this.m_entryEndpointName)) {
                throw new XQEndpointException("Cannot register `" + endpoint.getName() + "` as an entry endpoint " + "as it is not a configured entry endpoint for this service");
            }
            XQDispatcher xqDispatcher = XQRegistry.instance().lookupService(this.m_serviceInstanceName);
            xqDispatcher.addEndpointContextContainers(contextName, (Endpoint)endpoint, numListeners);
            if (xqDispatcher.getLifeCycleManager().getCurrentServiceState() != XQState.STARTED) {
                return;
            }
            xqDispatcher.startEndpointContextContainers(contextName, endpoint.getName());
        }
        catch (XQEndpointException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new XQEndpointException(t);
        }
    }

    public void unregisterAsEntryEndpoint(XQEndpoint endpoint) throws XQEndpointException {
        try {
            String contextName = this.m_serviceInstanceName;
            if (this.isEndpointTransient(endpoint.getName())) {
                contextName = "DYNAMIC_" + contextName + "_" + endpoint.getName();
            } else if (!endpoint.getName().equals(this.m_entryEndpointName)) {
                throw new XQEndpointException("Cannot unregister `" + endpoint.getName() + "` as an entry endpoint " + "as it is not a configured entry endpoint for this service");
            }
            XQDispatcher xqDispatcher = XQRegistry.instance().lookupService(this.m_serviceInstanceName);
            xqDispatcher.stopEndpointContextContainers(contextName, endpoint.getName(), true);
            xqDispatcher.destroyEndpointContextContainers(contextName, endpoint.getName());
        }
        catch (Throwable t) {
            throw new XQEndpointException(t);
        }
    }

    public String getEntryEndpoint(XQMessage msg) {
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        String entryPoint = (String)internalMsg.getSidebandProperty("SonicESB.CurrentEntryEndpoint");
        return entryPoint;
    }

    private XQEndpointConfig getEndpointConfig(String name) throws XQEndpointNotFoundException {
        try {
            XQConfigManager cmgr = XQConfigManager.getInstance(null);
            return cmgr.lookupEndpointConfig(name);
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointNotFoundException((Throwable)ne);
        }
    }

    private XQEndpointConfig getEntryEndpointConfig() throws XQEndpointNotFoundException {
        if (this.m_entryEndpointName == null) {
            return null;
        }
        return this.getEndpointConfig(this.m_entryEndpointName);
    }

    public void releaseTransientEndpoints() {
        if (this.m_managedTransients != null) {
            this.m_managedTransients.clear();
        }
    }
}

