/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.interceptor.XQInterceptorServiceContext;
import com.sonicsw.esb.itinerary.continuation.ItineraryContinuationHelper;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQInvocationContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQMitigationContext;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.common.MitigationContextFactory;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.service.BoxListIterator;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jms.Connection;
import javax.jms.Session;

public class XQServiceContextImpl
implements XQInterceptorServiceContext {
    private XQEnvelopeFactory m_envelopeFactory;
    private XQEndpointManager m_epManager;
    private XQDispatch m_dispatcher;
    private List<XQEnvelope> m_inbox;
    private List<XQEnvelope> m_outbox;
    private List<XQEnvelope> m_faultbox;
    private XQParameters m_params;
    private Iterator<XQEnvelope> m_incoming;
    private int m_currentListener;
    private XQAccessorFactory m_accessorFactory;
    private XQMessageFactory m_messageFactory;
    private XQAddressFactory m_addressFactory;
    private String m_entryEndpoint;
    private XQAddress m_rmeAddress;
    private XQQualityofService m_qos;
    private XQProcessContext m_processContext;
    private MitigationContextFactory m_mitigationContextFactory;
    private XQLifeCycleManager m_lifeCycle;
    private XQInvocationContext m_invocationContext;
    private ESBInteractorFactory m_interactorFactory;

    XQServiceContextImpl(XQEndpointManager epManager, XQEnvelopeFactory envelopeFactory, XQAccessorFactory accessorFactory, XQMessageFactory messageFactory, XQAddressFactory addressFactory, XQParameters params, int currentListener, XQDispatch dispatcher, XQLifeCycleManager lifeCycle, ESBInteractorFactory interactorFactory) {
        if (epManager == null || envelopeFactory == null || accessorFactory == null || messageFactory == null) {
            throw new IllegalArgumentException("EndpointManager, AccessorFactory, MessageFactory, and EnvelopeFactory cannot be null");
        }
        this.m_epManager = epManager;
        this.m_envelopeFactory = envelopeFactory;
        this.m_accessorFactory = accessorFactory;
        this.m_messageFactory = messageFactory;
        this.m_addressFactory = addressFactory;
        this.m_currentListener = currentListener;
        this.m_dispatcher = dispatcher;
        this.m_lifeCycle = lifeCycle;
        this.m_interactorFactory = interactorFactory;
        this.m_inbox = new ArrayList<XQEnvelope>();
        this.m_params = params;
        this.resetIncoming();
    }

    public static XQServiceContextImpl createServiceContextImpl(XQEndpointManager epManager, XQEnvelopeFactory envelopeFactory, XQAccessorFactory accessorFactory, XQMessageFactory messageFactory, XQAddressFactory addressFactory) {
        return new XQServiceContextImpl(epManager, envelopeFactory, accessorFactory, messageFactory, addressFactory, null, 0, null, null, null);
    }

    public boolean hasNextIncoming() {
        return this.m_incoming.hasNext();
    }

    public XQAccessorFactory getAccessorFactory() {
        return this.m_accessorFactory;
    }

    public XQMessageFactory getMessageFactory() {
        return this.m_messageFactory;
    }

    public XQAddressFactory getAddressFactory() {
        return this.m_addressFactory;
    }

    public XQEndpointManager getEndpointManager() {
        return this.m_epManager;
    }

    public XQEnvelopeFactory getEnvelopeFactory() {
        return this.m_envelopeFactory;
    }

    public XQEnvelope getNextIncoming() {
        return this.m_incoming.next();
    }

    public XQEnvelope getFirstIncoming() {
        if (this.m_inbox.size() > 0) {
            return this.m_inbox.get(0);
        }
        return null;
    }

    final void resetIncoming() {
        this.m_incoming = this.m_inbox.iterator();
    }

    void addIncoming(XQEnvelope envelope) {
        this.m_inbox.add(envelope);
        this.resetIncoming();
    }

    void addIncoming(List envelopes) {
        this.m_inbox.addAll(envelopes);
        this.resetIncoming();
    }

    List<XQEnvelope> getInbox() {
        return this.m_inbox;
    }

    void clearIncoming() {
        this.m_inbox.clear();
        this.resetIncoming();
    }

    public void addOutgoing(XQEnvelope envelope) {
        XQMessage msg = (envelope = (XQEnvelope)envelope.clone()).getMessage();
        if (msg != null && msg instanceof XQMessageInternal) {
            XQMessageInternal internalMsg = (XQMessageInternal)msg;
            internalMsg = (XQMessageInternal)internalMsg.protectedClone();
            XQServiceContextImpl.setBoxType(internalMsg, XQServiceConstants.OUTBOX);
            envelope.setMessage((XQMessage)internalMsg);
        }
        this.getOutgoingReqd().add(envelope);
    }

    public void addOutgoing(XQMessage message) {
        if (message != null && message instanceof XQMessageInternal) {
            XQMessageInternal internalMsg = (XQMessageInternal)message;
            internalMsg = (XQMessageInternal)internalMsg.protectedClone();
            XQServiceContextImpl.setBoxType(internalMsg, XQServiceConstants.OUTBOX);
            message = internalMsg;
        }
        XQEnvelope envelope = this.m_envelopeFactory.createDefaultEnvelope(message);
        this.getOutgoingReqd().add(envelope);
    }

    public void clearOutgoing() {
        this.getOutgoingReqd().clear();
    }

    public void addFault(XQEnvelope envelope) {
        XQMessage msg = (envelope = (XQEnvelope)envelope.clone()).getMessage();
        if (msg != null && msg instanceof XQMessageInternal) {
            XQMessageInternal internalMsg = (XQMessageInternal)msg;
            internalMsg = (XQMessageInternal)internalMsg.protectedClone();
            XQServiceContextImpl.setBoxType(internalMsg, XQServiceConstants.FAULTBOX);
            envelope.setMessage((XQMessage)internalMsg);
        }
        this.getFaultsReqd().add(envelope);
    }

    public static void setBoxType(XQMessageInternal msg, Integer type) {
        msg.addSidebandProperty("SonicESB.BOX_TYPE", type);
        if (type.intValue() == XQServiceConstants.FAULTBOX.intValue()) {
            msg.addSidebandProperty("SonicESB.LG_REPORT_FAILURE", "Message addressed to fault endpoint");
        }
    }

    public void addFault(XQMessage message) {
        if (message != null && message instanceof XQMessageInternal) {
            XQMessageInternal internalMsg = (XQMessageInternal)message;
            internalMsg = (XQMessageInternal)internalMsg.protectedClone();
            XQServiceContextImpl.setBoxType(internalMsg, XQServiceConstants.FAULTBOX);
            message = internalMsg;
        }
        XQEnvelope envelope = this.m_envelopeFactory.createFaultEnvelope(message);
        this.getFaultsReqd().add(envelope);
    }

    public void clearFaults() {
        this.getFaultsReqd().clear();
    }

    public XQParameters getParameters() {
        if (this.m_params == null) {
            this.m_params = new XQParametersImpl();
        }
        return this.m_params;
    }

    List<XQEnvelope> getOutgoing() {
        return this.m_outbox;
    }

    List<XQEnvelope> getOutgoingReqd() {
        if (this.m_outbox == null) {
            this.m_outbox = new ArrayList<XQEnvelope>();
        }
        return this.m_outbox;
    }

    List<XQEnvelope> getFaults() {
        return this.m_faultbox;
    }

    List<XQEnvelope> getFaultsReqd() {
        if (this.m_faultbox == null) {
            this.m_faultbox = new ArrayList<XQEnvelope>();
        }
        return this.m_faultbox;
    }

    public XQLog getLog() {
        return XQLogImpl.getInstance();
    }

    public int getCurrentListener() {
        return this.m_currentListener;
    }

    public String getEntryEndpoint() {
        return this.m_entryEndpoint;
    }

    void setEntryEndpoint(String entryEndpoint) {
        this.m_entryEndpoint = entryEndpoint;
    }

    public XQQualityofService getQoS() {
        return this.m_qos;
    }

    void setQoS(XQQualityofService qos) {
        this.m_qos = qos;
    }

    public XQAddress getRMEAddress() {
        return this.m_rmeAddress;
    }

    void setRMEAddress(XQAddress rmeAddr) {
        this.m_rmeAddress = rmeAddr;
    }

    public XQProcessContext getProcessContext() {
        return this.m_processContext;
    }

    void setProcessContext(XQProcessContext processContext) {
        this.m_processContext = processContext;
    }

    public Session getCurrentJMSSession() {
        IJMSEntryEndpointState ees = JMSEndpoint.getJMSEntryEndpointState();
        if (ees != null) {
            return ees.getSession().getRestrictedJMSSession();
        }
        return null;
    }

    public Connection getCurrentJMSConnection() {
        IJMSEntryEndpointState ees = JMSEndpoint.getJMSEntryEndpointState();
        if (ees != null) {
            return ees.getSession().getRestrictedJMSConnection();
        }
        return null;
    }

    void dump(PrintStream out) {
        out.println("Envelope factory: " + this.m_envelopeFactory);
        out.println("Endpoint mgr: " + this.m_epManager);
        out.println();
        out.println("Inbox: " + this.m_inbox);
        out.println("Outbox: " + this.m_outbox);
        out.println("Faultbox: " + this.m_faultbox);
        out.println("Params: " + this.m_params);
    }

    public XQDispatch getDispatcher() {
        return this.m_dispatcher;
    }

    @Override
    public XQService getWrappedService() {
        return null;
    }

    @Override
    public ListIterator inboxIterator() {
        ListIterator<XQEnvelope> inbox = this.getInbox().listIterator();
        return new BoxListIterator(inbox);
    }

    @Override
    public ListIterator outboxIterator() {
        ListIterator<XQEnvelope> outGoing = this.getOutgoingReqd().listIterator();
        return new BoxListIterator(outGoing);
    }

    @Override
    public ListIterator faultboxIterator() {
        ListIterator<XQEnvelope> faults = this.getFaultsReqd().listIterator();
        return new BoxListIterator(faults);
    }

    public XQMitigationContext getMitigationContext() {
        if (this.m_mitigationContextFactory == null) {
            return null;
        }
        return this.m_mitigationContextFactory.getMitigationContext();
    }

    void setMitigationContextFactory(MitigationContextFactory fact) {
        this.m_mitigationContextFactory = fact;
    }

    MitigationContextFactory getMitigationContextFactory() {
        return this.m_mitigationContextFactory;
    }

    public XQLifeCycleManager getLifeCycle() {
        return this.m_lifeCycle;
    }

    public void setInvocationContext(XQInvocationContext invocationContext) {
        this.m_invocationContext = invocationContext;
    }

    public XQInvocationContext getInvocationContext() {
        return this.m_invocationContext;
    }

    public XQAddress getProcessContinuationAddress(XQProcessContinuation continuation) {
        return ItineraryContinuationHelper.resumeContinuation(continuation, this);
    }

    public ESBInteractorFactory getInteractorFactory() {
        return this.m_interactorFactory;
    }
}

