/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.util.spring;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.access.ContextBeanFactoryReference;

public class SonicContextLocator
implements BeanFactoryLocator,
BeanFactoryAware,
BeanNameAware,
ApplicationContextAware {
    private String factoryName;
    protected static final Map beanFactories = new HashMap();
    protected static boolean canUseDefaultBeanFactory = true;
    protected static BeanFactoryReference defaultReference = null;

    public void setApplicationContext(ApplicationContext beanFactory) throws BeansException {
        this.setBeanFactoryInternal((BeanFactory)beanFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBeanFactoryInternal(final BeanFactory beanFactory) throws BeansException {
        Object reference = beanFactory instanceof ApplicationContext ? new ContextBeanFactoryReference((ApplicationContext)beanFactory) : new BeanFactoryReference(){
            private BeanFactory factory;
            {
                this.factory = beanFactory;
            }

            public BeanFactory getFactory() {
                if (this.factory == null) {
                    throw new IllegalArgumentException("beanFactory already released");
                }
                return this.factory;
            }

            public void release() throws FatalBeanException {
                this.factory = null;
            }
        };
        Class<SonicContextLocator> clazz = SonicContextLocator.class;
        synchronized (SonicContextLocator.class) {
            if (canUseDefaultBeanFactory) {
                if (defaultReference == null) {
                    defaultReference = reference;
                } else {
                    canUseDefaultBeanFactory = false;
                    defaultReference = null;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.addToMap(this.factoryName, (BeanFactoryReference)reference);
            String[] aliases = beanFactory.getAliases(this.factoryName);
            for (int i = 0; i < aliases.length; ++i) {
                this.addToMap(aliases[i], (BeanFactoryReference)reference);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToMap(String fName, BeanFactoryReference reference) {
        Map map = beanFactories;
        synchronized (map) {
            if (beanFactories.containsKey(fName)) {
                throw new IllegalArgumentException("a beanFactoryReference already exists for key " + this.factoryName);
            }
            beanFactories.put(fName, reference);
        }
    }

    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        if (factoryKey == null) {
            if (!canUseDefaultBeanFactory) {
                throw new IllegalArgumentException("a non-null factoryKey needs to be specified as there are more then one factoryKeys available");
            }
            return defaultReference;
        }
        return (BeanFactoryReference)beanFactories.get(factoryKey);
    }

    public void setBeanName(String name) {
        this.factoryName = name;
    }
}

