/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.jms;

import java.util.HashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import org.apache.axis.components.jms.BeanVendorAdapter;
import org.apache.axis.transport.jms.JMSURLHelper;
import progress.message.client.ENetworkFailure;
import progress.message.client.EUserAlreadyConnected;
import progress.message.jclient.ErrorCodes;
import progress.message.jclient.TopicConnectionFactory;

public class SonicMQVendorAdapter
extends BeanVendorAdapter {
    private static final String QCF_CLASS = "progress.message.jclient.QueueConnectionFactory";
    private static final String TCF_CLASS = "progress.message.jclient.TopicConnectionFactory";
    public static final String BROKER_URL = "brokerURL";
    public static final String DEFAULT_USERNAME = "defaultUser";
    public static final String DEFAULT_PASSWORD = "defaultPassword";
    public static final String PING_INTERVAL = "pingIntervalLong";
    public static final String RECONNECT_INTERVAL = "reconnectIntervalInteger";
    public static final String RECONNECT_TIMEOUT = "reconnectTimeoutInteger";
    public static final String CONNECT_ID = "connectID";
    public static final String CONNECTION_URLS = "connectionURLs";
    public static final String LOAD_BALANCING = "loadBalancingBoolean";
    public static final String MONITOR_INTERVAL = "monitorInterval";
    public static final String PERSISTENT_DELIVERY = "persistentDeliveryBoolean";
    public static final String SEQUENTIAL = "sequentialBoolean";
    public static final String PREFETCH_COUNT = "prefetchCountInteger";
    public static final String PREFETCH_THRESHOLD = "prefetchThresholdInteger";
    public static final String SELECTOR_AT_BROKER = "selectorAtBroker";

    @Override
    public QueueConnectionFactory getQueueConnectionFactory(HashMap cfConfig) throws Exception {
        cfConfig = (HashMap)cfConfig.clone();
        cfConfig.put("transport.jms.ConnectionFactoryClass", QCF_CLASS);
        return super.getQueueConnectionFactory(cfConfig);
    }

    @Override
    public javax.jms.TopicConnectionFactory getTopicConnectionFactory(HashMap cfConfig) throws Exception {
        cfConfig = (HashMap)cfConfig.clone();
        cfConfig.put("transport.jms.ConnectionFactoryClass", TCF_CLASS);
        return super.getTopicConnectionFactory(cfConfig);
    }

    @Override
    public void addVendorConnectionFactoryProperties(JMSURLHelper jmsurl, HashMap cfProps) {
        if (jmsurl.getPropertyValue(BROKER_URL) != null) {
            cfProps.put(BROKER_URL, jmsurl.getPropertyValue(BROKER_URL));
        }
        if (jmsurl.getPropertyValue(DEFAULT_USERNAME) != null) {
            cfProps.put(DEFAULT_USERNAME, jmsurl.getPropertyValue(DEFAULT_USERNAME));
        }
        if (jmsurl.getPropertyValue(DEFAULT_PASSWORD) != null) {
            cfProps.put(DEFAULT_PASSWORD, jmsurl.getPropertyValue(DEFAULT_PASSWORD));
        }
        if (jmsurl.getPropertyValue(PING_INTERVAL) != null) {
            cfProps.put(PING_INTERVAL, jmsurl.getPropertyValue(PING_INTERVAL));
        }
        if (jmsurl.getPropertyValue(RECONNECT_INTERVAL) != null) {
            cfProps.put(RECONNECT_INTERVAL, jmsurl.getPropertyValue(RECONNECT_INTERVAL));
        }
        if (jmsurl.getPropertyValue(RECONNECT_TIMEOUT) != null) {
            cfProps.put(RECONNECT_TIMEOUT, jmsurl.getPropertyValue(RECONNECT_TIMEOUT));
        }
        if (jmsurl.getPropertyValue(CONNECT_ID) != null) {
            cfProps.put(CONNECT_ID, jmsurl.getPropertyValue(CONNECT_ID));
        }
        if (jmsurl.getPropertyValue(CONNECTION_URLS) != null) {
            cfProps.put(CONNECTION_URLS, jmsurl.getPropertyValue(CONNECTION_URLS));
        }
        if (jmsurl.getPropertyValue(LOAD_BALANCING) != null) {
            cfProps.put(LOAD_BALANCING, jmsurl.getPropertyValue(LOAD_BALANCING));
        }
        if (jmsurl.getPropertyValue(MONITOR_INTERVAL) != null) {
            cfProps.put(MONITOR_INTERVAL, jmsurl.getPropertyValue(MONITOR_INTERVAL));
        }
        if (jmsurl.getPropertyValue(PERSISTENT_DELIVERY) != null) {
            cfProps.put(PERSISTENT_DELIVERY, jmsurl.getPropertyValue(PERSISTENT_DELIVERY));
        }
        if (jmsurl.getPropertyValue(SEQUENTIAL) != null) {
            cfProps.put(SEQUENTIAL, jmsurl.getPropertyValue(SEQUENTIAL));
        }
        if (jmsurl.getPropertyValue(PREFETCH_COUNT) != null) {
            cfProps.put(PREFETCH_COUNT, jmsurl.getPropertyValue(PREFETCH_COUNT));
        }
        if (jmsurl.getPropertyValue(PREFETCH_THRESHOLD) != null) {
            cfProps.put(PREFETCH_THRESHOLD, jmsurl.getPropertyValue(PREFETCH_THRESHOLD));
        }
        if (jmsurl.getPropertyValue(SELECTOR_AT_BROKER) != null) {
            cfProps.put(SELECTOR_AT_BROKER, jmsurl.getPropertyValue(SELECTOR_AT_BROKER));
        }
    }

    @Override
    public boolean isMatchingConnectionFactory(ConnectionFactory cf, JMSURLHelper jmsurl, HashMap cfProps) {
        String brokerURL = null;
        String connectionURLs = null;
        boolean loadBalancing = false;
        boolean sequential = false;
        if (cf instanceof progress.message.jclient.QueueConnectionFactory) {
            progress.message.jclient.QueueConnectionFactory qcf = (progress.message.jclient.QueueConnectionFactory)cf;
            brokerURL = qcf.getBrokerURL();
            connectionURLs = qcf.getConnectionURLs();
            loadBalancing = qcf.getLoadBalancing();
            sequential = qcf.getSequential();
        } else if (cf instanceof TopicConnectionFactory) {
            TopicConnectionFactory tcf = (TopicConnectionFactory)cf;
            brokerURL = tcf.getBrokerURL();
            connectionURLs = tcf.getConnectionURLs();
            loadBalancing = tcf.getLoadBalancing();
            sequential = tcf.getSequential();
        }
        String propertyBrokerURL = (String)cfProps.get(BROKER_URL);
        if (brokerURL != null && !brokerURL.equals(propertyBrokerURL)) {
            return false;
        }
        String propertyConnectionURLs = (String)cfProps.get(CONNECTION_URLS);
        if (connectionURLs != null && propertyConnectionURLs != null) {
            if (!connectionURLs.equalsIgnoreCase(propertyConnectionURLs)) {
                return false;
            }
            String tmpSequential = (String)cfProps.get(SEQUENTIAL);
            boolean propertySequential = true;
            if (tmpSequential != null) {
                propertySequential = Boolean.getBoolean(tmpSequential);
            }
            if (sequential != propertySequential) {
                return false;
            }
        } else if (connectionURLs != null || propertyConnectionURLs != null) {
            return false;
        }
        String tmpLoadBalancing = (String)cfProps.get(LOAD_BALANCING);
        boolean propertyLoadBalancing = false;
        if (tmpLoadBalancing != null) {
            propertyLoadBalancing = Boolean.getBoolean(tmpLoadBalancing);
        }
        return loadBalancing == propertyLoadBalancing;
    }

    @Override
    public boolean isRecoverable(Throwable thrown, int action) {
        if (action != 4 && !super.isRecoverable(thrown, action)) {
            return false;
        }
        if (!(thrown instanceof JMSException)) {
            return true;
        }
        JMSException jmse = (JMSException)thrown;
        switch (action) {
            case 1: {
                if (!this.isNetworkFailure(jmse)) break;
                return false;
            }
            case 2: {
                if (!this.isQueueMissing(jmse) && !this.isAnotherSubscriberConnected(jmse)) break;
                return false;
            }
            case 4: {
                if (!this.isConnectionDropped(jmse)) break;
                return false;
            }
        }
        return true;
    }

    public boolean isConnectionDropped(JMSException jmse) {
        return ErrorCodes.testException((JMSException)jmse, (int)-5);
    }

    private boolean isQueueMissing(JMSException jmse) {
        String message = jmse.getMessage();
        return message != null && message.startsWith("Queue not found");
    }

    private boolean isAnotherSubscriberConnected(JMSException jmse) {
        Exception linkedException = jmse.getLinkedException();
        return linkedException != null && linkedException instanceof EUserAlreadyConnected;
    }

    private boolean isNetworkFailure(JMSException jmse) {
        Exception linkedException = jmse.getLinkedException();
        return linkedException != null && linkedException instanceof ENetworkFailure;
    }
}

