/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.esbdl.impl;

import com.sonicsw.esb.esbdl.EsbdlProcessor;
import com.sonicsw.esb.esbdl.Interface;
import com.sonicsw.esb.esbdl.ParameterMap;
import com.sonicsw.esb.esbdl.XQBinding;
import com.sonicsw.esb.esbdl.impl.InterfaceImpl;
import com.sonicsw.esb.esbdl.impl.OperationImpl;
import com.sonicsw.esb.esbdl.impl.ParameterImpl;
import com.sonicsw.esb.esbdl.impl.ParameterMapImpl;
import com.sonicsw.esb.esbdl.impl.TypesImpl;
import com.sonicsw.esb.esbdl.impl.XQBindingImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class EsbdlDOMProcessor
implements EsbdlProcessor {
    private boolean m_multipleOperationsMode;

    public EsbdlDOMProcessor(boolean multipleOperationsMode) {
        this.m_multipleOperationsMode = multipleOperationsMode;
    }

    @Override
    public List<Interface> parse(Object input) {
        ArrayList<Interface> intfs = new ArrayList<Interface>();
        if (input == null) {
            return intfs;
        }
        assert (input instanceof Element);
        Element elem = (Element)input;
        InterfaceImpl intf = new InterfaceImpl(elem.getAttribute("name"));
        Element documentationElem = DOMUtils.getImmediateChildElementByName((Element)elem, (String)"documentation");
        intf.setDocumentation(documentationElem);
        Element typesElem = DOMUtils.getImmediateChildElementByName((Element)elem, (String)"types");
        if (typesElem != null) {
            TypesImpl types = new TypesImpl(typesElem);
            intf.setTypes(types);
        }
        if (!this.m_multipleOperationsMode) {
            OperationImpl operation = new OperationImpl("default");
            this.parseOperation(operation, elem);
            intf.addOperation(operation);
        } else {
            List operationNodes = DOMUtils.getImmediateChildElementsByName((Element)elem, (String)"operation");
            for (Element operationElem : operationNodes) {
                OperationImpl operation = new OperationImpl(operationElem);
                this.parseOperation(operation, operationElem);
                intf.addOperation(operation);
            }
        }
        intfs.add(intf);
        return intfs;
    }

    private void parseOperation(OperationImpl operation, Element operationElem) {
        Element documentationElem = DOMUtils.getImmediateChildElementByName((Element)operationElem, (String)"documentation");
        operation.setDocumentation(documentationElem);
        List childNodes = DOMUtils.getImmediateChildElements((Element)operationElem);
        for (Element childElem : childNodes) {
            if ("input".equals(childElem.getLocalName())) {
                ParameterMap inputParamMap = this.parseParamMap(operation, childElem);
                operation.setInputParamMap(inputParamMap);
                continue;
            }
            if ("output".equals(childElem.getLocalName())) {
                ParameterMap outputParamMap = this.parseParamMap(operation, childElem);
                operation.setOutputParamMap(outputParamMap);
                continue;
            }
            if (!"fault".equals(childElem.getLocalName())) continue;
            ParameterMap faultParamMap = this.parseParamMap(operation, childElem);
            String faultName = childElem.getAttribute("name");
            if (faultName == null || "".equals(faultName.trim())) {
                faultName = "deFault";
            }
            operation.addFaultParamMap(faultName, faultParamMap);
        }
    }

    private ParameterMap parseParamMap(OperationImpl operation, Element paramsElem) {
        ParameterMapImpl paramMap = new ParameterMapImpl();
        List childNodes = DOMUtils.getImmediateChildElementsByName((Element)paramsElem, (String)"parameter");
        for (Element paramElem : childNodes) {
            ParameterImpl param = new ParameterImpl(operation, paramElem);
            XQBinding binding = this.parseBinding(paramElem);
            if (binding != null) {
                param.setXQBinding(binding);
            }
            paramMap.addParameter(param.getName(), param);
        }
        return paramMap;
    }

    private XQBinding parseBinding(Element paramElem) {
        XQBindingImpl binding = null;
        Element xqBindingElem = DOMUtils.getImmediateChildElementByName((Element)paramElem, (String)"esbBinding");
        if (xqBindingElem != null) {
            Element headerElem = DOMUtils.getImmediateChildElementByName((Element)xqBindingElem, (String)"header");
            if (headerElem != null) {
                String headerName = headerElem.getAttribute("name");
                binding = new XQBindingImpl(headerName);
            } else {
                Element partElem = DOMUtils.getImmediateChildElementByName((Element)xqBindingElem, (String)"part");
                if (partElem != null) {
                    String partContentID = partElem.getAttribute("contentId");
                    String partContentType = partElem.getAttribute("contentType");
                    binding = new XQBindingImpl(partContentID, partContentType);
                }
            }
        }
        return binding;
    }
}

