/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.esbdl.impl;

import com.sonicsw.esb.esbdl.Parameter;
import com.sonicsw.esb.esbdl.XQBinding;
import com.sonicsw.esb.esbdl.impl.OperationImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ParameterImpl
implements Parameter {
    private String m_name;
    private String m_type;
    private String m_contenttype;
    private String m_metatype;
    private String m_description;
    private String m_collection;
    private Namespace m_namespace;
    private XQBinding m_binding;

    public ParameterImpl(OperationImpl operation, String name, String type, String desc) {
        this.m_name = name;
        this.m_type = type;
        this.m_description = desc;
        this.m_namespace = ParameterImpl.populateNamespaceInfo(operation, this.m_type);
    }

    public ParameterImpl(OperationImpl operation, String name, String type, String metaType, String desc) {
        this.m_name = name;
        this.m_type = type;
        this.m_description = desc;
        this.m_metatype = metaType;
        this.m_namespace = ParameterImpl.populateNamespaceInfo(operation, this.m_type);
    }

    public ParameterImpl(OperationImpl operation, String name, String type, String contentType, boolean isCollection, String metaType, String desc) {
        this.m_name = name;
        this.m_type = type;
        this.m_contenttype = contentType;
        this.m_description = desc;
        this.m_metatype = metaType;
        this.m_namespace = ParameterImpl.populateNamespaceInfo(operation, this.m_type);
        if (isCollection) {
            this.m_collection = "true";
        }
    }

    public ParameterImpl(OperationImpl operation, Element paramElem) {
        this.m_name = paramElem.getAttribute("name");
        this.m_metatype = paramElem.getAttribute("metatype");
        this.m_contenttype = paramElem.hasAttribute("contentType") ? paramElem.getAttribute("contentType") : "text/xml";
        this.m_description = paramElem.getAttribute("description");
        this.m_collection = paramElem.hasAttribute("collection") ? paramElem.getAttribute("collection") : "false";
        this.m_type = paramElem.getAttribute("type");
        this.m_namespace = ParameterImpl.populateNamespaceInfo(operation, paramElem, this.m_type);
    }

    private static Namespace populateNamespaceInfo(OperationImpl operation, String type) {
        int colonIndex;
        if (type != null && operation != null && (colonIndex = type.indexOf(58)) > 0) {
            String nsPrefix = type.substring(0, colonIndex);
            return operation.getNamespaceMap().get(nsPrefix);
        }
        return null;
    }

    private static Namespace populateNamespaceInfo(OperationImpl operation, Element paramElem, String type) {
        String noNamespaceSchemaLoc;
        Namespace namespace = ParameterImpl.populateNamespaceInfo(operation, type);
        if (namespace == null && (namespace = XMLUtils.getNamespaceForTypeQName((Element)paramElem, (String)type)) == null && (noNamespaceSchemaLoc = XMLUtils.getNoNamespaceSchemaLocation((Element)paramElem)) != null) {
            namespace = new Namespace(null, "");
            namespace.setSchemaLocationString(noNamespaceSchemaLoc);
        }
        return namespace;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public Namespace getTypeNamespace() {
        return this.m_namespace;
    }

    @Override
    public String getMetatype() {
        return this.m_metatype;
    }

    @Override
    public String getContentType() {
        return this.m_contenttype;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setXQBinding(XQBinding binding) {
        this.m_binding = binding;
    }

    @Override
    public XQBinding getXQBinding() {
        return this.m_binding;
    }

    @Override
    public boolean isCollection() {
        return "true".equalsIgnoreCase(this.m_collection);
    }

    @Override
    public boolean isParamHolderType() {
        return "xq:parameterHolder".equalsIgnoreCase(this.m_type);
    }

    @Override
    public boolean isBinaryType() {
        return "xq:binary".equalsIgnoreCase(this.m_type);
    }
}

