/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.el.BaseELResolver;
import com.sonicsw.esb.expression.model.XQMessageBulkOperation;
import com.sonicsw.esb.itinerary.mapping.FaultMapperHelper;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.ListParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValue;
import com.sonicsw.esb.process.mapping.ParameterValueMap;
import com.sonicsw.xq.XQMessageException;
import java.util.List;
import javax.el.ELContext;

public class ParamValueMapResolver
extends BaseELResolver {
    private static int INPUT_PARAM = 0;
    private static int OUTPUT_PARAM = 1;
    private static int FAULT_PARAM = 2;
    private int m_paramType;

    ParamValueMapResolver() {
        this(0);
    }

    ParamValueMapResolver(int paramType) {
        this.m_paramType = paramType;
    }

    Object get(ELContext context, InvocationContext invContext, String name) {
        if (invContext == null) {
            throw new ExpressionException("The invocation context is not available");
        }
        ParameterValueMap paramValMap = null;
        if (this.m_paramType == INPUT_PARAM) {
            paramValMap = invContext.getInputParameterValues();
        } else if (this.m_paramType == OUTPUT_PARAM) {
            paramValMap = invContext.getOutputParameterValues();
        } else if (this.m_paramType == FAULT_PARAM) {
            String faultName = (String)context.getContext(FaultMapperHelper.class);
            paramValMap = invContext.getFaultParameterValues(faultName);
        } else {
            throw new ExpressionException("Invalid parameter type " + this.m_paramType);
        }
        if (paramValMap == null) {
            throw new ExpressionException("Parameter value map is not accessible");
        }
        ParameterValue paramVal = paramValMap.getParameterValue(name);
        if (paramVal instanceof ListParameterValue) {
            context.putContext(ListParameterValue.class, (Object)paramVal);
        }
        return paramVal;
    }

    void put(ELContext context, InvocationContext invContext, String name, Object value) {
        if (invContext == null) {
            throw new ExpressionException("The invocation context is not available");
        }
        if (value != null) {
            ParameterValueMap paramValMap = (ParameterValueMap)context.getContext(ParameterValueMap.class);
            if (paramValMap == null) {
                if (this.m_paramType == INPUT_PARAM) {
                    paramValMap = invContext.getInputParameterValues();
                } else if (this.m_paramType == OUTPUT_PARAM) {
                    paramValMap = invContext.getOutputParameterValues();
                } else if (this.m_paramType == FAULT_PARAM) {
                    String faultName = (String)context.getContext(FaultMapperHelper.class);
                    paramValMap = invContext.getFaultParameterValues(faultName);
                } else {
                    throw new ExpressionException("Invalid parameter type " + this.m_paramType);
                }
            }
            if (paramValMap == null) {
                throw new ExpressionException("Parameter value map is not accessible");
            }
            ParameterValue paramVal = paramValMap.getParameterValue(name);
            if (paramVal == null) {
                paramVal = value instanceof List ? new ListParameterValue(name, (List)value) : new ParameterValue(name, value);
                paramValMap.add(paramVal);
            } else {
                paramVal.setValue(value);
            }
        }
        context.setPropertyResolved(true);
    }

    @Override
    protected boolean isResolvable(Object base) {
        boolean result = base != null && base instanceof ParamValueMapResolver;
        return result;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object result = null;
        if (this.isResolvable(context, base, property)) {
            ParamValueMapResolver paramValueResolver = (ParamValueMapResolver)((Object)base);
            InvocationContext invCtx = (InvocationContext)context.getContext(InvocationContext.class);
            result = paramValueResolver.get(context, invCtx, (String)property);
        }
        if (result != null) {
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (this.isResolvable(context, base, property)) {
            ParamValueMapResolver paramValueResolver = (ParamValueMapResolver)((Object)base);
            InvocationContext invCtx = (InvocationContext)context.getContext(InvocationContext.class);
            if (value instanceof XQMessageBulkOperation) {
                try {
                    List<Object> collection = ((XQMessageBulkOperation)value).getValue();
                    paramValueResolver.put(context, invCtx, (String)property, collection);
                }
                catch (XQMessageException e) {
                    s_log.logDebug("Ignoring the following exception");
                    s_log.logDebug((Throwable)e);
                }
            } else {
                paramValueResolver.put(context, invCtx, (String)property, value);
            }
        }
    }
}

