/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.model;

import com.sonicsw.esb.expression.el.ExpressionActionExecutor;
import com.sonicsw.esb.expression.model.XQMessageBulkOperation;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import javax.el.ELContext;

public final class XQMessageParts {
    private boolean isBulkOperation;

    public XQMessageParts() {
        this(false);
    }

    public XQMessageParts(boolean isBulkOperation) {
        this.isBulkOperation = isBulkOperation;
    }

    public Object get(XQMessage msg, String contentId) throws XQMessageException {
        if (!this.isBulkOperation) {
            return msg.getPart(contentId);
        }
        ELContext ec = (ELContext)ExpressionActionExecutor.getThreadLocalELContext();
        MappingContext mapCtx = (MappingContext)ec.getContext(MappingContext.class);
        if (mapCtx == null) {
            return new XQMessageBulkOperation(msg, contentId, false);
        }
        XQMessageBulkOperation bop = (XQMessageBulkOperation)mapCtx.getObject(XQMessageBulkOperation.class, false);
        if (bop == null) {
            bop = new XQMessageBulkOperation(msg, contentId, false);
            mapCtx.addObject(XQMessageBulkOperation.class, bop);
        }
        return bop;
    }

    public void put(XQMessage msg, String contentId, XQPart part) throws XQMessageException {
        for (int i = 0; i < msg.getPartCount(); ++i) {
            if (part != msg.getPart(i)) continue;
            part = (XQPart)part.clone();
            break;
        }
        part.setContentId(contentId);
        msg.addPart(part);
    }

    public XQPart get(XQMessage msg, int index) throws XQMessageException {
        return msg.getPart(index);
    }

    public void add(XQMessage msg, int index, XQPart part) throws XQMessageException {
        msg.addPartAt(part, index);
    }

    public void add(XQMessage msg, XQPart part) throws XQMessageException {
        msg.addPart(part);
    }

    public static final Object getPartContentOrNull(XQMessage msg, String contentID) {
        Object result = null;
        try {
            XQPart part;
            if (msg.doesPartExist(contentID) && (part = msg.getPart(contentID)) != null) {
                result = part.getContent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static final Object getPartContentByIndexOrNull(XQMessage msg, int partIndex) {
        Object result = null;
        try {
            XQPart part;
            if (partIndex >= 0 && partIndex <= msg.getPartCount() - 1 && (part = msg.getPart(partIndex)) != null) {
                result = part.getContent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static final XQPartProperties newXMLElement(String parentElementXpath, String newElemName, boolean removeChildElems) {
        return new XQPartProperties(parentElementXpath, newElemName, removeChildElems);
    }

    public static final XQPartProperties newXMLAttribute(String parentElementXpath, String attributeName) {
        return new XQPartProperties(-1, null, attributeName, parentElementXpath);
    }

    public static final XQPartProperties newPart(String contentId, String contentType) {
        return new XQPartProperties(contentId, contentType);
    }

    public static final XQPartProperties newPartAt(int index, String contentId, String contentType) {
        return new XQPartProperties(index, contentId, contentType);
    }

    public static final class XQPartProperties {
        public final String contentType;
        public final String contentId;
        public final int index;
        public final String newElemName;
        public final String targetElementXPath;
        public final String attributeName;
        public final boolean removeChildElems;

        public XQPartProperties(String contentId, String contentType) {
            this(-1, contentId, contentType, null, null, null, false);
        }

        public XQPartProperties(int index, String contentId, String contentType) {
            this(index, contentId, contentType, null, null, null, false);
        }

        public XQPartProperties(int index, String contentId, String attributeName, String targetElementXPath) {
            this(index, contentId, null, attributeName, targetElementXPath, null, false);
        }

        public XQPartProperties(int index, String contentId, String contentType, String attributeName, String targetElementXPath, String newElemName, boolean removeChildElems) {
            this.index = index;
            this.contentId = contentId;
            this.contentType = contentType;
            this.attributeName = attributeName;
            this.targetElementXPath = targetElementXPath;
            this.newElemName = newElemName;
            this.removeChildElems = removeChildElems;
        }

        public XQPartProperties(String targetElementXPath, String newElemName, boolean removeChildElems) {
            this(-1, null, null, null, targetElementXPath, newElemName, removeChildElems);
        }

        public final boolean hasIndex() {
            return this.index > -1;
        }

        public String toString() {
            return "part[" + (this.hasIndex() ? this.index + ", " : "") + this.contentId + "]";
        }

        public boolean isContentIDDefined() {
            return this.contentId != null && this.contentId.trim().length() > 0;
        }
    }
}

