/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.def.Itinerary;
import com.sonicsw.esb.itinerary.def.XQProcess;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.MergeEndGuard;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.DecisionNode;
import com.sonicsw.esb.process.model.MainProcess;
import com.sonicsw.esb.process.model.MergeNode;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import com.sonicsw.esb.process.model.impl.DefaultDecisionNode;
import com.sonicsw.esb.process.model.impl.DefaultMergeNode;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Decision {
    public static final String DECISION = "decision";
    public static final String OPTION = "option";
    static int count = 0;

    static ActivityNode[] parse(Element decisionElem, MainProcess parentProcess) {
        assert (decisionElem.getLocalName().equals(DECISION));
        String name = decisionElem.getAttribute("name");
        if (name == null || "".equals(name.trim())) {
            name = "Decision-" + ++count;
        }
        DefaultDecisionNode decisionNode = new DefaultDecisionNode(name, parentProcess);
        parentProcess.addActivityNode(decisionNode);
        DefaultMergeNode mergeNode = new DefaultMergeNode("merge." + name, parentProcess);
        parentProcess.addActivityNode(mergeNode);
        NodeList childNodes = decisionElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            if (childNode.getLocalName().equals(OPTION)) {
                Element optionElem = (Element)childNode;
                ActivityNode lastNode = Itinerary.parseSteps(optionElem, parentProcess, (ActivityNode)decisionNode);
                if (lastNode instanceof FlowTerminationNode) continue;
                DefaultActivityEdge edge = new DefaultActivityEdge(lastNode, mergeNode);
                edge.setGuard(new MergeEndGuard());
                parentProcess.addActivityEdge(edge);
                continue;
            }
            throw new Error("Invalid element in the esb process schema");
        }
        ActivityNode[] nodes = new ActivityNode[]{decisionNode, mergeNode};
        return nodes;
    }

    static ActivityNode[] parse(XMLStreamReader xsr, MainProcess parentProcess) throws XMLStreamException {
        String name = xsr.getAttributeValue(null, "name");
        if (name == null || "".equals(name.trim())) {
            name = "Decision-" + ++count;
        }
        DefaultDecisionNode decisionNode = new DefaultDecisionNode(name, parentProcess);
        parentProcess.addActivityNode(decisionNode);
        DefaultMergeNode mergeNode = new DefaultMergeNode("merge." + name, parentProcess);
        parentProcess.addActivityNode(mergeNode);
        while (xsr.hasNext()) {
            String stepElemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                stepElemName = xsr.getLocalName();
                if (stepElemName.equals(OPTION)) {
                    ActivityNode lastNode = Itinerary.parseSteps(xsr, parentProcess, (ActivityNode)decisionNode);
                    if (lastNode instanceof FlowTerminationNode) continue;
                    DefaultActivityEdge edge = new DefaultActivityEdge(lastNode, mergeNode);
                    edge.setGuard(new MergeEndGuard());
                    parentProcess.addActivityEdge(edge);
                    continue;
                }
                throw new Error("Invalid element in the esb process schema");
            }
            if (eventType != 2 || !(stepElemName = xsr.getLocalName()).equals(DECISION)) continue;
            break;
        }
        ActivityNode[] nodes = new ActivityNode[]{decisionNode, mergeNode};
        return nodes;
    }

    public static MergeNode serialize(DecisionNode node, Writer writer) throws IOException {
        MergeNode mergeResultNode = null;
        writer.write("<xq:decision");
        Common.marshallAttribute("name", node.getId(), writer);
        writer.write(">");
        ActivityEdge[] edges = node.getOutgoingEdges();
        for (int i = 0; i < edges.length; ++i) {
            writer.write("<xq:option>");
            MergeNode mergeNode = Decision.serializeBranch(edges[i], writer);
            if (mergeNode != null) {
                mergeResultNode = mergeNode;
            }
            writer.write("</xq:option>");
        }
        writer.write("</xq:decision>");
        return mergeResultNode;
    }

    static MergeNode serializeBranch(ActivityEdge edge, Writer writer) throws IOException {
        ActivityNode next = null;
        while (edge != null) {
            next = edge.getDestination();
            assert (next != null);
            if (next instanceof MergeNode) {
                return (MergeNode)next;
            }
            next = XQProcess.marshallActivityNode(next, writer);
            edge = null;
            ActivityEdge[] outgoingEdges = null;
            if (next != null) {
                outgoingEdges = next.getOutgoingEdges();
            }
            if (outgoingEdges == null || outgoingEdges.length <= 0) continue;
            edge = outgoingEdges[0];
        }
        return null;
    }
}

