/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.itinerary.mapping.BaseMappingAction;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingException;
import com.sonicsw.xqimpl.util.Base64;
import com.sonicsw.xqimpl.util.HexBin;

public class BinaryEncodeAction
extends BaseMappingAction
implements MappingAction {
    public static final String BASE64 = "Base64";
    public static final String HEXBIN = "HexBinary";

    @Override
    public Object doAction(Object content, String[] resources, ExpressionContext exprCtx) {
        byte[] byteContent = null;
        if (!(content instanceof byte[])) {
            throw new MappingException("Cannot perform encoding action if data is not a byte array. Content is of type: " + content.getClass());
        }
        byteContent = (byte[])content;
        String encodingType = resources[0] == null ? BASE64 : resources[0];
        try {
            if (encodingType.equalsIgnoreCase(BASE64)) {
                return new String(Base64.encode((byte[])byteContent));
            }
            if (encodingType.equalsIgnoreCase(HEXBIN)) {
                return new String(HexBin.encode((byte[])byteContent));
            }
            throw new MappingException("Unknown encoding type " + encodingType);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MappingException("Error while performing [" + this.toString(content, encodingType) + "]", e);
        }
    }

    private String toString(Object content, String encodingType) {
        return "Encode binary data with `" + encodingType + "` encoding";
    }

    public String toString() {
        return "BinaryEncode";
    }
}

