/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;
import com.sonicsw.esb.expression.el.ELUtils;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.FaultHandler;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultFaultHandler;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class DynamicAddressFaultHandler
extends DefaultFaultHandler
implements FaultHandler {
    protected static XQLog s_log = XQLogImpl.getCategoryLog((int)32768);

    public DynamicAddressFaultHandler(ExecutableNode target) {
        super(target);
    }

    public void setDefaultCatchClause(String expression) {
        if (this.m_defaultCatchClause != null) {
            throw new ProcessModelException("A default catch clause has already been defined for" + this.getTarget().getId());
        }
        this.m_defaultCatchClause = new DynamicAddressCatchClause(null, expression, this.getTarget());
    }

    public static class DynamicAddressCatchClause
    extends FaultHandler.CatchClause {
        private static ExpressionDefProcessorFactory s_expressionDefFactory = new ELExpressionDefProcessFactory();
        private Expression m_expression;
        private ExecutableNode m_target;

        public DynamicAddressCatchClause(String faultType, String expression, ExecutableNode executableNode) {
            super(faultType, null);
            this.m_target = executableNode;
            if (!s_expressionDefFactory.isValidExpression(expression)) {
                throw new ProcessModelException("Expression `" + expression + "` is not a valid EL expression");
            }
            ExpressionContext exprCtx = MappingUtils.getStaticExpressionContext();
            this.m_expression = MappingUtils.getStaticExpressionFactory().createExpression(exprCtx, expression);
        }

        protected void initExpressionContext() {
        }

        @Override
        public ActivityNode getActivityNode(Token token) {
            String addressKey = this.m_target.getId() + ".FH.Process";
            ActivityNode fhNode = (ActivityNode)token.getProperty(addressKey);
            if (fhNode == null) {
                ExpressionContext exprCtx = MappingUtils.getExpressionContext(((EsbMessageExchange)token.getData()).getInputMessage(), (XQServiceContext)null);
                exprCtx.setValue("esbp", new XQProcessContextImpl(((EsbMessageExchange)token.getData()).getXQParameters()));
                XQAddress resolvedFHAddress = ELUtils.getAddress(exprCtx, this.m_expression, token, s_log);
                if (resolvedFHAddress != null && resolvedFHAddress.getType() == 2) {
                    fhNode = XQContainer.getProcessEngine().getProcessByName(resolvedFHAddress.getName());
                    token.setProperty(addressKey, fhNode);
                } else {
                    throw new ItineraryException("Fault handler address " + resolvedFHAddress + " is invalid. Fault handler should be an ESB process.", token);
                }
            }
            return fhNode;
        }

        @Override
        public String toString() {
            return "Catch '" + (this.getFaultType() == null ? "any fault" : this.getFaultType()) + "' and handle with '" + this.m_expression + "'";
        }

        @Override
        public String getSerializationString() {
            return "endpoint_ref=\"" + this.m_expression.toString() + "\" type=\"EXPRESSION\"";
        }
    }
}

