/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.RethrowNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import com.sonicsw.xqimpl.service.XQServiceContextImpl;

public class FaultNode
extends EsbStepNode
implements FlowTerminationNode {
    private static final String DEFAULT_FAULT_NAME = "SonicESB.Fault";
    private static final String DEFAULT_FAULT_STRING = "ESB process threw a fault at ";
    private static final String DEFAULT_FAULT_CODE = "Server";
    private static final String DEFAULT_FAULT_SUBCODE = "";
    public static final String ERROR_NAME = "errorName";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_SUBCODE = "errorSubCode";
    public static final String ERROR_MESSAGE = "errorMessage";

    public FaultNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.initEndpointRef(stepName);
    }

    private void initEndpointRef(String stepName) {
        this.setEndpointRef((XQAddress)new XQAbstractAddressImpl("InternalStep.Fault", 1, stepName));
    }

    @Override
    public Token execute(Token token) {
        boolean result;
        EsbMessageExchange esbMex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !esbMex.isExchangeImmediate() && (result = RunDebugUtil.execute(esbMex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)((EsbMessageExchange)token.getData()).getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst instanceof FaultProcessInstance) {
            ((FaultProcessInstance)procInst).setOriginalRMEMsg(null);
            token.unTagType(Token.Type.RME);
            RethrowNode.tagAsFault(token, (FaultProcessInstance)procInst, esbMex, this);
        } else {
            token.tagType(Token.Type.FAULT);
            ProcessInstanceProps pip = procInst.getProcessInstanceProperties();
            XQAddress faultAddress = pip.getFaultAddress();
            if (faultAddress == null) {
                s_log.logDebug("Fault address is null. Terminating the process without sending any faults.");
                return null;
            }
            esbMex.setDestinationAddress(faultAddress);
        }
        if (this.m_messageMapper != null) {
            esbMex.getXQParameters().setParent(this.m_stepParams);
            DefaultMessageMapper.mapInputMessage(this.m_messageMapper, esbMex);
        }
        FaultNode.setFaultHeaders(esbMex.getInputMessage(), this.m_stepParams, this);
        return token;
    }

    static void setFaultHeaders(XQMessage msg, XQParameters params, ActivityNode node) {
        XQServiceContextImpl.setBoxType((XQMessageInternal)msg, XQServiceConstants.FAULTBOX);
        try {
            if (!msg.containsHeader("SonicESB.Fault.Name")) {
                msg.setStringHeader("SonicESB.Fault.Name", FaultNode.calculateErrorParam(null, params, ERROR_NAME, DEFAULT_FAULT_NAME));
            }
            if (!msg.containsHeader("SonicESB.Fault.Code")) {
                msg.setStringHeader("SonicESB.Fault.Code", FaultNode.calculateErrorParam(null, params, ERROR_CODE, DEFAULT_FAULT_CODE));
            }
            if (!msg.containsHeader("SonicESB.Fault.String")) {
                msg.setStringHeader("SonicESB.Fault.String", FaultNode.calculateErrorParam(null, params, ERROR_MESSAGE, DEFAULT_FAULT_STRING + node.toString()));
            }
            if (!msg.containsHeader("SonicESB.Fault.SubCode") && params != null && params.containsParameter(ERROR_SUBCODE, 1)) {
                msg.setStringHeader("SonicESB.Fault.SubCode", FaultNode.calculateErrorParam(null, params, ERROR_SUBCODE, DEFAULT_FAULT_SUBCODE));
            }
        }
        catch (XQMessageException e) {
            s_log.logDebug("Error while checking/setting Fault name header");
            s_log.logDebug((Throwable)e);
        }
    }

    public static String calculateErrorParam(XQMessage inputMessage, XQParameters params, String paramName, String defaultValue) {
        String value = null;
        try {
            if (inputMessage != null && inputMessage.containsHeader(paramName)) {
                value = (String)inputMessage.removeHeader(paramName);
            }
        }
        catch (XQMessageException e) {
            s_log.logDebug("Ignoring the exception while reading message header " + paramName);
            s_log.logDebug((Throwable)e);
        }
        if (value == null && params != null) {
            value = params.getParameter(paramName, 1);
        }
        return value == null ? defaultValue : value;
    }
}

