/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.FaultProcessInstance;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.ItineraryException;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FlowTerminationNode;
import com.sonicsw.esb.itinerary.model.RunDebugUtil;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessAddress;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import java.util.Map;

public class ResubmitNode
extends EsbStepNode
implements FlowTerminationNode {
    private int m_tries = 5;
    private boolean m_resubmitToSource = false;
    public static final String PARAM_RESUBMIT_SOURCE = "resubmitToFaultSource";
    public static final String PARAM_NUM_TRIES = "numberOfAttempts";
    public static final String FAULT_SOURCE_STEP_NAME = "Fault.Source.StepName";
    public static final String FAULT_SOURCE_PROCESS_NAME = "Fault.Source.ProcessName";
    public static final String FAULT_SOURCE_TOP_PROCESS_NAME = "Fault.Source.TopProcessName";
    public static final int DEFAULT_RETRY_COUNT = 5;

    public ResubmitNode(String id, String stepName, ActivityGroup parent) {
        super(id, parent);
        this.initEndpointRef(stepName);
    }

    private void initEndpointRef(String stepName) {
        this.setEndpointRef((XQAddress)new XQAbstractAddressImpl("InternalStep.Resubmit", 1, stepName));
    }

    @Override
    public void setXQParameters(XQParameters params) {
        super.setXQParameters(params);
        try {
            this.m_tries = this.getRetryCountParam(this.m_stepParams);
            this.m_resubmitToSource = this.m_stepParams.getBooleanParameter(PARAM_RESUBMIT_SOURCE, 1);
        }
        catch (XQServiceException xQServiceException) {
            // empty catch block
        }
    }

    @Override
    public Token execute(Token token) {
        boolean result;
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (!(procInst instanceof FaultProcessInstance)) {
            throw new ItineraryException("Resubmit step " + this.m_id + " is being used in a non-FaultHandler process", token);
        }
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && (result = RunDebugUtil.execute(mex, token, this))) {
            XQMessageInternal msgInternal = (XQMessageInternal)mex.getInputMessage();
            return (Token)msgInternal.getSidebandProperty("TOKEN");
        }
        if (this.m_messageMapper != null) {
            mex.getXQParameters().setParent(this.m_stepParams);
            DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
        }
        token.unTagType(Token.Type.RME);
        token.unTagType(Token.Type.FAULT);
        RMEMessage rmeMsg = ((FaultProcessInstance)procInst).getOriginalRMEMsg();
        if (rmeMsg != null) {
            rmeMsg.removeHeaders(mex.getInputMessage());
        } else {
            ((FaultProcessInstance)procInst).removeFaultHeaders(mex.getInputMessage());
        }
        return token;
    }

    @Override
    public void offerOutgoing(Token token) {
        this.deactivate(token);
        FaultProcessInstance procInst = (FaultProcessInstance)token.getProcessInstance();
        XQProcessInstance origProcInst = procInst.getOriginalProcessInstance();
        ProcessInstanceProps origProcInstProps = procInst.getOriginalProcessInstanceProps();
        boolean isFHTargetProcess = origProcInstProps.isFaultHandlerTargetProcessNode();
        origProcInstProps.setInflightProperties(procInst.getProcessInstanceProperties().getInflightProps());
        procInst.changeProcessState(token, ProcessState.CLOSED);
        token.setProcessInstance(origProcInst);
        ActivityNode continueFromNode = null;
        continueFromNode = isFHTargetProcess ? origProcInst.getProcessDefinition() : origProcInst.getActiveEsbNode(token);
        this.processRetryCount(procInst, origProcInst, continueFromNode, token);
        if (this.m_resubmitToSource) {
            String stepName;
            String topProcessName = (String)origProcInstProps.getAllProcessProps().get(FAULT_SOURCE_TOP_PROCESS_NAME);
            if (topProcessName == null) {
                topProcessName = origProcInstProps.getRootProcessName();
            }
            if ((stepName = (String)origProcInstProps.getAllProcessProps().get(FAULT_SOURCE_STEP_NAME)) == null) {
                stepName = origProcInstProps.getStepName();
            }
            if (s_debugLogEnabled) {
                s_log.logDebug(this + ": About to retry the step that threw the fault. Step details: Top Process Name: `" + topProcessName + "` Step Name: `" + stepName + "`");
            }
            try {
                XQProcessAddress processAddr = new XQAddressFactoryImpl("Resubmit step", 0).createProcessAddress(topProcessName, stepName);
                origProcInstProps.overrideProcessAddr(processAddr);
                EsbMessageExchange mex = (EsbMessageExchange)token.getData();
                mex.setDestinationAddress((XQAddress)processAddr);
                ItineraryEngine itinEngine = (ItineraryEngine)XQContainer.getProcessEngine();
                itinEngine.processContinuationTokenForStep(token, topProcessName, stepName);
                XQProcessInstance newInstance = (XQProcessInstance)token.getProcessInstance();
                newInstance.getProcessInstanceProperties().getAllProcessProps().putAll((Map<?, ?>)origProcInstProps.getAllProcessProps());
                itinEngine.goToStep((EsbNode)newInstance.getActiveEsbNode(token), token);
            }
            catch (Throwable e) {
                throw new ItineraryException(e, "Error resubmitting to process =`" + topProcessName + "` Step = `" + stepName, token);
            }
        } else {
            ((ItineraryEngine)XQContainer.getProcessEngine()).continueProcess(token, continueFromNode);
            if (s_log.isDebugLoggingEnabled()) {
                s_log.logDebug(this + ": About to retry from fault handler location: `" + continueFromNode.getDisplayName() + "`");
            }
        }
    }

    private void processRetryCount(FaultProcessInstance procInst, XQProcessInstance origProcInst, ActivityNode continueFromNode, Token token) {
        int retryCount = procInst.getFaultHandlerRetryCount();
        procInst.setFaultHandlerRetryCount(++retryCount);
        if (s_debugLogEnabled) {
            s_log.logDebug(this + ": Current retry count: " + retryCount + " of of max retries " + this.m_tries + " for process instance: " + origProcInst.getPID());
        }
        if (this.m_tries <= retryCount) {
            origProcInst.disableFaultHandling(this.getParentProcess(), continueFromNode, token);
        }
    }

    private int getRetryCountParam(XQParameters params) {
        int result = 5;
        String value = params.getParameter(PARAM_NUM_TRIES, 1, "5");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }
}

