/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.caching;

import com.progress.utilities.cache.engine.CacheEngine;
import com.progress.utilities.cache.engine.CacheEngineEnvironment;
import com.progress.utilities.cache.engine.CacheEntry;
import com.progress.utilities.cache.engine.CacheException;
import com.progress.utilities.cache.engine.CacheKey;
import com.progress.utilities.cache.engine.Parameters;
import com.progress.utilities.cache.engine.ehcache.EhcacheProvider;
import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.el.ELExpressionFactory;
import com.sonicsw.esb.expression.el.ELUtils;
import com.sonicsw.esb.process.caching.CacheReferences;
import com.sonicsw.esb.process.caching.CachingDefinition;
import com.sonicsw.esb.process.caching.CachingException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CacheManager {
    private final Map<String, CacheEngine> caches = new HashMap<String, CacheEngine>();
    private static final ELExpressionFactory s_expressionFactory = ELUtils.createExpressionFactory();

    public void setupCaches(CachingDefinition caching, XQParameters parameters) throws CachingException {
        for (CacheReferences cache : caching.getCaches().values()) {
            if (this.caches.containsKey(cache.getCacheName())) continue;
            try {
                this.createCache(cache, parameters);
            }
            catch (CacheException e) {
                throw new CachingException("Cannot set up cache named '" + cache.getCacheName() + "' due to: " + e.getMessage(), e);
            }
        }
    }

    private void createCache(CacheReferences cache, final XQParameters parameters) throws CacheException {
        String policyContent = "<p1:CachePolicy xmlns:p1=\"http://www.sonicsw.com/sonicxq\"> <p1:Expiration> <p1:TimeToLive>PT60M</p1:TimeToLive> </p1:Expiration> <p1:Eviction> <p1:MaxEntries>10000</p1:MaxEntries> <p1:Strategy> <p1:BuiltIn>LRU</p1:BuiltIn> </p1:Strategy> </p1:Eviction> <p1:ClusteredMode>off</p1:ClusteredMode> <p1:Durability>non_persistent</p1:Durability> <p1:OperationMode>L1</p1:OperationMode> </p1:CachePolicy>";
        String cacheName = cache.getCacheName();
        try {
            String line;
            URL config = new URL("sonicfs:///System/SonicESB/" + cacheName + ".esbcache");
            InputStream is = config.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                out.append(line);
            }
            policyContent = out.toString();
            reader.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Parameters parameterWrapper = new Parameters(){

            public String get(String parameter) throws Exception {
                return parameters.getParameter(parameter, 1);
            }
        };
        CacheEngineEnvironment environment = new CacheEngineEnvironment();
        CacheEngine cacheEngine = new CacheEngine(environment);
        cacheEngine.init(cacheName, policyContent, EhcacheProvider.class.getName(), parameterWrapper);
        this.caches.put(cacheName, cacheEngine);
    }

    public void shutdown() {
        for (CacheEngine cache : this.caches.values()) {
            cache.shutdown();
        }
    }

    public Map<String, Serializable> computeCacheKeys(CachingDefinition caching, XQServiceContext serviceContext) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        XQMessage message = serviceContext.getFirstIncoming().getMessage();
        ExpressionContext context = s_expressionFactory.createContext();
        ELUtils.prepareDefaultExpressionContext(context, message, serviceContext);
        ELUtils.setNamespaceMap(context, caching.getNamespaceMap());
        for (CacheReferences cache : caching.getCaches().values()) {
            String keyContext;
            Expression expression = s_expressionFactory.createExpression(context, cache.getKeyExpression(), String.class);
            String keyValue = (String)expression.getValue(context);
            CacheKey key = new CacheKey(keyValue, keyContext = this.computeKeyContext(cache.getKeyContext(), serviceContext));
            if (!key.isValid()) continue;
            result.put(cache.getKeyId(), (Serializable)key);
        }
        return result;
    }

    private String computeKeyContext(String keyContext, XQServiceContext serviceContext) {
        if ("step".equals(keyContext)) {
            return new XQAbstractAddressImpl(serviceContext.getProcessContext().getTopProcessName(), 2, serviceContext.getProcessContext().getStepName()).toString();
        }
        if ("address".equals(keyContext)) {
            return serviceContext.getAddressFactory().getSelfAddress().toString();
        }
        if ("top-level-process".equals(keyContext)) {
            return new XQAbstractAddressImpl(serviceContext.getProcessContext().getTopProcessName(), 2).toString();
        }
        if ("none".equals(keyContext)) {
            return null;
        }
        throw new IllegalArgumentException("The value of the cache key context enumeration cannot be " + keyContext);
    }

    public Object getEntry(String cacheName, Serializable cacheKey) throws CachingException {
        assert (cacheKey instanceof CacheKey);
        CacheKey key = (CacheKey)cacheKey;
        CacheEngine cacheEngine = this.caches.get(cacheName);
        try {
            CacheEntry cacheEntry = cacheEngine.get(key, null);
            return cacheEntry != null ? cacheEntry.getValue() : null;
        }
        catch (CacheException e) {
            throw new CachingException(e);
        }
    }

    public Object putEntry(String cacheName, Serializable cacheKey, Object value) throws CachingException {
        assert (cacheKey instanceof CacheKey);
        CacheKey key = (CacheKey)cacheKey;
        CacheEngine cacheEngine = this.caches.get(cacheName);
        try {
            CacheEntry cacheEntry = cacheEngine.put(key, value, "test/content", cacheEngine.getDefaultTTL(), true);
            return cacheEntry.getValue();
        }
        catch (CacheException e) {
            throw new CachingException(e);
        }
    }
}

