/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.ExecutableNode;
import com.sonicsw.esb.process.model.GroupEndNode;
import com.sonicsw.esb.process.model.GroupStartNode;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultExecutableNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositeActivityNode
extends DefaultExecutableNode
implements ActivityGroup,
ExecutableNode {
    protected GroupStartNode m_initialNode;
    protected Map<String, ActivityGroup> m_activityGroups = new HashMap<String, ActivityGroup>(2);
    protected Map<String, ActivityNode> m_activityNodes = new HashMap<String, ActivityNode>();
    protected Map<String, ActivityEdge> m_edges = new HashMap<String, ActivityEdge>();
    protected GroupEndNode m_endNode;

    public CompositeActivityNode(String id, ActivityGroup parent) {
        super(id, parent);
    }

    @Override
    public Token execute(Token token) {
        assert (this.m_initialNode != null);
        token.changeOwnership(this.m_initialNode, false);
        this.m_initialNode.offerIncoming(token);
        return null;
    }

    @Override
    public void addActivityNode(ActivityNode activityNode) {
        if (this.equals(activityNode)) {
            throw new ProcessModelException("Cannot add itself as the child node");
        }
        this.m_activityNodes.put(activityNode.getId(), activityNode);
    }

    @Override
    public ActivityNode getActivityNode(String nodeId) {
        return this.m_activityNodes.get(nodeId);
    }

    public ActivityEdge getActivityEdge(String id) {
        return this.m_edges.get(id);
    }

    @Override
    public void setInitialNode(GroupStartNode initialNode) {
        this.m_initialNode = initialNode;
        if (this.getActivityNode(initialNode.getId()) == null) {
            this.addActivityNode(initialNode);
        }
    }

    @Override
    public GroupStartNode getInitialNode() {
        return this.m_initialNode;
    }

    @Override
    public void setEndNode(GroupEndNode endNode) {
        this.m_endNode = endNode;
        if (this.getActivityNode(endNode.getId()) == null) {
            this.addActivityNode(endNode);
        }
    }

    @Override
    public GroupEndNode getEndNode() {
        return this.m_endNode;
    }

    @Override
    public void addActivityGroup(ActivityGroup activityGroup) {
        assert (!this.equals(activityGroup)) : "Cannot add itself as the child node";
        this.m_activityGroups.put(activityGroup.getId(), activityGroup);
        if (activityGroup instanceof CompositeActivityNode) {
            this.addActivityNode(activityGroup);
        }
    }

    @Override
    public Collection<ActivityNode> getChildNodes() {
        return this.m_activityNodes.values();
    }

    @Override
    public Collection<ActivityNode> getAllNodes() {
        ArrayList<ActivityNode> allNodes = new ArrayList<ActivityNode>();
        CompositeActivityNode.addChildNodes(this, allNodes);
        return allNodes;
    }

    private static void addChildNodes(ActivityGroup group, List<ActivityNode> resultList) {
        for (ActivityNode node : group.getChildNodes()) {
            resultList.add(node);
            if (!(node instanceof ActivityGroup)) continue;
            CompositeActivityNode.addChildNodes((ActivityGroup)node, resultList);
        }
    }

    @Override
    public ActivityGroup getActivityGroup(String id) {
        return this.m_activityGroups.get(id);
    }

    @Override
    public void removeActivityGroup(ActivityGroup activityGroup) {
        this.m_activityGroups.remove(activityGroup.getId());
    }

    @Override
    public void removeActivityNode(ActivityNode activityNode) {
        this.m_activityNodes.remove(activityNode.getId());
    }

    @Override
    public void addActivityEdge(ActivityEdge edge) {
        ActivityEdge e = this.m_edges.get(edge.getId());
        if (e != null) {
            throw new ProcessModelException("Activity edge " + edge.getId() + " already exists");
        }
        this.m_edges.put(edge.getId(), edge);
        String desc = "";
        if (edge.getSource() != null) {
            desc = " from: '" + edge.getSource().getId() + "' ";
            edge.getSource().addOutgoingEdge(edge);
        }
        if (edge.getDestination() != null) {
            desc = desc + " to: '" + edge.getDestination().getId() + "' ";
            edge.getDestination().addIncomingEdge(edge);
        }
    }

    @Override
    public void removeActivityEdge(ActivityEdge edge) {
        ActivityEdge e = this.m_edges.remove(edge.getId());
        if (e != null) {
            if (edge.getSource() != null) {
                edge.getSource().removeOutgoingEdge(edge);
            }
            if (edge.getDestination() != null) {
                edge.getDestination().removeIncomingEdge(edge);
            }
            if (s_debugLogEnabled) {
                s_log.logDebug("Removing Activity Edge: " + edge.getId());
            }
        }
    }
}

