/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.engine.EngineException;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.DecisionNode;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultActivityEdge;
import com.sonicsw.esb.process.model.impl.DefaultControlNode;
import java.util.ArrayList;
import java.util.List;

public class DefaultDecisionNode
extends DefaultControlNode
implements DecisionNode {
    private DefaultActivityEdge m_defaultEdge;

    public DefaultDecisionNode(String id, ActivityGroup parent) {
        super(id, parent);
    }

    protected void addOutgoingEdge(DefaultActivityEdge edge) {
        if (s_debugLogEnabled) {
            s_log.logDebug("Setting outgoing edge for decision node " + edge.getId());
        }
        if (!edge.hasGuard()) {
            if (this.m_defaultEdge != null) {
                throw new ProcessModelException("Edge '" + this.m_defaultEdge.getId() + "' is already defined as the default edge for " + "this decision node " + this.m_id + ". " + "Cannot add edge " + edge.getId() + " as a default edge");
            }
            if (s_debugLogEnabled) {
                s_log.logDebug(edge.getId() + " is a default edge ");
            }
            this.m_defaultEdge = edge;
        } else {
            super.addOutgoingEdge(edge);
        }
    }

    @Override
    public List<ActivityEdge> getFireableEdges(Token token) {
        List<ActivityEdge> fireableEdges = super.getFireableEdges(token);
        if (fireableEdges == null || fireableEdges.size() == 0) {
            if (this.m_defaultEdge != null) {
                if (s_debugLogEnabled) {
                    s_log.logDebug("Using default edge " + this.m_defaultEdge.getId() + " from " + this.m_id + " to process message for instance " + token.getProcessInstance().getPID());
                }
                if (fireableEdges == null) {
                    fireableEdges = new ArrayList<ActivityEdge>();
                }
                fireableEdges.add(this.m_defaultEdge);
            }
        } else if (fireableEdges.size() > 1) {
            throw new EngineException("Multiple outgoing edges of " + this.m_id + " can accept message for instance " + token.getProcessInstance().getPID());
        }
        return fireableEdges;
    }

    @Override
    public void setDefaultOutgoingEdge(ActivityEdge edge) {
    }
}

