/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.process.model.impl;

import com.sonicsw.esb.process.engine.Persistence;
import com.sonicsw.esb.process.engine.PersistenceManager;
import com.sonicsw.esb.process.engine.ProcessInstance;
import com.sonicsw.esb.process.model.Scope;
import com.sonicsw.esb.process.model.Variable;
import org.w3c.dom.Document;

public class DefaultVariable
implements Variable {
    protected Scope m_scope;
    protected String m_name;
    protected String m_type;
    protected String m_location;

    public DefaultVariable(String name, String type, Scope scope) {
        this.m_name = name;
        this.m_type = type;
        this.m_scope = scope;
        this.m_scope.addVariable(this);
    }

    @Override
    public void setLocation(String location) {
        this.m_location = location;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public Scope getScope() {
        return this.m_scope;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public void persist(ProcessInstance procInst, Object contents) {
        assert (contents instanceof Document);
        Document variableAsDOM = (Document)contents;
        this.m_location = PersistenceManager.instance().persistVariable(this, variableAsDOM).toString();
        procInst.persistVariable(this);
    }

    @Override
    public Object getContents(ProcessInstance procInst) {
        return this.getContents(procInst, true);
    }

    @Override
    public Object getContents(ProcessInstance procInst, boolean isRequired) {
        Persistence persistence = PersistenceManager.instance();
        Object contents = persistence.getVariableContents(this, isRequired);
        return contents;
    }

    @Override
    public void copyFromVariable(ProcessInstance inst, Variable fromVariable) {
        Object fromVarContents = fromVariable.getContents(inst);
        this.persist(inst, fromVarContents);
    }

    public String toString() {
        return this.m_scope.getId() + '.' + this.m_name;
    }
}

