/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms.messagingbean;

import com.sonicsw.esb.testcallback.ITestCallback;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.connector.jms.JMSBreakPointHelper;
import com.sonicsw.xq.connector.jms.JMSEndpointContainer;
import com.sonicsw.xq.connector.jms.JMSEndpointStandalone;
import com.sonicsw.xq.connector.jms.NoResolvedUrlException;
import com.sonicsw.xq.connector.jms.RestrictedConnection;
import com.sonicsw.xq.connector.jms.messagingbean.IJMSEndpointListener;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xq.connector.jms.messagingbean.SessionCollection;
import com.sonicsw.xq.connector.jms.messagingbean.TempDestinationCache;
import com.sonicsw.xq.connector.jms.spi.SonicConnectionFactory;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.envelope.TempDestinationAddress;
import com.sonicsw.xqimpl.service.TestCallbackManager;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import progress.message.client.prAccessor;

public class MessagingBean {
    private boolean m_bConnectionStarted = false;
    private String m_strBrokerHostName = null;
    protected String m_strUserID = null;
    protected String m_strPassword = null;
    private Map<String, Object> m_cfMap = null;
    private IXQConfigManager m_configManager = null;
    private String m_connectionCfgName = null;
    private String m_connectionName = null;
    private String m_connectionFactoryClassName = null;
    private boolean m_runOutsideContainer;
    private final SessionCollection m_sessionCollection;
    private Connection m_connection = null;
    private Connection m_restrictedConnection = null;
    private final Map<String, SessionPool> m_sessionPools;
    private volatile boolean m_isConnected = false;
    private volatile boolean m_needConnect = true;
    private final Object m_connectLock = new Object();
    private ExceptionListener m_exceptionListener = null;
    private static final String HTTP = "http";
    private static final String SSL = "ssl";
    private static final String POOLED_SESSION_SUFFIX = "_POOLED_SESSION:";
    private static XQLog log = XQLogImpl.getCategoryLog((int)512);
    private static XQLog systemLog = XQLogImpl.getInstance();
    private final Object m_startCloseSyncObject = new Object();
    private static final int ADD_SESSION = 0;
    private static final int ADD_QUEUE_CONSUMER = 1;
    private static final int ADD_DURABLE_CONSUMER = 2;
    private static final int SET_MESSAGE_LISTENER = 3;
    private static final int ADD_NON_DURABLE_CONSUMER = 4;
    protected List<HistoryStruct> m_connectHistory = Collections.synchronizedList(new LinkedList());
    protected List<String> m_excludedSessions = Collections.synchronizedList(new LinkedList());
    protected List<String> m_entriesInHistory = Collections.synchronizedList(new LinkedList());
    private final ReentrantReadWriteLock m_sessionLock = new ReentrantReadWriteLock();
    private static final ReentrantLock SSLLock = new ReentrantLock();
    private static final Map<String, String> s_configNamesToSysPropsMap = new HashMap<String, String>();

    public MessagingBean() {
        this.m_sessionCollection = new SessionCollection();
        this.m_sessionPools = new ConcurrentHashMap<String, SessionPool>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNeedConnect() {
        Object object = this.m_connectLock;
        synchronized (object) {
            return this.m_needConnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedConnect(boolean needConnect) {
        Object object = this.m_connectLock;
        synchronized (object) {
            this.m_needConnect = needConnect;
        }
    }

    public final void setCFMap(HashMap<String, Object> cfMap) {
        this.m_cfMap = cfMap;
    }

    public final void setConfigManager(IXQConfigManager configManager) {
        this.m_configManager = configManager;
    }

    public final void setConnectionName(String name) {
        this.m_connectionName = name;
    }

    protected final String getConnectionName() {
        return this.m_cfMap == null ? null : (String)this.m_cfMap.get("name");
    }

    public final void setConnectionConfigName(String name) {
        this.m_connectionCfgName = name;
    }

    protected final String getConnectionConfigName() {
        return this.m_connectionCfgName;
    }

    public final void setRunOutsideContainer(boolean runOutsideContainer) {
        this.m_runOutsideContainer = runOutsideContainer;
    }

    protected final boolean getRunOutsideContainer() {
        return this.m_runOutsideContainer;
    }

    protected final void setSSLParameters() {
        if (this.m_cfMap != null) {
            this.updateSysProperties("SSL_CA_CERTIFICATES_DIR");
            this.updateSysProperties("SSL_CERTIFICATE_CHAIN");
            this.updateSysProperties("SSL_PRIVATE_KEY");
            this.updateSysProperties("SSL_PRIVATE_KEY_PASSWORD");
            this.updateSysProperties("SSL_PROVIDER_CLASS");
            this.updateSysProperties("SSL_CERTIFICATE_CHAIN_FORM");
            this.updateSysProperties("SSL_CIPHER_SUITES");
            this.updateSysProperties("SSL_JSSE_KEY_STORE_KEY_ALIAS");
            this.updateSysProperties("SSL_JSSE_KEY_STORE_KEY_PASSWORD");
            this.updateSysProperties("SSL_JSSE_KEY_STORE_LOCATION");
            this.updateSysProperties("SSL_JSSE_KEY_STORE_PASSWORD");
            this.updateSysProperties("SSL_JSSE_KEY_STORE_TYPE");
            this.updateSysProperties("SSL_JSSE_TRUST_MANAGER");
            this.updateSysProperties("SSL_JSSE_TRUST_STORE_LOCATION");
            this.updateSysProperties("SSL_JSSE_TRUST_STORE_PASSWORD");
            this.updateSysProperties("SSL_JSSE_TRUST_STORE_TYPE");
        }
    }

    private void updateSysProperties(String configName) {
        Object param;
        Properties sysProps = System.getProperties();
        String sysPropName = s_configNamesToSysPropsMap.get(configName);
        if (sysPropName == null) {
            sysPropName = configName;
        }
        if ((param = this.m_cfMap.get(configName)) != null) {
            sysProps.put(sysPropName, param);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("MessageBean: Set System Property " + sysPropName + " to " + param);
            }
        } else {
            sysProps.remove(sysPropName);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("MessageBean: Removed System Property " + sysPropName);
            }
        }
    }

    public final void addNonDurableConsumer(int ackMode, boolean transacted, String destinationName, String messageSelector, boolean noLocal, String sessionName, int flowToDisk, boolean reconnect, boolean isTmpEP) throws JMSException {
        Session session = this.getSession(sessionName);
        if (this.needsNewSession(session, sessionName)) {
            session = this.addSession(sessionName, ackMode, transacted, flowToDisk, reconnect);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(sessionName + " not found !, Creating new...");
            }
        }
        if (session != null) {
            session.addConsumer(destinationName, "TOPIC", messageSelector, noLocal, isTmpEP);
        }
        this.addHistoryStructWithLock(reconnect, new HistoryStruct(4, ackMode, transacted, destinationName, "TOPIC", messageSelector, noLocal, sessionName, flowToDisk));
    }

    public final void addQueueConsumer(int ackMode, boolean transacted, String destinationName, String messageSelector, boolean noLocal, int prefetchCount, int prefetchThreshold, String sessionName, int flowToDisk, boolean reconnect, boolean isTmpEP) throws JMSException {
        Session session = this.getSession(sessionName);
        if (this.needsNewSession(session, sessionName)) {
            session = this.addSession(sessionName, ackMode, transacted, flowToDisk, reconnect);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(sessionName + " not found !, Creating new...");
            }
        }
        if (session != null) {
            session.addConsumer(destinationName, "QUEUE", messageSelector, noLocal, prefetchCount, prefetchThreshold, isTmpEP);
        }
        this.addHistoryStructWithLock(reconnect, new HistoryStruct(1, ackMode, transacted, destinationName, "QUEUE", messageSelector, noLocal, prefetchCount, prefetchThreshold, sessionName, flowToDisk, isTmpEP));
    }

    private boolean needsNewSession(Session session, String sessionName) throws JMSException {
        boolean result;
        if (session != null) {
            return false;
        }
        boolean bl = result = !this.isThreadLocalSession(sessionName);
        if (!result) {
            throw new JMSException("The session is closed. " + sessionName);
        }
        return result;
    }

    private void beginEndpointSessionSetup() throws InterruptedException {
        this.m_sessionLock.writeLock().lockInterruptibly();
    }

    private void endEndpointSessionSetup() {
        this.m_sessionLock.writeLock().unlock();
    }

    public final void addDurableConsumer(int ackMode, boolean transacted, String destinationName, String name, String messageSelector, boolean noLocal, String sessionName, int flowToDisk, boolean reconnect) throws JMSException {
        Session session = this.getSession(sessionName);
        if (this.needsNewSession(session, sessionName)) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(sessionName + " not found !, Creating new...");
            }
            session = this.addSession(sessionName, ackMode, transacted, flowToDisk, reconnect);
        }
        if (session != null) {
            session.addDurableConsumer(destinationName, name, messageSelector, noLocal);
        }
        this.addHistoryStructWithLock(reconnect, new HistoryStruct(2, ackMode, transacted, destinationName, "TOPIC", name, messageSelector, noLocal, sessionName, flowToDisk));
    }

    private void assertSessionWriteLock() {
        if (!this.m_sessionLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("Modification to the connection's sessions without the session write lock being held.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Session addSession(String sessionName, int nAckMode, boolean bTransacted, int flowToDisk, boolean reconnect) throws JMSException {
        Session session;
        try {
            this.beginEndpointSessionSetup();
        }
        catch (InterruptedException e) {
            throw new JMSException(e.getMessage());
        }
        try {
            session = this.m_sessionCollection.addSession(this.m_connection, this.m_restrictedConnection, this, sessionName, nAckMode, bTransacted, flowToDisk);
            this.m_excludedSessions.remove(sessionName);
            this.addHistoryStruct(reconnect, new HistoryStruct(0, sessionName, nAckMode, bTransacted, flowToDisk));
        }
        finally {
            this.endEndpointSessionSetup();
        }
        session.createSession();
        return session;
    }

    public final synchronized void closeConnection() throws JMSException {
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
                this.m_connection = null;
                this.m_restrictedConnection = null;
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("Connection closed.");
                }
                this.m_connectHistory.clear();
            }
        }
        catch (JMSException je) {
            this.m_connection = null;
            this.m_restrictedConnection = null;
            throw je;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSession(String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session != null) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("About to close session: " + sessionName);
            }
            Object object = this.m_startCloseSyncObject;
            synchronized (object) {
                session.closeSession(false);
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("Finished closing session: " + sessionName);
            }
        }
        this.m_excludedSessions.add(sessionName);
    }

    public final void commit(String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session != null) {
            session.commit();
            this.addBreakPoint(session);
        }
    }

    private void addBreakPoint(Session session) {
        if (session == null) {
            return;
        }
        try {
            ITestCallback callback = TestCallbackManager.getCallback("com.sonicsw.xq.connector.jms.JMSEndpoint");
            if (callback == null) {
                return;
            }
            ArrayList<String> stuff = new ArrayList<String>();
            stuff.add(session.getSessionName() + ":" + session.getJMSSession().hashCode());
            callback.call("commitSessionName", "commitSession name", stuff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void waitTillConnected(long timeout) throws JMSException {
        if (!this.m_isConnected) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.m_isConnected) {
            throw new JMSException("Failed to connect to endpoint");
        }
    }

    public synchronized boolean isConnected() {
        return this.m_isConnected;
    }

    /*
     * Exception decompiling
     */
    public final synchronized boolean reconnect() throws JMSException, XQConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void activateJmsSessions() {
        for (HistoryStruct histStruct : this.m_connectHistory) {
            StringBuilder activityDescr = new StringBuilder();
            try {
                this.applyHistoryStruct(histStruct, activityDescr);
            }
            catch (JMSException jmse) {
                log.logWarning("Failed to:" + activityDescr.toString());
                log.logWarning((Throwable)jmse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistoryStructWithLock(boolean reconnect, HistoryStruct h) throws JMSException {
        try {
            this.beginEndpointSessionSetup();
        }
        catch (InterruptedException e) {
            throw new JMSException(e.getMessage());
        }
        try {
            this.addHistoryStruct(reconnect, h);
        }
        finally {
            this.endEndpointSessionSetup();
        }
    }

    private void addHistoryStruct(boolean reconnect, HistoryStruct h) {
        String sessionKey = h.getSessionName() + '.' + h.operation;
        if (!reconnect && !this.m_entriesInHistory.contains(sessionKey)) {
            this.m_connectHistory.add(h);
            this.m_entriesInHistory.add(sessionKey);
        }
    }

    private void applyHistoryStruct(HistoryStruct h, StringBuilder desc) throws JMSException {
        this.assertSessionWriteLock();
        if (this.m_excludedSessions.contains(h.getSessionName())) {
            return;
        }
        switch (h.operation) {
            case 0: {
                desc.append("Add session:").append(h.getSessionName());
                this.addSession(h.getSessionName(), h.getAckMode(), h.isTransacted(), h.getFlowToDiskMode(), true);
                break;
            }
            case 4: {
                desc.append("Add selectorConsumer.destination:").append(h.getDestinationName()).append(" session:").append(h.getSessionName());
                this.addNonDurableConsumer(h.getAckMode(), h.isTransacted(), h.getDestinationName(), h.getSelector(), h.isNoLocal(), h.getSessionName(), h.getFlowToDiskMode(), true, false);
                break;
            }
            case 1: {
                desc.append("Add queue consumer. queue:").append(h.getDestinationName());
                this.addQueueConsumer(h.getAckMode(), h.isTransacted(), h.getDestinationName(), h.getSelector(), h.isNoLocal(), h.getPrefetchCount(), h.getPrefetchThreshold(), h.getSessionName(), h.getFlowToDiskMode(), true, h.isTempEP());
                break;
            }
            case 2: {
                desc.append("Add durable. destination:").append(h.getDestinationName()).append(" subsc:").append(h.getSubscriptionName());
                this.addDurableConsumer(h.getAckMode(), h.isTransacted(), h.getDestinationName(), h.getSubscriptionName(), h.getSelector(), h.isNoLocal(), h.getSessionName(), h.getFlowToDiskMode(), true);
                break;
            }
            case 3: {
                desc.append("Set msgListener. session:").append(h.getSessionName()).append(" dest:").append(h.getDestinationName());
                this.setMessageListener(h.getAckMode(), h.isTransacted(), (IJMSEndpointListener)h.getListener().clone(), h.getDestinationName(), h.getDestinationType(), h.getSessionName(), h.getFlowToDiskMode(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(boolean reconnect) throws ClassCastException, JMSException, InterruptedException, XQConfigurationException, NoResolvedUrlException {
        ConnectionFactory factory;
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException("Access to connection without the proper lock.");
        }
        this.assertSessionWriteLock();
        if (this.m_connection != null) {
            this.cleanUpSessionPools(reconnect);
            this.m_connection = null;
            this.m_restrictedConnection = null;
        }
        if ((factory = this.getConnectionFactory()) != null) {
            boolean userIdPwdNotSet = this.m_strUserID == null || this.m_strPassword == null;
            SSLLock.lockInterruptibly();
            try {
                this.setSSLParameters();
                this.m_connection = userIdPwdNotSet ? factory.createConnection() : factory.createConnection(this.m_strUserID, this.m_strPassword);
                this.setActionalFlagInternal((progress.message.jimpl.Connection)this.m_connection);
                this.parseURL(this.getConnectionBrokerURL());
                this.m_restrictedConnection = new RestrictedConnection(this.m_connection);
            }
            finally {
                SSLLock.unlock();
            }
            this.setNeedConnect(false);
            JMSBreakPointHelper.addBreakPoint("SSL", this.getClass().getName() + ".connect", System.getProperties());
            for (SessionPool sessionPool : this.m_sessionPools.values()) {
                sessionPool.createSessions(reconnect);
            }
        }
    }

    public synchronized void setActionalFlag() throws JMSException {
        if (this.m_connection instanceof progress.message.jimpl.Connection) {
            this.setActionalFlagInternal((progress.message.jimpl.Connection)this.m_connection);
        }
    }

    private void setActionalFlagInternal(progress.message.jimpl.Connection connection) throws JMSException {
        if (!Thread.holdsLock(this)) {
            throw new IllegalStateException("Access to connection without the proper lock.");
        }
        boolean isActionalEnabled = JMSEndpointContainer.isActionalEnabled();
        boolean displayUnmanagedJmsNodes = JMSEndpointContainer.isUnmanagedJmsNodesEnabled();
        connection.setEnableActionalInstrumentation(isActionalEnabled, displayUnmanagedJmsNodes);
        log.logDebug("Setting following Actional flags on the connection: [isActionalEnabled = '" + isActionalEnabled + "'] [displayUnmanagedJMSNodes = '" + displayUnmanagedJmsNodes + "']");
    }

    public String getBrokerHostName() {
        return this.m_strBrokerHostName;
    }

    public final String getBrokerPassword() {
        return this.m_strPassword;
    }

    public final String getBrokerUserId() {
        return this.m_strUserID;
    }

    public final String getConnectionBrokerURL() {
        if (this.m_connection instanceof progress.message.jclient.Connection) {
            return ((progress.message.jclient.Connection)this.m_connection).getBrokerURL();
        }
        return null;
    }

    public final String getConnectionBrokerRoutingNodeName() {
        if (this.m_connection instanceof progress.message.jclient.Connection) {
            return ((progress.message.jclient.Connection)this.m_connection).getRoutingNodeName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionFactory getConnectionFactory() throws XQConfigurationException, JMSException, NoResolvedUrlException {
        Object cf = null;
        try {
            Object object = cf = SonicConnectionFactory.create(this.m_cfMap, this.m_connectionName, this.m_connectionCfgName, this.m_configManager, this.m_runOutsideContainer);
            return object;
        }
        finally {
            this.m_connectionFactoryClassName = cf != null ? cf.getClass().getName() : null;
        }
    }

    private void cleanUpSessionPools(boolean reconnect) {
        for (SessionPool sessionPool : this.m_sessionPools.values()) {
            sessionPool.clear();
        }
        if (this.m_sessionCollection != null) {
            this.m_sessionCollection.closeAllSessions(reconnect);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("Closed all Session(s)...");
            }
        }
    }

    public final Destination getTempDestFromPool(String sessionPoolName, String sessionName) throws Exception {
        SessionPool pool = this.m_sessionPools.get(sessionPoolName);
        return pool.getTemporaryDestination(sessionName);
    }

    public final MessageConsumer getTempConsumerFromPool(String sessionPoolName, String sessionName) throws Exception {
        SessionPool pool = this.m_sessionPools.get(sessionPoolName);
        return pool.getTemporaryConsumer(sessionName);
    }

    public final void resetTempConsumer(String sessionPoolName, String sessionName) throws Exception {
        SessionPool pool = this.m_sessionPools.get(sessionPoolName);
        pool.resetTemporaryConsumer(sessionName);
    }

    public final String getSessionFromPool(String sessionPoolName, long timeout) throws Exception {
        SessionPool pool = this.m_sessionPools.get(sessionPoolName);
        if (pool == null) {
            throw new Exception("Invalid Session Pool Name");
        }
        String sessionName = pool.getSession(timeout);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("pool.getSession()=" + sessionName);
        }
        return sessionName;
    }

    public final void returnSessionToPool(String sessionName) throws Exception {
        SessionPool pool;
        if (sessionName == null) {
            return;
        }
        int delimitorLoc = sessionName.indexOf(POOLED_SESSION_SUFFIX);
        if (delimitorLoc == -1) {
            throw new Exception("Invalid Session Name: " + sessionName);
        }
        String sessionPoolName = sessionName.substring(0, delimitorLoc);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("MessageBean: returnSessionToPool: sessionPoolName = " + sessionPoolName);
        }
        if ((pool = this.m_sessionPools.get(sessionPoolName)) == null) {
            throw new Exception("Invalid Session Pool: " + sessionPoolName);
        }
        pool.returnSession(sessionName);
    }

    public final void setSessionPool(String name, int nAckMode, boolean bTransacted, int numSessions) {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("MessageBean: creating SessionPool[name=" + name + ", ackMode=" + nAckMode + ", transacted=" + bTransacted + ", numSessions=" + numSessions + "] ...");
        }
        SessionPool newSessionPool = new SessionPool(name, nAckMode, bTransacted, numSessions);
        this.m_sessionPools.put(name, newSessionPool);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(" done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Session getSession(String sessionName) throws JMSException {
        try {
            this.m_sessionLock.readLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JMSException(e.getMessage());
        }
        try {
            Session session = null;
            IJMSEntryEndpointState ees = JMSEndpointStandalone.getJMSEntryEndpointState();
            Session cachedSession = this.m_sessionCollection.getSession(sessionName);
            if (ees != null) {
                session = ees.getSession();
                if (session != null) {
                    if (cachedSession == null) {
                        Session session2 = null;
                        return session2;
                    }
                    if (!session.getSessionName().equals(cachedSession.getSessionName())) {
                        session = cachedSession;
                    } else if (session.getMessagingBean() != cachedSession.getMessagingBean()) {
                        session = cachedSession;
                    }
                } else {
                    session = cachedSession;
                }
            } else {
                session = cachedSession;
            }
            Session session3 = session;
            return session3;
        }
        finally {
            this.m_sessionLock.readLock().unlock();
        }
    }

    private boolean isThreadLocalSession(String sessionName) {
        Session session;
        IJMSEntryEndpointState ees = JMSEndpointStandalone.getJMSEntryEndpointState();
        if (ees != null && (session = ees.getSession()) != null) {
            return session.getSessionName().equals(sessionName);
        }
        return false;
    }

    public final void produceMessage(String destinationName, String destinationType, Message msg, int deliveryMode, int priority, long timeToLive, String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session == null) {
            throw new JMSException("Session " + sessionName + " does not exist. It should use the inbound session for EXACTLY_ONCE outbound sending.");
        }
        session.produceMessage(destinationName, destinationType, msg, deliveryMode, priority, timeToLive);
    }

    public final void produceMessageWithUnbound(String destinationName, String destinationType, Message msg, int deliveryMode, int priority, long timeToLive, String sessionName, XQAddress replyToAddr) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session == null) {
            throw new JMSException("Invalid Session Name: " + sessionName);
        }
        if (replyToAddr instanceof TempDestinationAddress) {
            Destination tempDest = TempDestinationCache.instance().getOrCreateTempDestination(replyToAddr.getName(), (progress.message.jimpl.Session)session.getJMSSession());
            msg.setJMSReplyTo(tempDest);
        }
        session.produceMessageWithUnbound(destinationName, destinationType, msg, deliveryMode, priority, timeToLive);
    }

    public final void produceMessageWithUnbound(Destination destination, Message msg, int deliveryMode, int priority, long timeToLive, String sessionName, XQAddress replyToAddr) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session == null) {
            throw new JMSException("Invalid Session Name: " + sessionName);
        }
        if (replyToAddr instanceof TempDestinationAddress) {
            Destination tempDest = TempDestinationCache.instance().getOrCreateTempDestination(replyToAddr.getName(), (progress.message.jimpl.Session)session.getJMSSession());
            msg.setJMSReplyTo(tempDest);
        }
        session.produceMessageWithUnbound(destination, msg, deliveryMode, priority, timeToLive);
    }

    public final void produceMessage(Destination destination, Message msg, int deliveryMode, int priority, long timeToLive, String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session == null) {
            throw new JMSException("Session " + sessionName + " does not exist. It should use the inbound session for EXACTLY_ONCE outbound sending.");
        }
        session.produceMessage(destination, msg, deliveryMode, priority, timeToLive);
    }

    public final void recover(String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session != null) {
            session.recover();
        }
    }

    public final void rollback(String sessionName) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session != null) {
            session.rollback();
        }
    }

    private void setBrokerHostName(String strBrokerHostName) {
        this.m_strBrokerHostName = strBrokerHostName;
    }

    public final void setBrokerPassword(String strPassword) {
        this.m_strPassword = strPassword;
    }

    public final void setBrokerUserId(String strUserID) {
        this.m_strUserID = strUserID;
    }

    private void parseURL(String brokerURL) {
        int portIndex;
        if (brokerURL == null || "".equals(brokerURL.trim())) {
            return;
        }
        String host = null;
        host = brokerURL.length() >= 6 && "tcp://".equalsIgnoreCase(brokerURL.substring(0, 6)) ? brokerURL.substring(6) : (brokerURL.length() >= 7 && "http://".equalsIgnoreCase(brokerURL.substring(0, 7)) ? brokerURL.substring(7) : (brokerURL.length() >= 6 && "ssl://".equalsIgnoreCase(brokerURL.substring(0, 6)) ? brokerURL.substring(6) : brokerURL));
        int bufsizIndex = host.indexOf(44);
        if (bufsizIndex > 0) {
            String onlyHost = host.substring(0, bufsizIndex);
            String bufsiz = host.substring(bufsizIndex + 1);
            host = onlyHost;
        }
        String onlyHost = (portIndex = host.indexOf(58)) > 0 ? host.substring(0, portIndex) : host;
        this.setBrokerHostName(onlyHost.trim());
    }

    public final synchronized void setExceptionListener(ExceptionListener listener) throws JMSException {
        progress.message.jclient.Connection jconnection;
        int conState;
        this.m_exceptionListener = listener;
        if (this.m_connection == null) {
            return;
        }
        this.m_connection.setExceptionListener(listener);
        if (this.m_connection instanceof progress.message.jclient.Connection && ((conState = (jconnection = (progress.message.jclient.Connection)this.m_connection).getConnectionState()) == 2 || conState == 3)) {
            throw new JMSException(prAccessor.getString((String)"STR008"), Integer.toString(-5));
        }
    }

    public final void setMessageListener(int ackMode, boolean transated, IJMSEndpointListener listener, String destinationName, String destinationType, String sessionName, int flowToDisk, boolean reconnect) throws JMSException {
        Session session = this.getSession(sessionName);
        if (session != null) {
            session.setMessageListener(listener, destinationName, destinationType);
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("Setting MessageListener on session " + session.getSessionName() + "; connectionFactory " + this.m_connectionFactoryClassName);
            }
        } else if (this.isConnected()) {
            throw new JMSException("Unable to set message listener.  Session " + sessionName + " not found.");
        }
        this.addHistoryStructWithLock(reconnect, new HistoryStruct(3, ackMode, transated, listener, destinationName, destinationType, sessionName, flowToDisk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void startConnection() throws JMSException {
        if (!this.m_bConnectionStarted && this.m_connection != null) {
            Object object = this.m_startCloseSyncObject;
            synchronized (object) {
                this.m_connection.start();
            }
            this.m_bConnectionStarted = true;
            if (log.isDebugLoggingEnabled()) {
                log.logDebug("Connection Started...");
            }
        }
    }

    static {
        s_configNamesToSysPropsMap.put("SSL_JSSE_KEY_STORE_KEY_ALIAS", "sonic.mq.ssl.keyStoreClientAlias");
        s_configNamesToSysPropsMap.put("SSL_JSSE_KEY_STORE_KEY_PASSWORD", "sonic.mq.ssl.keyStoreKeyPassword");
        s_configNamesToSysPropsMap.put("SSL_JSSE_KEY_STORE_LOCATION", "javax.net.ssl.keyStore");
        s_configNamesToSysPropsMap.put("SSL_JSSE_KEY_STORE_PASSWORD", "javax.net.ssl.keyStorePassword");
        s_configNamesToSysPropsMap.put("SSL_JSSE_KEY_STORE_TYPE", "javax.net.ssl.keyStoreType");
        s_configNamesToSysPropsMap.put("SSL_JSSE_TRUST_MANAGER", "sonic.mq.ssl.trustManager");
        s_configNamesToSysPropsMap.put("SSL_JSSE_TRUST_STORE_LOCATION", "javax.net.ssl.trustStore");
        s_configNamesToSysPropsMap.put("SSL_JSSE_TRUST_STORE_PASSWORD", "javax.net.ssl.trustStorePassword");
        s_configNamesToSysPropsMap.put("SSL_JSSE_TRUST_STORE_TYPE", "javax.net.ssl.trustStoreType");
    }

    final class SessionPool {
        private final String m_name;
        private final int m_nAckMode;
        private final boolean m_bTransacted;
        private final int m_numSessions;
        private final LinkedList<String> m_pool;
        private final ReentrantLock m_lock;
        private final Condition m_notEmpty;
        private final Map<String, MessageConsumer> m_tempConsumers;
        private final Map<String, Destination> m_tempDests;
        private final boolean m_refreshDestinations;

        public SessionPool(String name, int nAckMode, boolean bTransacted, int numSessions) {
            boolean refreshDestinations;
            this.m_name = name;
            this.m_nAckMode = nAckMode;
            this.m_bTransacted = bTransacted;
            this.m_numSessions = numSessions;
            this.m_pool = new LinkedList();
            this.m_lock = new ReentrantLock();
            this.m_notEmpty = this.m_lock.newCondition();
            this.m_tempConsumers = new ConcurrentHashMap<String, MessageConsumer>();
            this.m_tempDests = new ConcurrentHashMap<String, Destination>();
            try {
                refreshDestinations = Boolean.getBoolean("SonicESB.RefreshDestinationsOnCall");
            }
            catch (SecurityException e) {
                refreshDestinations = false;
            }
            this.m_refreshDestinations = refreshDestinations;
        }

        public final String toString() {
            return "MessagingBean.SessionPool[" + this.m_name + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void clear() {
            this.m_lock.lock();
            try {
                this.m_pool.clear();
            }
            finally {
                this.m_lock.unlock();
            }
            this.m_tempConsumers.clear();
            this.m_tempDests.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void createSessions(boolean reconnect) throws JMSException {
            this.m_lock.lock();
            try {
                for (int i = 0; i < this.m_numSessions; ++i) {
                    String sessionName = this.m_name + MessagingBean.POOLED_SESSION_SUFFIX + i;
                    Session session = MessagingBean.this.addSession(sessionName, this.m_nAckMode, this.m_bTransacted, 0, reconnect);
                    if (this.m_pool.contains(sessionName)) continue;
                    this.m_pool.addFirst(sessionName);
                    if (this.m_refreshDestinations) continue;
                    this.addTemporaryConsumer(session, sessionName);
                }
                this.m_notEmpty.signalAll();
            }
            finally {
                this.m_lock.unlock();
            }
        }

        private void addTemporaryConsumer(Session session, String sessionName) throws JMSException {
            Destination dest = session.addTemporaryDestination("QUEUE");
            MessageConsumer consumer = session.addConsumer(dest);
            this.m_tempConsumers.put(sessionName, consumer);
            this.m_tempDests.put(sessionName, dest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSession(long timeout) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": getSession");
            }
            this.m_lock.lock();
            try {
                long startTime = System.currentTimeMillis();
                while (this.m_pool.size() == 0) {
                    if (log.isDebugLoggingEnabled()) {
                        log.logDebug(Thread.currentThread() + ": getSession: waiting for session from pool. Timeout = " + timeout);
                    }
                    try {
                        if (timeout <= 0L) {
                            this.m_notEmpty.await();
                            continue;
                        }
                        long now = System.currentTimeMillis();
                        long timeRemainingToWait = timeout - (now - startTime);
                        if (timeRemainingToWait > 0L && this.m_notEmpty.await(timeRemainingToWait, TimeUnit.MILLISECONDS)) continue;
                        throw new RuntimeException("No session available to deliver the outgoing message.  This may be due to an in progress broker reconnect.");
                    }
                    catch (InterruptedException ex) {
                    }
                }
                String string = this.m_pool.removeFirst();
                return string;
            }
            finally {
                this.m_lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void returnSession(String sessionName) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": returnSession: " + sessionName);
            }
            this.m_lock.lock();
            try {
                if (!this.m_pool.contains(sessionName)) {
                    this.m_pool.addFirst(sessionName);
                }
                this.m_notEmpty.signal();
            }
            finally {
                this.m_lock.unlock();
            }
        }

        public final MessageConsumer getTemporaryConsumer(String sessionName) {
            return this.m_tempConsumers.get(sessionName);
        }

        public final Destination getTemporaryDestination(String sessionName) {
            return this.m_tempDests.get(sessionName);
        }

        public final void resetTemporaryConsumer(String sessionName) throws JMSException {
            Destination dest;
            if (!this.m_refreshDestinations && (dest = this.m_tempDests.get(sessionName)) != null) {
                Session session = MessagingBean.this.getSession(sessionName);
                session.closeConsumer(dest);
                session.removeTemporaryDestination(dest);
                this.addTemporaryConsumer(session, sessionName);
            }
        }
    }

    protected static class HistoryStruct {
        public int operation;
        private final String m_destinationName;
        private final String m_destinationType;
        private final String m_subscriptionName;
        private final String m_selector;
        private final boolean m_noLocal;
        private final int m_prefetchCount;
        private final int m_prefetchThreshold;
        private final String m_sessionName;
        private final int m_ackMode;
        private final boolean m_transacted;
        private final int m_flowToDisk;
        private final IJMSEndpointListener m_listener;
        private final boolean m_isTempEP;

        HistoryStruct(int op, int ackMode, boolean transacted, String destinationName, String destinationType, String selector, boolean noLocal, int prefetchCount, int prefetchThreshold, String sessionName, int flowToDisk, boolean isTemp) {
            this.operation = op;
            this.m_ackMode = ackMode;
            this.m_transacted = transacted;
            this.m_destinationName = destinationName;
            this.m_destinationType = destinationType;
            this.m_selector = selector;
            this.m_noLocal = noLocal;
            this.m_prefetchCount = prefetchCount;
            this.m_prefetchThreshold = prefetchThreshold;
            this.m_sessionName = sessionName;
            this.m_flowToDisk = flowToDisk;
            this.m_isTempEP = isTemp;
            this.m_subscriptionName = null;
            this.m_listener = null;
        }

        HistoryStruct(int op, int ackMode, boolean transacted, String destinationName, String destinationType, String selector, boolean noLocal, String sessionName, int flowToDisk) {
            this.operation = op;
            this.m_ackMode = ackMode;
            this.m_transacted = transacted;
            this.m_destinationName = destinationName;
            this.m_destinationType = destinationType;
            this.m_selector = selector;
            this.m_noLocal = noLocal;
            this.m_sessionName = sessionName;
            this.m_flowToDisk = flowToDisk;
            this.m_subscriptionName = null;
            this.m_listener = null;
            this.m_prefetchCount = 0;
            this.m_prefetchThreshold = 0;
            this.m_isTempEP = false;
        }

        HistoryStruct(int op, int ackMode, boolean transacted, String destinationName, String destinationType, String subscriptionName, String selector, boolean noLocal, String sessionName, int flowToDisk) {
            this.operation = op;
            this.m_ackMode = ackMode;
            this.m_transacted = transacted;
            this.m_destinationName = destinationName;
            this.m_destinationType = destinationType;
            this.m_subscriptionName = subscriptionName;
            this.m_selector = selector;
            this.m_noLocal = noLocal;
            this.m_sessionName = sessionName;
            this.m_flowToDisk = flowToDisk;
            this.m_listener = null;
            this.m_prefetchCount = 0;
            this.m_prefetchThreshold = 0;
            this.m_isTempEP = false;
        }

        HistoryStruct(int op, String sessionName, int ackMode, boolean transacted, int flowToDisk) {
            this.operation = op;
            this.m_sessionName = sessionName;
            this.m_ackMode = ackMode;
            this.m_transacted = transacted;
            this.m_flowToDisk = flowToDisk;
            this.m_subscriptionName = null;
            this.m_selector = null;
            this.m_noLocal = false;
            this.m_destinationType = null;
            this.m_destinationName = null;
            this.m_listener = null;
            this.m_prefetchCount = 0;
            this.m_prefetchThreshold = 0;
            this.m_isTempEP = false;
        }

        HistoryStruct(int op, int ackMode, boolean transacted, IJMSEndpointListener listener, String destinationName, String destinationType, String sessionName, int flowToDisk) {
            this.operation = op;
            this.m_ackMode = ackMode;
            this.m_transacted = transacted;
            this.m_listener = listener;
            this.m_destinationName = destinationName;
            this.m_destinationType = destinationType;
            this.m_sessionName = sessionName;
            this.m_flowToDisk = flowToDisk;
            this.m_subscriptionName = null;
            this.m_selector = null;
            this.m_noLocal = false;
            this.m_prefetchCount = 0;
            this.m_prefetchThreshold = 0;
            this.m_isTempEP = false;
        }

        public String getDestinationName() {
            return this.m_destinationName;
        }

        public String getDestinationType() {
            return this.m_destinationType;
        }

        public String getSubscriptionName() {
            return this.m_subscriptionName;
        }

        public String getSelector() {
            return this.m_selector;
        }

        public boolean isNoLocal() {
            return this.m_noLocal;
        }

        public int getPrefetchCount() {
            return this.m_prefetchCount;
        }

        public int getPrefetchThreshold() {
            return this.m_prefetchThreshold;
        }

        public String getSessionName() {
            return this.m_sessionName;
        }

        public int getAckMode() {
            return this.m_ackMode;
        }

        public boolean isTransacted() {
            return this.m_transacted;
        }

        public int getFlowToDiskMode() {
            return this.m_flowToDisk;
        }

        public IJMSEndpointListener getListener() {
            return this.m_listener;
        }

        public boolean isTempEP() {
            return this.m_isTempEP;
        }
    }
}

