/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.xmlstream;

import com.sonicsw.xq.service.xcbr.xmlstream.XMLAttributes;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLDuplicateAttributeException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeNameException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeValueException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLProcessingInstructionTag;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLRootTagAlreadyDefinedException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLString;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLTagMarker;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLTagMarkerImpl;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLTagName;
import java.io.DataOutputStream;
import java.util.Vector;

public class XMLOutputStreamImpl
implements XMLOutputStream {
    private StringBuilder outputString;
    private boolean prettyPrint = true;
    private int indent = 0;
    private StringBuilder buffer = new StringBuilder();
    private Vector<XMLTagName> openTags;
    private boolean mainDocumentStarted;
    private String _filename;
    private boolean _isCommentStarted = false;
    private boolean _isStartTagOpen = false;
    private boolean _isStartPIOpen = false;
    private boolean _minimizeOutput = false;
    private boolean _acceptData = false;
    private String _rootElementName;
    private boolean singleLineTag_ = false;
    private static final int INDENT_INITIAL_VALUE = 0;
    private static final String INDENT_VALUE = "   ";
    private static final int INDENT_SIZE = "   ".length();
    private static final boolean PRETTY_PRINT_INITIAL_VALUE = true;
    private static final int INITIAL_STRING_BUFFER_INDEX = 0;
    private static final int NO_OPEN_TAG_CARDINALITY = 0;
    private static final String START_CDATA = "<![CDATA[";
    private static final String END_CDATA = "]]>";

    public XMLOutputStreamImpl() throws Exception {
        this.outputString = new StringBuilder();
    }

    public XMLOutputStreamImpl(String aFilename) throws Exception {
        this();
    }

    public XMLOutputStreamImpl(String argFilename, boolean argVersion) throws Exception {
        this(argFilename);
    }

    @Override
    public void close() throws Exception {
        this.endComment();
    }

    @Override
    public void startDocument() throws XMLInvalidAttributeNameException, XMLInvalidAttributeValueException, XMLDuplicateAttributeException {
        this.endComment();
        this.closeStartTag();
        this.writeDocumentHeader();
    }

    @Override
    public void startDocument(XMLAttributes attributes) throws XMLInvalidAttributeNameException, XMLInvalidAttributeValueException, XMLDuplicateAttributeException {
        this.endComment();
        this.closeStartTag();
        this.writeDocumentHeader();
    }

    @Override
    public void endDocument() throws Exception {
        this.endComment();
        while (this.openTags()) {
            this.endTag();
        }
    }

    @Override
    public void closeTags(XMLTagMarker aMarker) {
        int index = aMarker.getIndex();
        if (index < this.openTags.size()) {
            for (int startSize = this.openTags.size() - 1; index < startSize; --startSize) {
                this.endTag();
            }
        }
    }

    @Override
    public XMLTagMarker getTagMarker() {
        return new XMLTagMarkerImpl(this.getOpenTags().size() - 1);
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public void addPI(String data) throws Exception {
        this.endComment();
        this.closeStartTag();
        if (data != null) {
            String xmlData = XMLString.convertStringToXML(data);
            this.startLine();
            this.writeData(XMLProcessingInstructionTag.XML_PROCESSING_INSTRUCTION_START + xmlData);
            this._isStartPIOpen = true;
        }
    }

    @Override
    public void addPI(String data, XMLAttributes values) throws Exception {
        this.endComment();
        this.closeStartTag();
        if (data != null) {
            this.addPI(data);
            if (values != null) {
                values.print(this);
            }
        }
    }

    @Override
    public void startComment() {
        this.startLine();
        this.closeStartTag();
        this.writeData("<!--");
        this._isCommentStarted = true;
        this.endLine();
    }

    @Override
    public void addComment(String comment) throws Exception {
        if (!this._isCommentStarted) {
            this.startComment();
        }
        if (this._isCommentStarted && comment != null) {
            this.startLine();
            String xmlData = XMLString.convertStringToXML(comment);
            this.writeData(xmlData);
            this.endLine();
        }
    }

    @Override
    public void endComment() {
        if (this._isCommentStarted) {
            this.writeData("-->");
            this._isCommentStarted = false;
            this.endLine();
        }
    }

    @Override
    public void writePublicDTD(String aRootElement, String aName, String aURI) {
        this.endComment();
        this.closeStartTag();
        if (!this.mainDocumentStarted && this._rootElementName == null && aRootElement != null && aRootElement.length() > 0) {
            this.setRootElementName(aRootElement);
            if (aURI != null && aURI.length() > 0) {
                this.writeData("<!DOCTYPE ");
                this.writeData(aRootElement);
                this.writeData(" PUBLIC ");
                this.writeData(aName);
                this.writeData(" ");
                this.writeData(aURI);
                this.writeData(">");
                this.endLine();
            }
        }
    }

    @Override
    public void writeSystemDTD(String aRootElement, String aURI) {
        this.endComment();
        this.closeStartTag();
        if (!this.mainDocumentStarted && aRootElement != null && aRootElement.length() > 0) {
            this.setRootElementName(aRootElement);
            if (aURI != null && aURI.length() > 0) {
                this.writeData("<!DOCTYPE ");
                this.writeData(aRootElement);
                this.writeData(" SYSTEM ");
                this.writeData(aURI);
                this.writeData(">");
                this.endLine();
            }
        }
    }

    @Override
    public void writeTagData(String aData) {
        if (this._isStartTagOpen) {
            this.writeData(">");
            this._isStartTagOpen = false;
            this.writeData(aData);
            this._acceptData = false;
            this.singleLineTag_ = true;
        } else if (this._acceptData) {
            this.writeData(aData);
            this._acceptData = false;
        }
    }

    @Override
    public void startTag(String aName) throws Exception {
        this.endComment();
        this.closeStartTag();
        if (aName != null) {
            this.checkRootTag(aName);
            try {
                this.mainDocumentStarted = true;
                Vector<XMLTagName> currentTags = this.getOpenTags();
                XMLTagName tagValue = new XMLTagName(aName);
                currentTags.addElement(tagValue);
                this.startLine();
                this.writeData("<" + aName);
                this._isStartTagOpen = true;
                this.incrementIndent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startTag(String aNamespace, String aName) {
        this.endComment();
        this.closeStartTag();
        if (aName != null) {
            if (aNamespace != null) {
                this.checkRootTag(aName);
                try {
                    this.mainDocumentStarted = true;
                    Vector<XMLTagName> currentTags = this.getOpenTags();
                    XMLTagName tagValue = new XMLTagName(aNamespace, aName);
                    currentTags.addElement(tagValue);
                    this.startLine();
                    this.writeData("<" + aNamespace + ":" + aName);
                    this._isStartTagOpen = true;
                    this.incrementIndent();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.startTag(aName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void startTag(String aName, XMLAttributes attributes) {
        this.endComment();
        this.closeStartTag();
        if (aName != null) {
            this.checkRootTag(aName);
            try {
                this.mainDocumentStarted = true;
                Vector<XMLTagName> currentTags = this.getOpenTags();
                XMLTagName tagValue = new XMLTagName(aName);
                currentTags.addElement(tagValue);
                this.startLine();
                this.writeData("<" + aName);
                if (attributes != null) {
                    attributes.print(this);
                }
                this._isStartTagOpen = true;
                this.incrementIndent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addAttribute(String aName, String aValue) {
        if (this.canWriteAttributes() && aName != null) {
            this.writeData(" ");
            this.writeData(aName + "=" + "\"");
            if (aValue != null) {
                this.writeData(aValue);
            }
            this.writeData("\"");
        }
    }

    @Override
    public void addAttribute(String argNamespace, String argName, String argValue) {
        if (this.canWriteAttributes() && argName != null) {
            this.writeData(" ");
            this.writeData(argNamespace);
            this.writeData(":");
            this.writeData(argName + "=" + "\"");
            if (argValue != null) {
                this.writeData(argValue);
            }
            this.writeData("\"");
        }
    }

    @Override
    public void endTag() {
        this.closeStartTag();
        this.endComment();
        try {
            if (this.openTags.size() > 0) {
                XMLTagName tagName = this.openTags.lastElement();
                this.decrementIndent();
                if (!this.singleLineTag_) {
                    this.startLine();
                }
                this.singleLineTag_ = false;
                tagName.print(this);
                if (this.openTags.size() > 0) {
                    this.openTags.remove(this.openTags.size() - 1);
                }
                this.endLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("End tag exception raised" + e);
        }
    }

    @Override
    public void writeTag(String aNamespace, String aTagName, XMLAttributes aAttributes, String aData) {
        this.closeStartTag();
        this.endComment();
        try {
            this.startLine();
            this.writeData("<");
            if (aNamespace != null) {
                this.writeData(aNamespace + ":");
            }
            this.writeData(aTagName);
            if (aAttributes != null) {
                aAttributes.print(this);
            }
            this.writeData(">");
            if (aData != null) {
                this.writeData(XMLString.convertStringToXML(aData));
            }
            this.writeData("</");
            if (aNamespace != null) {
                this.writeData(aNamespace + ":");
            }
            this.writeData(aTagName + ">");
            this.endLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeTag(String aNamespace, String aTagName, XMLAttributes aAttributes, String aData, boolean aWriteIfNullString) {
        if (aWriteIfNullString) {
            this.writeTag(aNamespace, aTagName, aAttributes, aData);
        } else if (!aWriteIfNullString && aData != null) {
            this.writeTag(aNamespace, aTagName, aAttributes, aData);
        }
    }

    @Override
    public void writeTag(String aNamespace, String aTagName, XMLAttributes aAttributes, int aData) {
        this.writeTag(aNamespace, aTagName, aAttributes, Integer.toString(aData));
    }

    @Override
    public void writeTag(String aNamespace, String aTagName, XMLAttributes aAttributes, long aData) {
        this.writeTag(aNamespace, aTagName, aAttributes, Long.toString(aData));
    }

    @Override
    public void writeTag(String aNamespace, String aTagName, XMLAttributes aAttributes, boolean aData) {
        String data = "false";
        if (aData) {
            data = "true";
        }
        this.writeTag(aNamespace, aTagName, aAttributes, data);
    }

    @Override
    public void addXMLData(String argXML) throws Exception {
        this.closeStartTag();
        String addedData = argXML;
        if (!argXML.startsWith("<")) {
            throw new Exception("The added XML document must start with < or may not be be a valid XML document");
        }
        if (argXML.startsWith("<?")) {
            int endPIIndex = argXML.indexOf("?>");
            String validXML = argXML.substring(endPIIndex + 2);
            int startTagIndex = validXML.indexOf("<");
            addedData = validXML.substring(startTagIndex);
        }
        this.writeData(addedData);
    }

    @Override
    public void addXMLData(String argXML, boolean argParse) throws Exception {
        String data;
        this.closeStartTag();
        if (argXML.indexOf("<?") == 0) {
            int index = argXML.indexOf("?>");
            data = argXML.substring(index + 2);
        } else {
            data = argXML;
        }
        this.writeData(data);
    }

    @Override
    public void writeCData(String aData) {
        try {
            this.closeStartTag();
            this.startLine();
            this.writeData(START_CDATA);
            if (aData != null) {
                this.writeData(aData);
            }
            this.writeData(END_CDATA);
            this.endLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writePCData(String aData) {
        try {
            this.closeStartTag();
            this.startLine();
            if (aData != null) {
                this.writeData(aData);
            }
            this.endLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void enableMinimalOutput() {
        this._minimizeOutput = true;
    }

    @Override
    public void disableMinimalOutput() {
        this._minimizeOutput = false;
    }

    @Override
    public void toggleMinimalOutput() {
        if (!this._minimizeOutput) {
            this.enableMinimalOutput();
        } else {
            this.disableMinimalOutput();
        }
    }

    @Override
    public boolean isMinimalOutputEnabled() {
        return this._minimizeOutput;
    }

    @Override
    public void enablePrettyPrint() {
        this.prettyPrint = true;
    }

    @Override
    public void disablePrettyPrint() {
        this.prettyPrint = false;
    }

    @Override
    public void writeEmptyTag(String aName, String aValue) {
    }

    @Override
    public boolean isPrettyPrintEnabled() {
        return this.prettyPrint;
    }

    @Override
    public void togglePrettyPrint() {
        if (!this.prettyPrint) {
            this.disablePrettyPrint();
        } else {
            this.enablePrettyPrint();
        }
    }

    @Override
    public DataOutputStream getOutputStream() {
        return null;
    }

    @Override
    public String toString() {
        String returnValue = null;
        returnValue = this.outputString == null ? this.getClass().getName() + " : Filename = " + this._filename : this.outputString.toString();
        return returnValue;
    }

    @Override
    public void add(String aValue) {
        try {
            if (aValue != null) {
                this.writeData(aValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void endLine() {
        if (this.prettyPrint) {
            try {
                this.writeData("\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startLine() {
        if (this.prettyPrint) {
            this.writeIndent();
        }
    }

    private void incrementIndent() {
        ++this.indent;
        this.buffer.append(INDENT_VALUE);
    }

    private void decrementIndent() {
        if (this.indent > 0) {
            --this.indent;
            if (this.indent > 0) {
                this.buffer.delete(this.indent * INDENT_SIZE - 1, this.buffer.length() - 1);
            } else {
                this.buffer.delete(0, this.buffer.length() - 1);
            }
        }
    }

    private void writeIndent() {
        try {
            if (this.indent > 0) {
                this.writeData(this.buffer.substring(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Vector<XMLTagName> getOpenTags() {
        if (this.openTags == null) {
            this.openTags = new Vector();
        }
        return this.openTags;
    }

    private boolean openTags() {
        boolean returnValue = false;
        if (this.openTags != null && this.openTags.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    private void writeData(String data) {
        if (this.outputString != null) {
            this.outputString.append(data);
        }
    }

    private void closeStartTag() {
        if (this._isStartPIOpen) {
            this.writeData(XMLProcessingInstructionTag.XML_PROCESSING_INSTRUCTION_END);
            this._isStartPIOpen = false;
            this.endLine();
        } else if (this._isStartTagOpen) {
            this.writeData(">");
            this._isStartTagOpen = false;
            this.endLine();
        }
    }

    private boolean canWriteAttributes() {
        boolean returnValue = false;
        if (this._isStartPIOpen) {
            returnValue = true;
        } else if (this._isStartTagOpen) {
            returnValue = true;
        }
        return returnValue;
    }

    private void writeDocumentHeader() {
        try {
            this.addPI("xml");
            this.addAttribute("version", "1.0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkRootTag(String aTagName) {
        if (aTagName != null && !this.mainDocumentStarted && this._rootElementName != null && aTagName.compareTo(this._rootElementName) != 0) {
            XMLRootTagAlreadyDefinedException exception = new XMLRootTagAlreadyDefinedException();
            throw exception;
        }
    }

    private void setRootElementName(String aValue) {
        if (aValue != null && this._rootElementName == null) {
            this._rootElementName = aValue;
        }
    }
}

