/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.invk.ESBEndpoint;
import com.sonicsw.xqimpl.invk.ESBException;
import com.sonicsw.xqimpl.invk.ESBService;
import com.sonicsw.xqimpl.invk.ESBServiceFactory;
import com.sonicsw.xqimpl.invkimpl.ESBEndpointImpl;
import com.sonicsw.xqimpl.invkimpl.wsdl.extensions.esb.ESBBinding;
import com.sonicsw.xqimpl.invkimpl.wsdl.extensions.esb.jms.ESBJMSAddress;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFDynamicProvider_ApacheAxis;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.esb.ESBWSIFDynamicProvider;
import com.sonicsw.xqimpl.service.XQContainer;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.util.WSIFUtils;

public class ESBServiceImpl
implements ESBService {
    private static WSIFServiceFactory s_wsifFactory = WSIFServiceFactory.newInstance();
    private static HashMap s_wsdlCache = new HashMap();
    private QName m_name;
    private String m_descriptionLocation;
    private ESBServiceFactory m_factory;

    public ESBServiceImpl(ESBServiceFactory factory, String descriptionLocation, QName serviceName) {
        this.m_factory = factory;
        this.m_name = serviceName;
        this.m_descriptionLocation = descriptionLocation;
    }

    @Override
    public ESBEndpoint getEndpoint(String endpointURL, QName bindingName, QName portTypeName, XQConnectionConfig connectionConfig) throws ESBException {
        ESBEndpointImpl endpoint = null;
        WSIFService wsifService = null;
        if (bindingName == null) {
            bindingName = new QName("http://www.sonicsw.com/sonicxq/", "binding");
        }
        String internalPortName = this.toInternalPortName(bindingName, portTypeName);
        Definition def = this.createWSDLPort(endpointURL, bindingName, portTypeName);
        try {
            wsifService = this.createWSIFService(def, bindingName, portTypeName);
        }
        catch (WSIFException ex) {
            throw new ESBException(ex);
        }
        endpoint = new ESBEndpointImpl(this.m_factory, internalPortName, connectionConfig, wsifService, endpointURL);
        return endpoint;
    }

    private String toInternalPortName(QName bindingName, QName portTypeName) {
        if (bindingName != null && portTypeName != null) {
            return "Port" + bindingName.getLocalPart() + portTypeName.getLocalPart();
        }
        return "esbPort";
    }

    private String toInternalServiceName(QName bindingName, QName portTypeName) {
        if (bindingName != null && portTypeName != null) {
            return "Service" + bindingName.getLocalPart() + portTypeName.getLocalPart();
        }
        return "esbService";
    }

    private WSIFService createWSIFService(Definition def, QName bindingName, QName portTypeName) throws WSIFException {
        String internalServiceName = this.toInternalServiceName(bindingName, portTypeName);
        WSIFService wsifService = s_wsifFactory.getService(def, bindingName != null ? bindingName.getNamespaceURI() : "http://www.sonicsw.com/sonicxq/", internalServiceName, portTypeName == null ? null : portTypeName.getNamespaceURI(), portTypeName == null ? null : portTypeName.getLocalPart());
        return wsifService;
    }

    private Definition createWSDLPort(String endpointURL, QName bindingName, QName portTypeName) throws ESBException {
        Definition def = null;
        Binding selectedBinding = null;
        String internalPortName = this.toInternalPortName(bindingName, portTypeName);
        String internalServiceName = this.toInternalServiceName(bindingName, portTypeName);
        try {
            def = this.getWSDLWithClassLoader(this.m_descriptionLocation);
            QName internalServiceQName = new QName(bindingName.getNamespaceURI(), internalServiceName);
            if (def.getService(internalServiceQName) != null) {
                return def;
            }
            Iterator existingBindings = this.checkWSDL(def);
            while (existingBindings.hasNext()) {
                Binding b = (Binding)existingBindings.next();
                if (!b.getQName().equals(bindingName)) continue;
                selectedBinding = b;
                break;
            }
            if (selectedBinding == null) {
                selectedBinding = def.createBinding();
                selectedBinding.setQName(new QName("http://www.sonicsw.com/sonicxq/", "binding"));
                selectedBinding.setUndefined(false);
                ESBBinding esbRawBinding = new ESBBinding();
                selectedBinding.addExtensibilityElement((ExtensibilityElement)esbRawBinding);
            }
            if (portTypeName != null) {
                for (PortType pt : def.getPortTypes().values()) {
                    if (!pt.getQName().equals(portTypeName)) continue;
                    selectedBinding.setPortType(pt);
                    break;
                }
                if (selectedBinding.getPortType() == null) {
                    throw new ESBException("portType-not-found", new Object[]{portTypeName, this.m_descriptionLocation}, 1);
                }
            } else if (def.getPortTypes().values().iterator().hasNext()) {
                selectedBinding.setPortType((PortType)def.getPortTypes().values().iterator().next());
            } else {
                throw new ESBException("no-portTypes-exist", new Object[]{this.m_descriptionLocation}, 1);
            }
            def.addBinding(selectedBinding);
            Port port = def.createPort();
            port.setName(internalPortName);
            port.setBinding(selectedBinding);
            for (ExtensibilityElement realBinding : selectedBinding.getExtensibilityElements()) {
                ESBJMSAddress portAddress;
                if (realBinding instanceof SOAPBinding) {
                    String transportURI = ((SOAPBinding)realBinding).getTransportURI();
                    if (transportURI.equals("http://schemas.xmlsoap.org/soap/http") || transportURI.equals("http://schemas.xmlsoap.org/ws/soap/duplex")) {
                        portAddress = new SOAPAddressImpl();
                        ((SOAPAddress)portAddress).setLocationURI(endpointURL);
                        port.addExtensibilityElement((ExtensibilityElement)((SOAPAddress)portAddress));
                        continue;
                    }
                    if (!transportURI.equals("http://schemas.xmlsoap.org/soap/jms")) continue;
                    portAddress = new ESBJMSAddress();
                    portAddress.setLocation(endpointURL);
                    port.addExtensibilityElement((ExtensibilityElement)portAddress);
                    continue;
                }
                portAddress = new ESBJMSAddress();
                portAddress.setLocation(endpointURL);
                port.addExtensibilityElement((ExtensibilityElement)portAddress);
            }
            Service service = def.createService();
            service.setQName(new QName(selectedBinding.getQName().getNamespaceURI(), internalServiceName));
            service.addPort(port);
            def.addService(service);
        }
        catch (WSDLException ex) {
            throw new ESBException("unable-to-load-wsdl", new Object[]{this.m_descriptionLocation}, 1, ex);
        }
        return def;
    }

    @Override
    public ESBEndpoint getEndpoint(XQConnectionConfig connectionConfig) throws ESBException {
        ESBEndpointImpl endpoint = null;
        WSIFService wsifService = null;
        try {
            Definition def = this.getWSDLWithClassLoader(this.m_descriptionLocation);
            QName portTypeName = this.getPortType(def, null);
            wsifService = this.createWSIFService(def, portTypeName);
        }
        catch (WSDLException ex) {
            throw new ESBException(ex);
        }
        catch (WSIFException ex) {
            throw new ESBException(ex);
        }
        endpoint = new ESBEndpointImpl(this.m_factory, null, connectionConfig, wsifService, null);
        return endpoint;
    }

    @Override
    public ESBEndpoint getEndpoint(String endpointName, XQConnectionConfig connectionConfig) throws ESBException {
        ESBEndpointImpl endpoint = null;
        WSIFService wsifService = null;
        try {
            Definition def = this.getWSDLWithClassLoader(this.m_descriptionLocation);
            QName portTypeName = this.getPortType(def, endpointName);
            wsifService = this.createWSIFService(def, portTypeName);
        }
        catch (WSDLException ex) {
            throw new ESBException(ex);
        }
        catch (WSIFException ex) {
            throw new ESBException(ex);
        }
        endpoint = new ESBEndpointImpl(this.m_factory, endpointName, connectionConfig, wsifService, null);
        return endpoint;
    }

    private WSIFService createWSIFService(Definition def, QName portTypeName) throws WSIFException {
        WSIFService wsifService = s_wsifFactory.getService(def, this.m_name == null ? null : this.m_name.getNamespaceURI(), this.m_name == null ? null : this.m_name.getLocalPart(), portTypeName == null ? null : portTypeName.getNamespaceURI(), portTypeName == null ? null : portTypeName.getLocalPart());
        return wsifService;
    }

    private QName getPortType(Definition def, String portName) throws ESBException {
        PortType portType;
        Iterator itr;
        Service service = null;
        if (this.m_name != null) {
            service = def.getService(this.m_name);
            if (service == null) {
                throw new ESBException("no-service-definition-exists", new Object[]{this.m_name.getLocalPart(), this.m_descriptionLocation}, 1);
            }
        } else {
            itr = def.getServices().values().iterator();
            if (itr.hasNext()) {
                service = (Service)itr.next();
            } else {
                throw new ESBException("no-services-exist", new Object[]{this.m_descriptionLocation}, 1);
            }
        }
        if (portName != null) {
            portType = service.getPort(portName).getBinding().getPortType();
        } else {
            itr = service.getPorts().values().iterator();
            if (itr.hasNext()) {
                portType = ((Port)itr.next()).getBinding().getPortType();
            } else {
                throw new ESBException("no-portTypes-exist", new Object[]{this.m_descriptionLocation}, 1);
            }
        }
        return portType.getQName();
    }

    private Iterator checkWSDL(Definition def) throws ESBException {
        for (Message v : def.getMessages().values()) {
            if (!v.isUndefined()) continue;
            throw new ESBException("undefined-message", new Object[]{this.m_descriptionLocation, v.getQName().getLocalPart()}, 1);
        }
        for (Message v : def.getPortTypes().values()) {
            if (!v.isUndefined()) continue;
            throw new ESBException("undefined-portType", new Object[]{this.m_descriptionLocation, v.getQName().getLocalPart()}, 1);
        }
        for (Message v : def.getBindings().values()) {
            if (!v.isUndefined()) continue;
            throw new ESBException("undefined-binding", new Object[]{this.m_descriptionLocation, v.getQName().getLocalPart()}, 1);
        }
        return def.getBindings().values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition getWSDL(String URL2) throws WSDLException {
        if (XQContainer.isCacheEnabled()) {
            Definition wsdl = null;
            HashMap hashMap = s_wsdlCache;
            synchronized (hashMap) {
                wsdl = (Definition)s_wsdlCache.get(URL2);
                if (wsdl == null) {
                    wsdl = WSIFUtils.readWSDL(null, (String)URL2);
                    s_wsdlCache.put(URL2, wsdl);
                }
            }
            return wsdl;
        }
        return WSIFUtils.readWSDL(null, (String)URL2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition getWSDLWithClassLoader(String URL2) throws WSDLException {
        ClassLoader cl = this.getClass().getClassLoader();
        if (XQContainer.isCacheEnabled()) {
            Definition wsdl = null;
            HashMap hashMap = s_wsdlCache;
            synchronized (hashMap) {
                wsdl = (Definition)s_wsdlCache.get(URL2);
                if (wsdl == null) {
                    wsdl = WSIFUtils.readWSDL(null, (String)URL2, (ClassLoader)cl);
                    s_wsdlCache.put(URL2, wsdl);
                }
            }
            return wsdl;
        }
        return WSIFUtils.readWSDL(null, (String)URL2, (ClassLoader)cl);
    }

    static {
        s_wsifFactory.setFeature("org.apache.wsif.servicecaching", (Object)new Boolean(XQContainer.isCacheEnabled()));
        WSIFPluggableProviders.overrideDefaultProvider((String)"http://schemas.xmlsoap.org/wsdl/soap/", (WSIFProvider)new ESBWSIFDynamicProvider_ApacheAxis());
        WSIFPluggableProviders.overrideDefaultProvider((String)"http://www.sonicsw.com/sonicxq/", (WSIFProvider)new ESBWSIFDynamicProvider());
    }
}

