/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.Value;

public class InsertionHelper {
    private static final String XSLT_PREFIX = "xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"";
    private static final String XSLT_IDENTITY_TEMPLATE = "   <xsl:template match=\"node()\">      <xsl:copy>         <xsl:copy-of select=\"@*\"/>         <xsl:apply-templates/>      </xsl:copy>   </xsl:template>";
    private static XQLog log = XQLogImpl.getCategoryLog((int)64);

    private static void appendXSLTBegin(StringBuilder xslt, List namespaces) {
        xslt.append("<?xml version=\"1.0\"?>\n");
        xslt.append("<xsl:stylesheet version=\"2.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
        if (namespaces != null) {
            for (Namespace ns : namespaces) {
                xslt.append("\n   xmlns:");
                xslt.append(ns.getPrefix());
                xslt.append("=\"");
                xslt.append(ns.getNamespaceUri());
                xslt.append("\"");
            }
        }
        xslt.append(">\n");
        xslt.append("<xsl:output method=\"xml\"/>\n");
        xslt.append(XSLT_IDENTITY_TEMPLATE);
    }

    private static void appendXSLTEnd(StringBuilder xslt) {
        xslt.append("</xsl:stylesheet>");
    }

    public static String setAttribute(String inputDoc, String xpath, String varName, String value, List namespaces) throws TransformerException {
        StringBuilder xslt = new StringBuilder();
        InsertionHelper.appendXSLTBegin(xslt, namespaces);
        xslt.append("<xsl:template match=\"" + xpath + "\">");
        xslt.append("<xsl:copy>");
        xslt.append("<xsl:copy-of select=\"@*\"/>");
        xslt.append("<xsl:attribute name=\"" + varName + "\">");
        xslt.append(value);
        xslt.append("</xsl:attribute>");
        xslt.append("<xsl:apply-templates/>");
        xslt.append("</xsl:copy>");
        xslt.append("</xsl:template>\n");
        InsertionHelper.appendXSLTEnd(xslt);
        return InsertionHelper.doTransform(xpath, xslt.toString(), inputDoc, namespaces);
    }

    public static String insertLastChild(String inputDoc, String xpath, String value, boolean bReplace, List namespaces) throws TransformerException {
        StringBuilder xslt = new StringBuilder();
        InsertionHelper.appendXSLTBegin(xslt, namespaces);
        xslt.append("<xsl:template match=\"" + xpath + "\">");
        if (bReplace) {
            xslt.append(value);
        } else {
            xslt.append("<xsl:copy>");
            xslt.append("<xsl:copy-of select=\"@*\"/>");
            xslt.append("<xsl:apply-templates/>");
            xslt.append(value);
            xslt.append("</xsl:copy>");
        }
        xslt.append("</xsl:template>");
        InsertionHelper.appendXSLTEnd(xslt);
        return InsertionHelper.doTransform(xpath, xslt.toString(), inputDoc, namespaces);
    }

    public static String insertTextChild(String inputDoc, String xpath, String value, List namespaces) throws TransformerException {
        StringBuilder xslt = new StringBuilder();
        InsertionHelper.appendXSLTBegin(xslt, namespaces);
        xslt.append("<xsl:template match=\"" + xpath + "\">");
        xslt.append("<xsl:copy>");
        xslt.append("<xsl:copy-of select=\"@*\"/>");
        xslt.append("<xsl:text>");
        xslt.append(value);
        xslt.append("</xsl:text>");
        xslt.append("</xsl:copy>");
        xslt.append("</xsl:template>");
        InsertionHelper.appendXSLTEnd(xslt);
        return InsertionHelper.doTransform(xpath, xslt.toString(), inputDoc, namespaces);
    }

    public static String removeChildrenAndInsert(String inputDoc, String xpath, String elemToRemove, String newValue, List namespaces) throws TransformerException {
        StringBuilder xslt = new StringBuilder();
        InsertionHelper.appendXSLTBegin(xslt, namespaces);
        xslt.append("<xsl:template match=\"node()\" mode=\"delete\">");
        xslt.append("<xsl:copy>");
        xslt.append("<xsl:copy-of select=\"@*\"/>");
        xslt.append("<xsl:apply-templates/>");
        xslt.append("</xsl:copy>");
        xslt.append("</xsl:template>");
        xslt.append("<xsl:template match=\"" + elemToRemove + "\" mode=\"delete\"></xsl:template>");
        xslt.append("<xsl:template match=\"" + xpath + "\">");
        xslt.append("<xsl:copy>");
        xslt.append("<xsl:copy-of select=\"@*\"/>");
        xslt.append("<xsl:apply-templates mode=\"delete\"/>");
        xslt.append(newValue);
        xslt.append("</xsl:copy>");
        xslt.append("</xsl:template>");
        InsertionHelper.appendXSLTEnd(xslt);
        return InsertionHelper.doTransform(xpath, xslt.toString(), inputDoc, namespaces);
    }

    public static String assignChildElement(String inputDoc, String xpath, String elemName, String elemValue, boolean bRemoveExisting, List namespaces) throws TransformerException {
        StringBuilder xslt = new StringBuilder();
        InsertionHelper.appendXSLTBegin(xslt, namespaces);
        if (bRemoveExisting) {
            xslt.append("<xsl:template match=\"node()\" mode=\"delete\">");
            xslt.append("<xsl:copy>");
            xslt.append("<xsl:copy-of select=\"@*\"/>");
            xslt.append("<xsl:apply-templates/>");
            xslt.append("</xsl:copy>");
            xslt.append("</xsl:template>");
            xslt.append("<xsl:template match=\"" + elemName + "\" mode=\"delete\"></xsl:template>");
        }
        xslt.append("<xsl:template match=\"" + xpath + "\">");
        xslt.append("<xsl:copy>");
        xslt.append("<xsl:copy-of select=\"@*\"/>");
        if (bRemoveExisting) {
            xslt.append("<xsl:apply-templates mode=\"delete\"/>");
        } else {
            xslt.append("<xsl:apply-templates/>");
        }
        xslt.append("<" + elemName + ">");
        xslt.append(elemValue);
        xslt.append("</" + elemName + ">");
        xslt.append("</xsl:copy>");
        xslt.append("</xsl:template>");
        InsertionHelper.appendXSLTEnd(xslt);
        return InsertionHelper.doTransform(xpath, xslt.toString(), inputDoc, namespaces);
    }

    private static String doTransform(String xpathExpr, String xslSheet, String inputDoc, List namespaces) throws TransformerException {
        NodeInfo n;
        NodeInfo nodeInfo;
        XMLUtils xutils;
        Value v;
        int len;
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("InsertionHelper: XPath=" + xpathExpr);
            log.logDebug("InsertionHelper: Sheet=" + xslSheet);
        }
        if ((len = (v = (xutils = new XMLUtils((Collection)namespaces, false)).computeXPath(nodeInfo = xutils.createNodeInfo((Reader)new StringReader(inputDoc)), xpathExpr)).getLength()) == 0) {
            throw new TransformerException("No matching elements for the XPath expression");
        }
        if (len > 1) {
            throw new TransformerException("XPath must evaluate to exactly one element.");
        }
        Item item = v.itemAt(0);
        if (item instanceof NodeInfo && (n = (NodeInfo)item).getNodeKind() == 1) {
            return xutils.computeXSLT((Source)nodeInfo, (Reader)new StringReader(xslSheet));
        }
        throw new TransformerException("XPath does not evaluate to an element.");
    }
}

